/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.tools.GBC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresetListPanel
extends JPanel {
    public PresetListPanel() {
        super(new GridBagLayout());
    }

    public void updatePresets(int nodes, int ways, int relations, int closedways, Map<String, Map<String, Integer>> valueCount, PresetHandler presetHandler) {
        this.removeAll();
        int total = nodes + ways + relations + closedways;
        if (total == 0) {
            this.setVisible(false);
            return;
        }
        for (TaggingPreset t : TaggingPresetPreference.taggingPresets) {
            if (!(t.types == null || relations > 0 && t.types.contains((Object)TaggingPreset.PresetType.RELATION) || nodes > 0 && t.types.contains((Object)TaggingPreset.PresetType.NODE) || ways + closedways > 0 && t.types.contains((Object)TaggingPreset.PresetType.WAY)) && (closedways <= 0 || !t.types.contains((Object)TaggingPreset.PresetType.CLOSEDWAY)) || !t.isShowable()) continue;
            int found = 0;
            for (TaggingPreset.Item i : t.data) {
                if (i instanceof TaggingPreset.Key) {
                    Map<String, Integer> v;
                    String val = ((TaggingPreset.Key)i).value;
                    String key = ((TaggingPreset.Key)i).key;
                    found -= 100;
                    if (key == null || !valueCount.containsKey(key) || (v = valueCount.get(key)).size() != 1 || val == null || !v.containsKey(val) || v.get(val) != total) continue;
                    found += 101;
                    continue;
                }
                String key = null;
                if (i instanceof TaggingPreset.Text && ((TaggingPreset.Text)i).required) {
                    key = ((TaggingPreset.Text)i).key;
                } else if (i instanceof TaggingPreset.Combo && ((TaggingPreset.Combo)i).required) {
                    key = ((TaggingPreset.Combo)i).key;
                } else if (i instanceof TaggingPreset.Check && ((TaggingPreset.Check)i).required) {
                    key = ((TaggingPreset.Check)i).key;
                }
                if (key == null) continue;
                if (valueCount.get(key) != null) {
                    ++found;
                    continue;
                }
                found -= 100;
            }
            if (found <= 0) continue;
            JLabel lbl = new JLabel(t.getName());
            lbl.addMouseListener(new PresetLabelML(lbl, t, presetHandler));
            this.add((Component)lbl, GBC.eol().fill(2));
        }
        if (this.getComponentCount() > 0) {
            this.setVisible(true);
            int height = this.getComponentCount() * this.getComponent(0).getHeight();
            Dimension size = new Dimension(this.getWidth(), height);
            this.setMaximumSize(size);
            this.setMinimumSize(size);
        } else {
            this.setVisible(false);
        }
    }

    private static class PresetLabelML
    implements MouseListener {
        final JLabel label;
        final Font bold;
        final Font normal;
        final TaggingPreset tag;
        final PresetHandler presetHandler;

        PresetLabelML(JLabel lbl, TaggingPreset t, PresetHandler presetHandler) {
            this.label = lbl;
            lbl.setCursor(new Cursor(12));
            this.normal = this.label.getFont();
            this.bold = this.normal.deriveFont(this.normal.getStyle() ^ 1);
            this.tag = t;
            this.presetHandler = presetHandler;
        }

        public void mouseClicked(MouseEvent arg0) {
            Collection<OsmPrimitive> selection = this.presetHandler.getSelection();
            if (selection == null || selection.isEmpty()) {
                return;
            }
            int answer = this.tag.showDialog(selection, false);
            if (answer == 1) {
                this.presetHandler.updateTags(this.tag.getChangedTags());
            }
        }

        public void mouseEntered(MouseEvent arg0) {
            this.label.setFont(this.bold);
        }

        public void mouseExited(MouseEvent arg0) {
            this.label.setFont(this.normal);
        }

        public void mousePressed(MouseEvent arg0) {
        }

        public void mouseReleased(MouseEvent arg0) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PresetHandler {
        public Collection<OsmPrimitive> getSelection();

        public void updateTags(List<Tag> var1);
    }
}

