/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class GpxImporter
extends FileImporter {
    public GpxImporter() {
        super(new ExtensionFileFilter("gpx,gpx.gz", "gpx", I18n.tr("GPX Files") + " (*.gpx *.gpx.gz)"));
    }

    public void importData(final File file, ProgressMonitor progressMonitor) throws IOException {
        final String fn = file.getName();
        try {
            InputStream is = file.getName().endsWith(".gpx.gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
            final GpxReader r = new GpxReader(is);
            final boolean parsedProperly = r.parse(true);
            r.data.storageFile = file;
            final GpxLayer gpxLayer = new GpxLayer(r.data, fn, true);
            Runnable task = new Runnable(){

                public void run() {
                    if (r.data.hasRoutePoints() || r.data.hasTrackPoints()) {
                        Main.main.addLayer(gpxLayer);
                    }
                    if (Main.pref.getBoolean("marker.makeautomarkers", true) && !r.data.waypoints.isEmpty()) {
                        MarkerLayer ml = new MarkerLayer(r.data, I18n.tr("Markers from {0}", fn), file, gpxLayer);
                        if (ml.data.size() > 0) {
                            Main.main.addLayer(ml);
                        }
                    }
                    if (!parsedProperly) {
                        JOptionPane.showMessageDialog(null, I18n.tr("Error occured while parsing gpx file {0}. Only part of the file will be available", file.getName()));
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                task.run();
            } else {
                SwingUtilities.invokeLater(task);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new IOException(I18n.tr("File \"{0}\" does not exist", file.getName()));
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(I18n.tr("Parsing file \"{0}\" failed", file.getName()));
        }
    }
}

