/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.DefinedName;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Workbook;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.FunctionLookup;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.OperandLookup;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.OperatorLookup;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.Token;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.TokenFactory;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class TokenDecoder {
    private TokenFactory tf = new TokenFactory();
    private FunctionLookup fl = new FunctionLookup();
    private OperatorLookup operatorLookup = new OperatorLookup();
    private OperandLookup operandLookup = new OperandLookup();
    private Workbook wb;

    public void setWorkbook(Workbook workbook) {
        Debug.log(4, "TokenDecoder : setWorkbook");
        this.wb = workbook;
    }

    public Vector getTokenVector(byte[] byArray) {
        Vector<Token> vector = new Vector<Token>();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n = 0;
        block13: while ((n = byteArrayInputStream.read()) != -1) {
            switch (n) {
                case 59: {
                    Debug.log(4, "Decoded 3D Area Cell Reference: ");
                    vector.add(this.read3DCellAreaRefToken(byteArrayInputStream));
                    Debug.log(4, "Decoded 3D Area Cell Reference: " + vector.lastElement());
                    continue block13;
                }
                case 58: {
                    Debug.log(4, "Decoded 3D Cell Reference: ");
                    vector.add(this.read3DCellRefToken(byteArrayInputStream));
                    Debug.log(4, "Decoded 3D Cell Reference: " + vector.lastElement());
                    continue block13;
                }
                case 68: {
                    vector.add(this.readCellRefToken(byteArrayInputStream));
                    Debug.log(4, "Decoded Cell Reference: " + vector.lastElement());
                    continue block13;
                }
                case 37: {
                    vector.add(this.readCellAreaRefToken(byteArrayInputStream));
                    Debug.log(4, "Decoded Cell Area Reference: " + vector.lastElement());
                    continue block13;
                }
                case 31: {
                    vector.add(this.readNumToken(byteArrayInputStream));
                    Debug.log(4, "Decoded number : " + vector.lastElement());
                    continue block13;
                }
                case 66: {
                    vector.add(this.readFunctionVarToken(byteArrayInputStream));
                    Debug.log(4, "Decoded variable argument function: " + vector.lastElement());
                    continue block13;
                }
                case 65: {
                    vector.add(this.readFunctionToken(byteArrayInputStream));
                    Debug.log(4, "Decoded function: " + vector.lastElement());
                    continue block13;
                }
                case 23: {
                    vector.add(this.readStringToken(byteArrayInputStream));
                    Debug.log(4, "Decoded string: " + vector.lastElement());
                    continue block13;
                }
                case 35: {
                    vector.add(this.readNameToken(byteArrayInputStream));
                    Debug.log(4, "Decoded defined name: " + vector.lastElement());
                    continue block13;
                }
                case 18: 
                case 19: 
                case 20: {
                    vector.add(this.readOperatorToken(n, 1));
                    Debug.log(4, "Decoded Unary operator : " + vector.lastElement());
                    continue block13;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    vector.add(this.readOperatorToken(n, 2));
                    Debug.log(4, "Decoded Binary operator : " + vector.lastElement());
                    continue block13;
                }
            }
            Debug.log(4, "Unrecognized byte : " + n);
        }
        return vector;
    }

    private char int2Char(int n) {
        return (char)(65 + n);
    }

    private Token readStringToken(ByteArrayInputStream byteArrayInputStream) {
        int n = byteArrayInputStream.read() * 2;
        int n2 = byteArrayInputStream.read();
        Debug.log(4, "String length is " + n + " and Options Flag is " + n2);
        byte[] byArray = new byte[n];
        int n3 = 0;
        n3 = byteArrayInputStream.read(byArray, 0, n);
        if (n3 != n) {
            Debug.log(4, "Expected " + n + " bytes. Could only read " + n3 + " bytes.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        try {
            Debug.log(4, "Using LE encoding");
            stringBuffer.append(new String(byArray, "UTF-16LE"));
        }
        catch (IOException iOException) {
            stringBuffer.append(new String(byArray));
        }
        stringBuffer.append('\"');
        return this.tf.getOperandToken(stringBuffer.toString(), "STRING");
    }

    private Token readNameToken(ByteArrayInputStream byteArrayInputStream) {
        byte[] byArray = new byte[]{(byte)byteArrayInputStream.read(), (byte)byteArrayInputStream.read()};
        int n = EndianConverter.readShort(byArray);
        byteArrayInputStream.skip(12L);
        Enumeration enumeration = this.wb.getDefinedNames();
        for (int i = 1; i < n; ++i) {
            enumeration.nextElement();
        }
        Debug.log(4, "Name index is " + n);
        DefinedName definedName = (DefinedName)enumeration.nextElement();
        Debug.log(4, "DefinedName is " + definedName.getName());
        return this.tf.getOperandToken(definedName.getName(), "NAME");
    }

    private Token readCellRefToken(ByteArrayInputStream byteArrayInputStream) {
        byte[] byArray = new byte[2];
        String string = new String();
        byArray[0] = (byte)byteArrayInputStream.read();
        byArray[1] = (byte)byteArrayInputStream.read();
        int n = EndianConverter.readShort(byArray);
        int n2 = (n & 0xC000) >> 14;
        byte by = (byte)byteArrayInputStream.read();
        string = this.int2CellStr(n &= 0x3FFF, by, n2);
        return this.tf.getOperandToken(string, "CELL_REFERENCE");
    }

    private Token read3DCellRefToken(ByteArrayInputStream byteArrayInputStream) {
        byte[] byArray = new byte[2];
        String string = new String();
        byteArrayInputStream.skip(10L);
        byArray[0] = (byte)byteArrayInputStream.read();
        byArray[1] = (byte)byteArrayInputStream.read();
        short s = EndianConverter.readShort(byArray);
        byArray[0] = (byte)byteArrayInputStream.read();
        byArray[1] = (byte)byteArrayInputStream.read();
        short s2 = EndianConverter.readShort(byArray);
        byArray[0] = (byte)byteArrayInputStream.read();
        byArray[1] = (byte)byteArrayInputStream.read();
        int n = EndianConverter.readShort(byArray);
        int n2 = (n & 0xC000) >> 14;
        byte by = (byte)byteArrayInputStream.read();
        String string2 = "." + this.int2CellStr(n &= 0x3FFF, by, n2);
        string = s == s2 ? "$" + this.wb.getSheetName(s) + string2 : "$" + this.wb.getSheetName(s) + string2 + ":$" + this.wb.getSheetName(s2) + string2;
        return this.tf.getOperandToken(string, "3D_CELL_REFERENCE");
    }

    private Token read3DCellAreaRefToken(ByteArrayInputStream byteArrayInputStream) {
        byte[] byArray = new byte[2];
        String string = new String();
        byteArrayInputStream.skip(10L);
        byArray[0] = (byte)byteArrayInputStream.read();
        byArray[1] = (byte)byteArrayInputStream.read();
        short s = EndianConverter.readShort(byArray);
        byArray[0] = (byte)byteArrayInputStream.read();
        byArray[1] = (byte)byteArrayInputStream.read();
        short s2 = EndianConverter.readShort(byArray);
        byArray[0] = (byte)byteArrayInputStream.read();
        byArray[1] = (byte)byteArrayInputStream.read();
        int n = EndianConverter.readShort(byArray);
        int n2 = (n & 0xC000) >> 14;
        n &= 0x3FFF;
        byArray[0] = (byte)byteArrayInputStream.read();
        byArray[1] = (byte)byteArrayInputStream.read();
        int n3 = EndianConverter.readShort(byArray);
        int n4 = (n3 & 0xC000) >> 14;
        byte by = (byte)byteArrayInputStream.read();
        byte by2 = (byte)byteArrayInputStream.read();
        String string2 = "." + this.int2CellStr(n, by, n2);
        String string3 = this.int2CellStr(n3 &= 0x3FFF, by2, n4);
        string = s == s2 ? "$" + this.wb.getSheetName(s) + string2 + ":" + string3 : "$" + this.wb.getSheetName(s) + string2 + ":$" + this.wb.getSheetName(s2) + "." + string3;
        return this.tf.getOperandToken(string, "3D_CELL_AREA_REFERENCE");
    }

    private String int2CellStr(int n, int n2, int n3) {
        String string = "";
        int n4 = (n2 + 1) / 26;
        if ((n3 & 1) == 0) {
            string = string + "$";
        }
        if (n4 > 0) {
            int n5 = (n2 + 1) % 26;
            string = string + Character.toString(this.int2Char(n4 - 1)) + Character.toString(this.int2Char(n5 - 1));
        } else {
            string = string + Character.toString(this.int2Char(n2));
        }
        if ((n3 & 2) == 0) {
            string = string + "$";
        }
        string = string + Integer.toString(n + 1);
        return string;
    }

    private Token readCellAreaRefToken(ByteArrayInputStream byteArrayInputStream) {
        byte[] byArray = new byte[2];
        String string = new String();
        byArray[0] = (byte)byteArrayInputStream.read();
        byArray[1] = (byte)byteArrayInputStream.read();
        int n = EndianConverter.readShort(byArray);
        int n2 = (n & 0xC000) >> 14;
        n &= 0x3FFF;
        byArray[0] = (byte)byteArrayInputStream.read();
        byArray[1] = (byte)byteArrayInputStream.read();
        int n3 = EndianConverter.readShort(byArray);
        int n4 = (n3 & 0xC000) >> 14;
        byte by = (byte)byteArrayInputStream.read();
        byte by2 = (byte)byteArrayInputStream.read();
        string = this.int2CellStr(n, by, n2);
        string = string + ":" + this.int2CellStr(n3 &= 0x3FFF, by2, n4);
        return this.tf.getOperandToken(string, "CELL_AREA_REFERENCE");
    }

    private Token readNumToken(ByteArrayInputStream byteArrayInputStream) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)byteArrayInputStream.read();
        }
        return this.tf.getOperandToken(Double.toString(EndianConverter.readDouble(byArray)), "NUMBER");
    }

    private Token readOperatorToken(int n, int n2) {
        Token token = n == 18 ? this.tf.getOperatorToken("+", n2) : (n == 19 ? this.tf.getOperatorToken("-", n2) : this.tf.getOperatorToken(this.operatorLookup.getStringFromID(n), n2));
        return token;
    }

    private Token readFunctionVarToken(ByteArrayInputStream byteArrayInputStream) {
        int n = 0;
        n = byteArrayInputStream.read();
        byte[] byArray = new byte[]{(byte)byteArrayInputStream.read(), (byte)byteArrayInputStream.read()};
        short s = EndianConverter.readShort(byArray);
        return this.tf.getFunctionToken(this.fl.getStringFromID(s), n);
    }

    private Token readFunctionToken(ByteArrayInputStream byteArrayInputStream) {
        byte[] byArray = new byte[]{(byte)byteArrayInputStream.read(), (byte)byteArrayInputStream.read()};
        short s = EndianConverter.readShort(byArray);
        String string = this.fl.getStringFromID(s);
        return this.tf.getFunctionToken(string, this.fl.getArgCountFromString(string));
    }
}

