/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.spi;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class FastProjectKindDetector
extends DefaultHandler {
    private String[] tags = new String[10];
    private int currDepth = 0;
    private boolean inProjectTypeTag;
    private boolean inTypeTag;

    FastProjectKindDetector() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tags[this.currDepth] = qName;
        ++this.currDepth;
        if ("property".equals(qName)) {
            if ("javacard.project.subtype".equals(attributes.getValue("name"))) {
                this.inProjectTypeTag = true;
            }
        } else if ("type".equals(qName)) {
            this.inTypeTag = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.tags[this.currDepth] = null;
        --this.currDepth;
        this.inProjectTypeTag = false;
        this.inTypeTag = false;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String val;
        if (this.inTypeTag && !"org.netbeans.modules.javacard.JCPROJECT".equals(val = new String(ch, start, length))) {
            throw new SAXException("Not a javacard project: " + val);
        }
        if (this.inProjectTypeTag) {
            String type = new String(ch, start, length);
            throw new FoundProjectTypeException(type);
        }
    }

    static final class FoundProjectTypeException
    extends SAXException {
        private FoundProjectTypeException(String type) {
            super(type);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            return new StackTraceElement[0];
        }
    }
}

