/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.web.beans.api.model.BeansModel;
import org.netbeans.modules.web.beans.api.model.Result;
import org.netbeans.modules.web.beans.impl.model.AnnotationObjectProvider;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;
import org.netbeans.modules.web.beans.impl.model.results.ErrorImpl;
import org.netbeans.modules.web.beans.impl.model.results.InjectableResultImpl;
import org.netbeans.modules.web.beans.impl.model.results.ResolutionErrorImpl;
import org.netbeans.modules.web.beans.impl.model.results.ResultImpl;
import org.openide.util.NbBundle;

class EnableBeansFilter {
    private Set<Element> myAlternatives;
    private Set<Element> myEnabledAlternatives;
    private ResultImpl myResult;
    private final AnnotationModelHelper myHelper;
    private final BeansModel myBeansModel;

    EnableBeansFilter(ResultImpl resultImpl, WebBeansModelImplementation webBeansModelImplementation) {
        this.myResult = resultImpl;
        this.myHelper = webBeansModelImplementation.getHelper();
        this.myBeansModel = webBeansModelImplementation.getBeansModel();
    }

    Result filter() {
        boolean bl;
        Object object;
        this.myAlternatives = new HashSet<Element>();
        this.myEnabledAlternatives = new HashSet<Element>();
        Set<TypeElement> set = this.getResult().getTypeElements();
        for (TypeElement hashSet2 : set) {
            if (!this.getResult().isAlternative(hashSet2)) continue;
            this.myAlternatives.add(hashSet2);
            this.addEnabledAlternative(hashSet2, hashSet2);
        }
        Set<Element> set2 = this.getResult().getProductions();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            object = (Element)iterator.next();
            TypeElement typeElement = this.myHelper.getCompilationController().getElementUtilities().enclosingTypeElement((Element)object);
            if (!this.getResult().isAlternative((Element)object)) continue;
            this.myAlternatives.add((Element)object);
            this.addEnabledAlternative(typeElement, (Element)object);
        }
        HashSet<Element> hashSet = new HashSet<Element>(set);
        object = new HashSet(set2);
        this.myAlternatives.removeAll(this.myEnabledAlternatives);
        object.removeAll(this.myAlternatives);
        hashSet.removeAll(this.myAlternatives);
        int n = hashSet.size();
        int n2 = object.size();
        Set<Element> set3 = this.findEnabledTypes(hashSet);
        this.findEnabledProductions((Set<Element>)object);
        int n3 = set3.size() + object.size();
        if (n3 == 1) {
            Element element = set3.size() == 0 ? (Element)object.iterator().next() : set3.iterator().next();
            set3.addAll((Collection<Element>)object);
            return new InjectableResultImpl(this.getResult(), element, set3);
        }
        if (n3 == 0) {
            if (set.size() == 0 && set2.size() == 0) {
                return new ErrorImpl(this.getResult().getVariable(), this.getResult().getVariableType(), NbBundle.getMessage(EnableBeansFilter.class, (String)"ERR_NoFound"));
            }
            if (n == 0 && n2 == 0) {
                return new ResolutionErrorImpl(this.getResult(), NbBundle.getMessage(EnableBeansFilter.class, (String)"ERR_AlternativesOnly"));
            }
            return new ResolutionErrorImpl(this.getResult(), NbBundle.getMessage(EnableBeansFilter.class, (String)"ERR_NoEnabledBeans"));
        }
        HashSet<Element> hashSet2 = new HashSet<Element>(set3);
        hashSet2.addAll((Collection<Element>)object);
        hashSet2.retainAll(this.myEnabledAlternatives);
        boolean bl2 = bl = hashSet2.size() == 1;
        if (bl) {
            set3.addAll((Collection<Element>)object);
            return new InjectableResultImpl(this.getResult(), (Element)hashSet2.iterator().next(), set3);
        }
        set3.addAll((Collection<Element>)object);
        String string = NbBundle.getMessage(EnableBeansFilter.class, (String)"ERR_UnresolvedAmbiguousDependency");
        return new ResolutionErrorImpl(this.getResult(), string, set3);
    }

    private void findEnabledProductions(Set<Element> set) {
        Iterator<Element> iterator = set.iterator();
        while (iterator.hasNext()) {
            Element element = iterator.next();
            TypeElement typeElement = this.getHelper().getCompilationController().getElementUtilities().enclosingTypeElement(element);
            if (!this.getResult().isAlternative(typeElement)) continue;
            String string = typeElement.getQualifiedName().toString();
            if (this.getResult().hasAlternative(typeElement) && !this.getModel().getAlternativeClasses().contains(string)) {
                iterator.remove();
            }
            if (this.alternativeStereotypesEnabled(typeElement)) continue;
            iterator.remove();
        }
    }

    private Set<Element> findEnabledTypes(Set<Element> set) {
        LinkedList<Element> linkedList = new LinkedList<Element>(set);
        HashSet<Element> hashSet = new HashSet<Element>(set);
        while (linkedList.size() != 0) {
            TypeElement typeElement = (TypeElement)linkedList.remove();
            if (typeElement.getKind() != ElementKind.CLASS) {
                hashSet.remove(typeElement);
                continue;
            }
            this.checkProxyability(typeElement, linkedList, hashSet);
            this.checkSpecializes(typeElement, linkedList, hashSet, set);
        }
        return hashSet;
    }

    private void checkProxyability(TypeElement typeElement, LinkedList<Element> linkedList, Set<Element> set) {
        if (this.hasModifier(typeElement, Modifier.FINAL)) {
            linkedList.remove(typeElement);
            set.remove(typeElement);
            return;
        }
        List<ExecutableElement> list = ElementFilter.methodsIn(typeElement.getEnclosedElements());
        for (ExecutableElement executableElement : list) {
            if (!this.hasModifier(executableElement, Modifier.FINAL)) continue;
            linkedList.remove(typeElement);
            set.remove(typeElement);
            return;
        }
        List<ExecutableElement> list2 = ElementFilter.constructorsIn(typeElement.getEnclosedElements());
        boolean bl = false;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ExecutableElement executableElement = (ExecutableElement)iterator.next();
            if (this.hasModifier(executableElement, Modifier.PRIVATE) || executableElement.getParameters().size() != 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            linkedList.remove(typeElement);
            set.remove(typeElement);
        }
    }

    private boolean hasModifier(Element element, Modifier modifier) {
        Set<Modifier> set = element.getModifiers();
        for (Modifier modifier2 : set) {
            if (!modifier2.equals((Object)modifier)) continue;
            return true;
        }
        return false;
    }

    private void checkSpecializes(TypeElement typeElement, LinkedList<Element> linkedList, Set<Element> set, Set<Element> set2) {
        TypeMirror typeMirror;
        TypeElement typeElement2 = typeElement;
        while (typeElement2 != null && (typeMirror = typeElement2.getSuperclass()) instanceof DeclaredType && AnnotationObjectProvider.hasSpecializes(typeElement2, this.getHelper())) {
            TypeElement typeElement3 = (TypeElement)((DeclaredType)typeMirror).asElement();
            if (set2.contains(typeElement3)) {
                set.remove(typeElement3);
            }
            linkedList.remove(typeElement3);
            if (!this.getResult().getTypeElements().contains(typeElement3)) break;
            typeElement2 = typeElement3;
        }
    }

    private void addEnabledAlternative(TypeElement typeElement, Element element) {
        String string = typeElement.getQualifiedName().toString();
        if (this.getResult().hasAlternative(element) && !this.getModel().getAlternativeClasses().contains(string)) {
            return;
        }
        if (this.alternativeStereotypesEnabled(element)) {
            this.myEnabledAlternatives.add(element);
        }
    }

    private boolean alternativeStereotypesEnabled(Element element) {
        List<AnnotationMirror> list = this.getResult().getStereotypes(element);
        for (AnnotationMirror annotationMirror : list) {
            DeclaredType declaredType = annotationMirror.getAnnotationType();
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            if (!this.getResult().isAlternative(typeElement)) continue;
            if (this.getResult().hasAlternative(typeElement)) {
                String string = typeElement.getQualifiedName().toString();
                if (this.getModel().getAlternativeStereotypes().contains(string)) continue;
                return false;
            }
            if (this.alternativeStereotypesEnabled(typeElement)) continue;
            return false;
        }
        return true;
    }

    private ResultImpl getResult() {
        return this.myResult;
    }

    private BeansModel getModel() {
        return this.myBeansModel;
    }

    private AnnotationModelHelper getHelper() {
        return this.myHelper;
    }
}

