/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleCache;
import org.apache.felix.framework.cache.BundleRevision;
import org.apache.felix.framework.cache.DirectoryContent;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.moduleloader.IContent;

class DirectoryRevision
extends BundleRevision {
    private final File m_refDir;

    public DirectoryRevision(Logger logger, Map configMap, File revisionRootDir, String location) throws Exception {
        super(logger, configMap, revisionRootDir, location);
        this.m_refDir = new File(location.substring(location.indexOf("file:") + "file:".length()));
        if (BundleCache.getSecureAction().fileExists(this.getRevisionRootDir())) {
            return;
        }
        if (!BundleCache.getSecureAction().mkdir(this.getRevisionRootDir())) {
            this.getLogger().log(1, this.getClass().getName() + ": Unable to create revision directory.");
            throw new IOException("Unable to create archive directory.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map getManifestHeader() throws Exception {
        InputStream is = null;
        try {
            is = BundleCache.getSecureAction().getFileInputStream(new File(this.m_refDir, "META-INF/MANIFEST.MF"));
            if (is == null) {
                throw new IOException("No manifest file found.");
            }
            Manifest mf = new Manifest(is);
            StringMap stringMap = new StringMap(mf.getMainAttributes(), false);
            return stringMap;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public synchronized IContent getContent() throws Exception {
        return new DirectoryContent(this.getLogger(), this.getConfig(), this, this.getRevisionRootDir(), this.m_refDir);
    }

    protected void close() throws Exception {
    }
}

