/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.openide.util.NbPreferences;

public class BugtrackingConfig {
    private static BugtrackingConfig instance = null;
    private static final String ARCHIVED_TTL_KEY = "bugtracking.archived_time_to_live";
    private static final String COLUMN_WIDTH_PREFIX = "bugtracking.issuetable.columnwidth";
    private static final String COLUMN_SORTING_PREFIX = "bugtracking.issuetable.columnsorting";
    private static long DEFAULT_ARCHIVED_TTL = 7L;

    private BugtrackingConfig() {
    }

    public static BugtrackingConfig getInstance() {
        if (instance == null) {
            instance = new BugtrackingConfig();
        }
        return instance;
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(BugtrackingConfig.class);
    }

    public void setArchivedIssuesTTL(int l) {
        this.getPreferences().putLong(ARCHIVED_TTL_KEY, l);
    }

    public long getArchivedIssuesTTL() {
        return this.getPreferences().getLong(ARCHIVED_TTL_KEY, DEFAULT_ARCHIVED_TTL);
    }

    public void storeColumns(String key, String columns) {
        this.getPreferences().put("bugtracking.issuetable.columnwidth." + key, columns);
    }

    public String getColumns(String key) {
        return this.getPreferences().get("bugtracking.issuetable.columnwidth." + key, "");
    }

    @Deprecated
    public int[] getColumnWidths(String key) {
        ArrayList<Integer> retval = new ArrayList<Integer>();
        try {
            String[] keys = this.getPreferences().keys();
            for (int i = 0; i < keys.length; ++i) {
                String k = keys[i];
                if (k == null || !k.startsWith("bugtracking.issuetable.columnwidth." + key + ".")) continue;
                int idx = Integer.parseInt(k.substring(k.lastIndexOf(46) + 1));
                int value = this.getPreferences().getInt(k, -1);
                retval.add(idx, value);
                this.getPreferences().remove(k);
            }
            int[] ret = new int[retval.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (Integer)retval.get(i);
            }
            return ret;
        }
        catch (Exception ex) {
            BugtrackingManager.LOG.log(Level.INFO, null, ex);
            return new int[0];
        }
    }

    public void storeColumnSorting(String columnsKey, String sorting) {
        this.getPreferences().put("bugtracking.issuetable.columnsorting." + columnsKey, sorting);
    }

    public String getColumnSorting(String key) {
        return this.getPreferences().get("bugtracking.issuetable.columnsorting." + key, "");
    }
}

