/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.ProxySettings;

public class MylynUtils {
    public static TaskRepository createTaskRepository(String connectorKind, String name, String url, String user, String password, String httpUser, String httpPassword) {
        TaskRepository repository = new TaskRepository(connectorKind, url);
        MylynUtils.setCredentials(repository, user, password, httpUser, httpPassword);
        return repository;
    }

    public static void setCredentials(TaskRepository repository, String user, String password, String httpUser, String httpPassword) {
        String host;
        MylynUtils.logCredentials(repository, user, password, "Setting credentials: ");
        AuthenticationCredentials authenticationCredentials = new AuthenticationCredentials(user != null ? user : "", password != null ? password : "");
        repository.setCredentials(AuthenticationType.REPOSITORY, authenticationCredentials, false);
        if (httpUser != null || httpPassword != null) {
            if (httpUser == null) {
                httpUser = "";
            }
            if (httpPassword == null) {
                httpPassword = "";
            }
            MylynUtils.logCredentials(repository, httpUser, httpPassword, "Setting http credentials: ");
            authenticationCredentials = new AuthenticationCredentials(httpUser, httpPassword);
            repository.setCredentials(AuthenticationType.HTTP, authenticationCredentials, false);
        }
        try {
            host = new URL(repository.getUrl()).getHost();
        }
        catch (MalformedURLException ex) {
            BugtrackingManager.LOG.log(Level.WARNING, repository.getUrl(), ex);
            host = repository.getUrl();
        }
        ProxySettings ps = new ProxySettings();
        BugtrackingManager.LOG.log(Level.FINEST, "Proxy: {0}", ps.toString());
        if (!ps.isDirect() && !MylynUtils.isNonProxyHost(ps.getNotProxyHosts(), host)) {
            repository.setDefaultProxyEnabled(false);
            String proxyHost = ps.getHttpHost();
            String proxyPort = ps.getHttpPort();
            if (proxyHost == null || proxyHost.equals("")) {
                proxyHost = ps.getHttpsHost();
                proxyPort = ps.getHttpsPort();
            }
            if (proxyHost != null && !proxyHost.equals("")) {
                BugtrackingManager.LOG.log(Level.FINEST, "Setting proxy: [{0}:{1},{2}]", new Object[]{proxyHost, proxyPort, repository.getUrl()});
                repository.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.hostname", proxyHost);
                repository.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.port", proxyPort);
                String proxyUser = ps.getUsername();
                String proxyPassword = ps.getPassword();
                if (proxyUser != null || proxyPassword != null) {
                    if (proxyUser == null) {
                        proxyUser = "";
                    }
                    if (proxyPassword == null) {
                        proxyPassword = "";
                    }
                    MylynUtils.logCredentials(repository, proxyUser, proxyPassword, "Setting proxy credentials: ");
                    authenticationCredentials = new AuthenticationCredentials(proxyUser, proxyPassword);
                    repository.setCredentials(AuthenticationType.PROXY, authenticationCredentials, false);
                }
            }
        }
    }

    public static void logCredentials(TaskRepository repository, String user, String psswd, String msg) {
        BugtrackingManager.LOG.log(Level.FINEST, msg + "[{0}, user={1}, password={2}]", new Object[]{repository.getUrl(), user, BugtrackingUtil.getPasswordLog(psswd)});
    }

    private static boolean isNonProxyHost(String nonProxyHosts, String host) {
        if (nonProxyHosts.equals("")) {
            return false;
        }
        return MylynUtils.dontUseHostName(nonProxyHosts, host) || MylynUtils.dontUseIp(nonProxyHosts, host);
    }

    private static boolean dontUseHostName(String nonProxyHosts, String host) {
        if (host == null) {
            return false;
        }
        boolean dontUseProxy = false;
        StringTokenizer st = new StringTokenizer(nonProxyHosts, ",", false);
        while (st.hasMoreTokens() && !dontUseProxy) {
            String token = st.nextToken().trim();
            int star = token.indexOf("*");
            if (star == -1) {
                dontUseProxy = token.equals(host);
                if (!dontUseProxy) continue;
                BugtrackingManager.LOG.log(Level.FINEST, "Host {0} found in nonProxyHosts: {1}", new Object[]{host, nonProxyHosts});
                continue;
            }
            String start = token.substring(0, star - 1 < 0 ? 0 : star - 1);
            String end = token.substring(star + 1 > token.length() ? token.length() : star + 1);
            boolean bl = dontUseProxy = host.startsWith(start) && host.endsWith(end);
            if (!dontUseProxy) {
                if (end.length() > 1 && end.charAt(0) == '.') {
                    end = end.substring(1, end.length());
                }
                if (start.length() > 1 && start.charAt(start.length() - 1) == '.') {
                    start = start.substring(0, start.length() - 1);
                }
                boolean bl2 = dontUseProxy = host.startsWith(start) && host.endsWith(end);
            }
            if (!dontUseProxy) continue;
            BugtrackingManager.LOG.log(Level.FINEST, "Host {0} found in nonProxyHosts: {1}", new Object[]{host, nonProxyHosts});
        }
        return dontUseProxy;
    }

    private static boolean dontUseIp(String nonProxyHosts, String host) {
        if (host == null) {
            return false;
        }
        String ip = null;
        try {
            ip = InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException ex) {
            BugtrackingManager.LOG.log(Level.FINE, ex.getLocalizedMessage(), ex);
        }
        if (ip == null) {
            return false;
        }
        boolean dontUseProxy = false;
        StringTokenizer st = new StringTokenizer(nonProxyHosts, ",", false);
        while (st.hasMoreTokens() && !dontUseProxy) {
            String nonProxyHost = st.nextToken();
            int star = nonProxyHost.indexOf("*");
            if (star == -1) {
                dontUseProxy = nonProxyHost.equals(ip);
                if (!dontUseProxy) continue;
                BugtrackingManager.LOG.log(Level.FINEST, "Host''s {0} IP {1} found in nonProxyHosts: {2}", new Object[]{host, ip, nonProxyHosts});
                continue;
            }
            try {
                dontUseProxy = Pattern.matches(nonProxyHost, ip);
                if (!dontUseProxy) continue;
                BugtrackingManager.LOG.log(Level.FINEST, "Host''s {0} IP{1} found in nonProxyHosts: {2}", new Object[]{host, ip, nonProxyHosts});
            }
            catch (PatternSyntaxException pse) {}
        }
        return dontUseProxy;
    }
}

