/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Date;
import java.util.prefs.Preferences;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.collab.chat.ChatPanel;
import org.netbeans.modules.kenai.ui.spi.MessagingHandle;
import org.openide.awt.Notification;
import org.openide.util.NbPreferences;

public class MessagingHandleImpl
extends MessagingHandle {
    private static final String LASTMESSAGEAT = ".last.message.at";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Notification notification;
    private int onlineCount;
    private int messageCount = 0;
    private Date lastMessage;
    private Date lastMessageRead;
    private String id;
    private static Preferences prefs = NbPreferences.forModule(MessagingHandleImpl.class);

    MessagingHandleImpl(KenaiProject prj) {
        this.id = prj.getName();
        Kenai k = prj.getKenai();
        this.onlineCount = prj.isMyProject() && k.getStatus() == Kenai.Status.ONLINE ? -2 : -1;
        this.lastMessage = this.lastMessageRead = new Date(Long.parseLong(prefs.get(this.id + LASTMESSAGEAT, "0")));
    }

    @Override
    public int getMessageCount() {
        return this.messageCount;
    }

    public void setMessageCount(int messageCount) {
        int oldMessageCount = this.messageCount;
        this.messageCount = messageCount;
        this.propertyChangeSupport.firePropertyChange("messageCount", oldMessageCount, messageCount);
    }

    @Override
    public int getOnlineCount() {
        return this.onlineCount;
    }

    public void setOnlineCount(int onlineCount) {
        int oldOnlineCount = this.onlineCount;
        this.onlineCount = onlineCount;
        this.propertyChangeSupport.firePropertyChange("onlineCount", oldOnlineCount, onlineCount);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void notifyMessageReceived(Message m) {
        this.lastMessage = ChatPanel.getTimestamp((Packet)m);
        if (this.lastMessage.after(this.lastMessageRead)) {
            this.setMessageCount(this.messageCount + 1);
        }
    }

    public void notifyMessagesRead() {
        this.lastMessageRead = this.lastMessage;
        prefs.put(this.id + LASTMESSAGEAT, Long.toString(this.lastMessageRead.getTime()));
        this.setMessageCount(0);
    }

    public void updateNotification(Notification notification) {
        this.disposeNotification();
        this.notification = notification;
    }

    void disposeNotification() {
        if (this.notification != null) {
            this.notification.clear();
        }
    }
}

