/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.ui.KenaiDialogDescriptor;
import org.netbeans.modules.kenai.ui.KenaiSearchPanel;
import org.netbeans.modules.kenai.ui.KenaiTopComponent;
import org.netbeans.modules.kenai.ui.ProjectHandleImpl;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.modules.kenai.ui.spi.Dashboard;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public final class OpenKenaiProjectAction
extends AbstractAction {
    private String dialogTitle = NbBundle.getMessage(OpenKenaiProjectAction.class, (String)"OpenKenaiProjectWindowTitle");
    private Kenai kenai;

    public OpenKenaiProjectAction(Kenai kenai) {
        this.kenai = kenai;
    }

    public OpenKenaiProjectAction() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        KenaiProject[] selProjects;
        final JButton open = new JButton(NbBundle.getMessage(OpenKenaiProjectAction.class, (String)"OpenKenaiProjectAction.OpenFromKenai"));
        open.setDefaultCapable(true);
        open.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OpenKenaiProjectAction.class, (String)"OpenKenaiProjectAction.OpenFromKenai"));
        JButton cancel = new JButton(NbBundle.getMessage(OpenKenaiProjectAction.class, (String)"OpenKenaiProjectAction.Cancel"));
        cancel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OpenKenaiProjectAction.class, (String)"OpenKenaiProjectAction.Cancel"));
        KenaiSearchPanel openPanel = new KenaiSearchPanel(KenaiSearchPanel.PanelType.OPEN, true, this.kenai != null ? this.kenai : Utilities.getPreferredKenai());
        openPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectionValid".equals(evt.getPropertyName())) {
                    open.setEnabled((Boolean)evt.getNewValue());
                }
            }
        });
        KenaiDialogDescriptor dialogDesc = new KenaiDialogDescriptor(openPanel, this.dialogTitle, true, null);
        dialogDesc.setOptions(new Object[]{open, cancel});
        dialogDesc.setOptionType(2);
        Object option = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDesc);
        if (open.equals(option) && null != (selProjects = openPanel.getSelectedProjects()) && selProjects.length > 0) {
            for (KenaiProject prj : selProjects) {
                Dashboard.getDefault().addProject(new ProjectHandleImpl(prj), false, true);
            }
            KenaiTopComponent.findInstance().open();
            KenaiTopComponent.findInstance().requestActive();
        }
    }
}

