/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.folding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.editor.folding.CppFile;
import org.netbeans.modules.cnd.editor.folding.ParsingEvent;
import org.netbeans.modules.cnd.editor.folding.ParsingListener;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

final class CppMetaModel
implements PropertyChangeListener {
    private int reparseDelay = 1000;
    private Map<String, CppFile> map = new ConcurrentHashMap<String, CppFile>();
    private Collection<ParsingListener> listeners = new ConcurrentLinkedQueue<ParsingListener>();
    private static CppMetaModel instance = new CppMetaModel();
    private static RequestProcessor cppParserRP;
    private static final Logger log;
    private RequestProcessor.Task task = null;

    private CppMetaModel() {
    }

    public static CppMetaModel getDefault() {
        return instance;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("opened".equals(evt.getPropertyName())) {
            this.checkClosed(evt.getNewValue());
        }
    }

    private void checkClosed(Object o) {
        if (o instanceof Set) {
            HashSet<EditorCookie> editorCookies = new HashSet<EditorCookie>();
            for (Object top : (Set)o) {
                EditorCookie cookie;
                if (!(top instanceof EditorCookie) || !MIMENames.isFortranOrHeaderOrCppOrC((String)DocumentUtilities.getMimeType((Document)(cookie = (EditorCookie)top).getDocument()))) continue;
                editorCookies.add(cookie);
            }
            this.checkClosed(editorCookies);
        }
    }

    private void checkClosed(Set<EditorCookie> editors) {
        HashSet<String> opened = new HashSet<String>();
        for (EditorCookie editor : editors) {
            StyledDocument doc = editor.getDocument();
            if (doc == null) continue;
            String tittle = (String)doc.getProperty("title");
            opened.add(tittle);
        }
        ArrayList<String> toDelete = new ArrayList<String>();
        for (String title : this.map.keySet()) {
            if (opened.contains(title)) continue;
            toDelete.add(title);
        }
        for (String title : toDelete) {
            this.map.remove(title);
        }
        if (this.map.size() == 0 && this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    private static synchronized RequestProcessor getCppParserRP() {
        if (cppParserRP == null) {
            cppParserRP = new RequestProcessor("CPP Parser", 1);
        }
        return cppParserRP;
    }

    public void scheduleParsing(final Document doc) {
        final String title = (String)doc.getProperty("title");
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "CppMetaModel.scheduleParsing: Checking " + this.getShortName(doc) + " [" + Thread.currentThread().getName() + "]");
        }
        if (title == null) {
            log.log(Level.INFO, "CppMetaModel.scheduleParsing: No Title for document" + this.getShortName(doc));
            return;
        }
        final CppFile file = this.map.get(title);
        if (this.task != null) {
            this.task.cancel();
        }
        if (file == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "CppMetaModel.scheduleParsing: Starting initial parse for " + this.getShortName(doc));
            }
            this.task = CppMetaModel.getCppParserRP().post(new Runnable(){

                @Override
                public void run() {
                    CppFile file = new CppFile(title);
                    CppMetaModel.this.map.put(title, file);
                    file.startParsing(doc);
                    CppMetaModel.this.fireObjectParsed(doc);
                }
            }, this.reparseDelay);
        } else if (file.needsUpdate()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "CppMetaModel.scheduleParsing: Starting update parse for " + this.getShortName(doc));
            }
            this.task = CppMetaModel.getCppParserRP().post(new Runnable(){

                @Override
                public void run() {
                    file.startParsing(doc);
                    CppMetaModel.this.fireObjectParsed(doc);
                }
            }, this.reparseDelay);
        }
    }

    private void fireObjectParsed(Document doc) {
        Object o = doc.getProperty("stream");
        if (o instanceof DataObject) {
            DataObject dobj = (DataObject)o;
            for (ParsingListener listener : this.listeners) {
                listener.objectParsed(new ParsingEvent(dobj));
            }
        }
    }

    private String getShortName(Document doc) {
        String longname = (String)doc.getProperty("title");
        if (longname == null) {
            return doc.toString();
        }
        int slash = longname.lastIndexOf(File.separatorChar);
        if (slash != -1) {
            return longname.substring(slash + 1);
        }
        return longname;
    }

    public CppFile get(String key) {
        return this.map.get(key);
    }

    public void addParsingListener(ParsingListener listener) {
        this.listeners.add(listener);
    }

    public void removeParsingListener(ParsingListener listener) {
        this.listeners.remove(listener);
    }

    static {
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)instance);
        log = Logger.getLogger(CppMetaModel.class.getName());
    }
}

