/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.options;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.options.BracePlacementProperty;
import org.netbeans.modules.cnd.editor.options.EditorOptions;
import org.netbeans.modules.cnd.editor.options.PreviewPreferences;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

public class VisibilityIndentProperty
extends PropertySupport.ReadWrite<CodeStyle.VisibilityIndent> {
    private final CodeStyle.Language language;
    private final String optionID;
    private PreviewPreferences preferences;
    private CodeStyle.VisibilityIndent state;
    private PropertyEditor editor;

    public VisibilityIndentProperty(CodeStyle.Language language, PreviewPreferences preferences, String optionID) {
        super(optionID, CodeStyle.VisibilityIndent.class, VisibilityIndentProperty.getString("LBL_" + optionID), VisibilityIndentProperty.getString("HINT_" + optionID));
        this.language = language;
        this.optionID = optionID;
        this.preferences = preferences;
        this.init();
    }

    private static String getString(String key) {
        return NbBundle.getMessage(BracePlacementProperty.class, (String)key);
    }

    private void init() {
        this.state = CodeStyle.VisibilityIndent.valueOf(this.getPreferences().get(this.optionID, this.getDefault().name()));
    }

    private CodeStyle.VisibilityIndent getDefault() {
        return CodeStyle.VisibilityIndent.valueOf((String)EditorOptions.getDefault(this.getPreferences().getLanguage(), this.getPreferences().getStyleId(), this.optionID));
    }

    private PreviewPreferences getPreferences() {
        return this.preferences;
    }

    public String getHtmlDisplayName() {
        if (!this.isDefaultValue()) {
            return "<b>" + this.getDisplayName();
        }
        return null;
    }

    public CodeStyle.VisibilityIndent getValue() {
        return this.state;
    }

    public void setValue(CodeStyle.VisibilityIndent v) {
        this.state = v;
        this.getPreferences().put(this.optionID, this.state.name());
    }

    public void restoreDefaultValue() {
        this.setValue(this.getDefault());
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public boolean isDefaultValue() {
        return this.getDefault().equals((Object)this.getValue());
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new VisibilityIndentEditor();
        }
        return this.editor;
    }

    private static class VisibilityIndentEditor
    extends PropertyEditorSupport {
        private VisibilityIndentEditor() {
        }

        @Override
        public String[] getTags() {
            try {
                CodeStyle.VisibilityIndent[] values = CodeStyle.VisibilityIndent.values();
                String[] tags = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tags[i] = values[i].toString();
                }
                return tags;
            }
            catch (Exception x) {
                throw new AssertionError((Object)x);
            }
        }

        @Override
        public String getAsText() {
            Object o = this.getValue();
            return o != null ? o.toString() : "";
        }

        @Override
        public void setAsText(String text) {
            if (text.length() > 0) {
                CodeStyle.VisibilityIndent[] values = CodeStyle.VisibilityIndent.values();
                for (int i = 0; i < values.length; ++i) {
                    if (!values[i].toString().equals(text)) continue;
                    this.setValue((Object)values[i]);
                    return;
                }
            }
            this.setValue(null);
        }

        @Override
        public String getJavaInitializationString() {
            CodeStyle.VisibilityIndent e = (CodeStyle.VisibilityIndent)((Object)this.getValue());
            return e != null ? CodeStyle.VisibilityIndent.class.getName().replace('$', '.') + '.' + e.name() : "null";
        }
    }
}

