/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository.register;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RepositoryRegisterUI
extends JPanel {
    private static File lastFolder = new File(System.getProperty("user.home"));
    private boolean modify = false;
    private boolean singleType = false;
    private boolean alreadyFilled = false;
    private JButton btnBrowse;
    private JButton btnOK;
    private ButtonGroup buttonGroup1;
    private JComboBox comType;
    private JRadioButton jraLocal;
    private JRadioButton jraRemote;
    private JLabel lblHeader;
    private JLabel lblIndexUrl;
    private JLabel lblRepoId;
    private JLabel lblRepoName;
    private JLabel lblRepoPath;
    private JLabel lblRepoType;
    private JLabel lblRepoUrl;
    private JLabel lblType;
    private JLabel lblValidate;
    private JTextField txtIndexUrl;
    private JTextField txtRepoId;
    private JTextField txtRepoName;
    private JTextField txtRepoPath;
    private JTextField txtRepoUrl;

    public RepositoryRegisterUI() {
        this.initComponents();
        this.validateInfo();
        String[] types = RepositoryIndexer.getAvailableTypes();
        if (types.length == 1) {
            this.lblType.setVisible(false);
            this.comType.setVisible(false);
            this.singleType = true;
        }
        this.comType.setModel(new DefaultComboBoxModel<String>(types));
        this.comType.setSelectedItem("nexus");
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.btnOK = new JButton();
        this.lblHeader = new JLabel();
        this.lblRepoId = new JLabel();
        this.txtRepoId = new JTextField();
        this.lblRepoName = new JLabel();
        this.txtRepoName = new JTextField();
        this.lblType = new JLabel();
        this.comType = new JComboBox();
        this.lblRepoType = new JLabel();
        this.jraLocal = new JRadioButton();
        this.jraRemote = new JRadioButton();
        this.lblRepoPath = new JLabel();
        this.txtRepoPath = new JTextField();
        this.btnBrowse = new JButton();
        this.lblRepoUrl = new JLabel();
        this.lblIndexUrl = new JLabel();
        this.txtIndexUrl = new JTextField();
        this.txtRepoUrl = new JTextField();
        this.lblValidate = new JLabel();
        this.btnOK.setText(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"CMB_Repo_ADD", (Object[])new Object[0]));
        this.btnOK.setEnabled(false);
        this.lblHeader.setText(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_Register_Header", (Object[])new Object[0]));
        this.lblRepoId.setLabelFor(this.txtRepoId);
        Mnemonics.setLocalizedText((JLabel)this.lblRepoId, (String)NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_ID", (Object[])new Object[0]));
        this.txtRepoId.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                RepositoryRegisterUI.this.txtRepoIdKeyReleased(evt);
            }
        });
        this.lblRepoName.setLabelFor(this.txtRepoName);
        Mnemonics.setLocalizedText((JLabel)this.lblRepoName, (String)NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_Name", (Object[])new Object[0]));
        this.txtRepoName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                RepositoryRegisterUI.this.txtRepoNameKeyReleased(evt);
            }
        });
        this.lblType.setLabelFor(this.comType);
        Mnemonics.setLocalizedText((JLabel)this.lblType, (String)NbBundle.getMessage(RepositoryRegisterUI.class, (String)"RepositoryRegisterUI.lblType.text"));
        this.comType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.lblRepoType.setText(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_Type", (Object[])new Object[0]));
        this.buttonGroup1.add(this.jraLocal);
        this.jraLocal.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jraLocal, (String)NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_Type_Local", (Object[])new Object[0]));
        this.jraLocal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryRegisterUI.this.jraLocalActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jraRemote);
        Mnemonics.setLocalizedText((AbstractButton)this.jraRemote, (String)NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_Type_Remote", (Object[])new Object[0]));
        this.jraRemote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryRegisterUI.this.jraRemoteActionPerformed(evt);
            }
        });
        this.lblRepoPath.setLabelFor(this.txtRepoPath);
        Mnemonics.setLocalizedText((JLabel)this.lblRepoPath, (String)NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_Path", (Object[])new Object[0]));
        this.txtRepoPath.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                RepositoryRegisterUI.this.txtRepoPathKeyTyped(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnBrowse, (String)NbBundle.getMessage(RepositoryRegisterUI.class, (String)"CMD_Repo_Path_Browse", (Object[])new Object[0]));
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryRegisterUI.this.btnBrowseActionPerformed(evt);
            }
        });
        this.lblRepoUrl.setLabelFor(this.txtRepoUrl);
        Mnemonics.setLocalizedText((JLabel)this.lblRepoUrl, (String)NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_URL", (Object[])new Object[0]));
        this.lblIndexUrl.setLabelFor(this.txtIndexUrl);
        Mnemonics.setLocalizedText((JLabel)this.lblIndexUrl, (String)NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_Index_Url", (Object[])new Object[0]));
        this.txtIndexUrl.setEnabled(false);
        this.txtIndexUrl.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                RepositoryRegisterUI.this.txtIndexUrlKeyReleased(evt);
            }
        });
        this.txtRepoUrl.setEnabled(false);
        this.txtRepoUrl.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                RepositoryRegisterUI.this.txtRepoUrlKeyReleased(evt);
            }
        });
        this.lblValidate.setForeground(new Color(204, 0, 0));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lblValidate, -1, 801, Short.MAX_VALUE).add((Component)this.lblHeader, -1, 801, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lblRepoName).add((Component)this.lblRepoId, -1, 309, Short.MAX_VALUE).add((Component)this.lblType)).add(14, 14, 14).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.txtRepoId, -1, 478, Short.MAX_VALUE).add((Component)this.txtRepoName, -1, 478, Short.MAX_VALUE).add(1, (Component)this.comType, -2, 220, -2))))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(22, 22, 22).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.lblRepoType, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jraLocal, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(21, 21, 21).add((Component)this.lblRepoPath)).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jraRemote, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(21, 21, 21).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.lblIndexUrl, -1, -1, Short.MAX_VALUE).add(1, (Component)this.lblRepoUrl))))))).addPreferredGap(0, 30, -2).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.txtIndexUrl, -1, 630, Short.MAX_VALUE).add((Component)this.txtRepoUrl, -1, 630, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.txtRepoPath, -1, 566, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnBrowse))))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.lblHeader).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblRepoId).add((Component)this.txtRepoId, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblRepoName).add((Component)this.txtRepoName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblType).add((Component)this.comType, -2, -1, -2)).addPreferredGap(1).add((Component)this.lblRepoType).addPreferredGap(0).add((Component)this.jraLocal).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblRepoPath).add((Component)this.btnBrowse).add((Component)this.txtRepoPath, -2, -1, -2)).addPreferredGap(0).add((Component)this.jraRemote).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblRepoUrl).add((Component)this.txtRepoUrl, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblIndexUrl).add((Component)this.txtIndexUrl, -2, -1, -2)).addPreferredGap(0, 24, Short.MAX_VALUE).add((Component)this.lblValidate, -2, 17, -2)));
        this.txtRepoId.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"RepositoryRegisterUI.txtRepoId.AccessibleContext.accessibleDescription"));
        this.txtRepoName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"RepositoryRegisterUI.txtRepoName.AccessibleContext.accessibleDescription"));
        this.comType.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"RepositoryRegisterUI.comType.AccessibleContext.accessibleDescription"));
        this.jraLocal.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"RepositoryRegisterUI.jraLocal.AccessibleContext.accessibleDescription"));
        this.jraRemote.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"RepositoryRegisterUI.jraRemote.AccessibleContext.accessibleDescription"));
        this.txtRepoPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"RepositoryRegisterUI.txtRepoPath.AccessibleContext.accessibleDescription"));
        this.btnBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"RepositoryRegisterUI.btnBrowse.AccessibleContext.accessibleDescription"));
        this.txtIndexUrl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"RepositoryRegisterUI.txtIndexUrl.AccessibleContext.accessibleDescription"));
        this.txtRepoUrl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"RepositoryRegisterUI.txtRepoUrl.AccessibleContext.accessibleDescription"));
    }

    private void btnBrowseActionPerformed(ActionEvent evt) {
        int ret;
        File fil;
        JFileChooser chooser = new JFileChooser(lastFolder);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_Path_Header", (Object[])new Object[0]));
        chooser.setMultiSelectionEnabled(false);
        if (this.txtRepoPath.getText().trim().length() > 0 && (fil = new File(this.txtRepoPath.getText().trim())).exists()) {
            chooser.setSelectedFile(fil);
        }
        if ((ret = chooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_SELECT", (Object[])new Object[0]))) == 0) {
            this.txtRepoPath.setText(chooser.getSelectedFile().getAbsolutePath());
            this.txtRepoPath.requestFocusInWindow();
        }
        this.validateInfo();
    }

    private void jraLocalActionPerformed(ActionEvent evt) {
        this.txtRepoUrl.setEnabled(false);
        this.txtIndexUrl.setEnabled(false);
        this.txtRepoPath.setEnabled(true);
        this.btnBrowse.setEnabled(true);
        this.validateInfo();
    }

    private void jraRemoteActionPerformed(ActionEvent evt) {
        this.selectRemoteRepo(true);
    }

    private void selectRemoteRepo(boolean checkValidity) {
        this.txtRepoPath.setEnabled(false);
        this.btnBrowse.setEnabled(false);
        this.txtRepoUrl.setEnabled(true);
        this.txtIndexUrl.setEnabled(true);
        if (checkValidity) {
            this.validateInfo();
        }
    }

    private void txtRepoIdKeyReleased(KeyEvent evt) {
        this.validateInfo();
    }

    private void txtRepoPathKeyTyped(KeyEvent evt) {
        this.validateInfo();
    }

    private void txtRepoNameKeyReleased(KeyEvent evt) {
        this.validateInfo();
    }

    private void txtRepoUrlKeyReleased(KeyEvent evt) {
        this.validateInfo();
    }

    private void txtIndexUrlKeyReleased(KeyEvent evt) {
        this.validateInfo();
    }

    public void modify(RepositoryInfo info) {
        this.modify = true;
        this.txtRepoId.setEnabled(false);
        this.txtRepoId.setText(info.getId());
        this.txtRepoName.setText(info.getName());
        if (this.singleType && info.getType() != null) {
            this.comType.setSelectedItem(info.getType());
        }
        if (info.isLocal()) {
            this.jraLocal.setSelected(true);
            this.txtRepoPath.setText(info.getRepositoryPath());
            this.jraLocalActionPerformed(null);
        } else if (info.isRemoteDownloadable()) {
            this.jraRemote.setSelected(true);
            this.txtRepoUrl.setText(info.getRepositoryUrl());
            this.txtIndexUrl.setText(info.getIndexUpdateUrl());
            this.jraRemoteActionPerformed(null);
        }
    }

    public RepositoryInfo getRepositoryInfo() {
        RepositoryInfo info = new RepositoryInfo(this.txtRepoId.getText().trim(), (String)this.comType.getSelectedItem(), this.txtRepoName.getText().trim(), this.jraLocal.isSelected() ? this.txtRepoPath.getText().trim() : null, this.jraRemote.isSelected() ? this.txtRepoUrl.getText().trim() : null, this.jraRemote.isSelected() ? this.txtIndexUrl.getText().trim() : null);
        return info;
    }

    private void validateInfo() {
        if (this.txtRepoId.getText().trim().length() == 0) {
            this.btnOK.setEnabled(false);
            this.lblValidate.setText(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_id_Error1"));
            return;
        }
        if (!this.modify) {
            RepositoryInfo info = RepositoryPreferences.getInstance().getRepositoryInfoById(this.txtRepoId.getText().trim());
            if (info != null && (info.isLocal() || info.isRemoteDownloadable())) {
                this.btnOK.setEnabled(false);
                this.lblValidate.setText(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_id_Error2"));
                return;
            }
            if (info != null && !this.alreadyFilled) {
                this.txtRepoUrl.setText(info.getRepositoryUrl());
                this.txtRepoName.setText(info.getName());
                this.jraRemote.setSelected(true);
                this.selectRemoteRepo(false);
                this.alreadyFilled = true;
            }
        }
        if (this.txtRepoName.getText().trim().length() == 0) {
            this.btnOK.setEnabled(false);
            this.lblValidate.setText(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_Name_Error1"));
            return;
        }
        if (this.jraLocal.isSelected()) {
            if (this.txtRepoPath.getText().trim().length() == 0 || !new File(this.txtRepoPath.getText().trim()).exists()) {
                this.btnOK.setEnabled(false);
                this.lblValidate.setText(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_Path_Error"));
                return;
            }
        } else {
            if (this.txtRepoUrl.getText().trim().length() == 0) {
                this.btnOK.setEnabled(false);
                this.lblValidate.setText(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_Url_Error"));
                return;
            }
            if (this.txtIndexUrl.getText().trim().length() == 0) {
                this.btnOK.setEnabled(false);
                this.lblValidate.setText(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_Index_Url_Error"));
                return;
            }
        }
        this.lblValidate.setText("");
        this.btnOK.setEnabled(true);
    }

    public JButton getButton() {
        return this.btnOK;
    }
}

