/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor.hints;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.mobility.editor.actions.RecommentAction;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class InlineIncludeHint
implements Fix {
    private static File LAST_DIRECTORY;
    protected Document doc;
    protected int start;
    protected int end;
    protected File file;
    private String fileName;

    public InlineIncludeHint(BaseDocument doc, int start, String fileName) {
        this.doc = doc;
        this.start = start;
        try {
            this.end = Utilities.getRowEnd((BaseDocument)doc, (int)start);
        }
        catch (BadLocationException ble) {
            this.end = start;
        }
        this.fileName = fileName;
    }

    private synchronized void findFile() {
        Sources src;
        if (this.file != null) {
            return;
        }
        this.file = new File(this.fileName);
        if (this.file.isFile()) {
            return;
        }
        Project p = J2MEProjectUtils.getProjectForDocument((Document)this.doc);
        if (p != null && (src = (Sources)p.getLookup().lookup(Sources.class)) != null) {
            this.file = this.findInGroups(src, "java");
            if (this.file != null) {
                return;
            }
            this.file = this.findInGroups(src, "generic");
            if (this.file != null) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File findInGroups(Sources src, String type) {
        SourceGroup[] sg = src.getSourceGroups(type);
        for (int i = 0; i < sg.length; ++i) {
            File root = FileUtil.toFile((FileObject)sg[i].getRootFolder());
            if (root == null) continue;
            InlineIncludeHint inlineIncludeHint = this;
            synchronized (inlineIncludeHint) {
                if (LAST_DIRECTORY == null) {
                    LAST_DIRECTORY = root;
                }
            }
            File f = new File(root, this.fileName);
            if (!f.isFile()) continue;
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ChangeInfo implement() {
        if (this.file == null) {
            JFileChooser fch = new JFileChooser(LAST_DIRECTORY);
            fch.setDialogTitle(NbBundle.getMessage(InlineIncludeHint.class, (String)"Title_SelectFileToInclude"));
            FF ff = new FF(this.fileName);
            fch.addChoosableFileFilter(ff);
            fch.setFileFilter(ff);
            if (0 != fch.showOpenDialog(WindowManager.getDefault().getMainWindow())) {
                return null;
            }
            this.file = fch.getSelectedFile();
            InlineIncludeHint inlineIncludeHint = this;
            synchronized (inlineIncludeHint) {
                LAST_DIRECTORY = this.file.getParentFile();
            }
        }
        final String content = this.readFile();
        NbDocument.runAtomic((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    InlineIncludeHint.this.doc.insertString(InlineIncludeHint.this.end, NbBundle.getMessage(InlineIncludeHint.class, (String)"Comment_After_Insert", (Object)InlineIncludeHint.this.file.getAbsolutePath()), null);
                    InlineIncludeHint.this.doc.insertString(InlineIncludeHint.this.end, content, null);
                    InlineIncludeHint.this.doc.insertString(InlineIncludeHint.this.end, NbBundle.getMessage(InlineIncludeHint.class, (String)"Comment_Before_Insert", (Object)InlineIncludeHint.this.file.getAbsolutePath()), null);
                    InlineIncludeHint.this.doc.remove(InlineIncludeHint.this.start, InlineIncludeHint.this.end - InlineIncludeHint.this.start);
                }
                catch (BadLocationException ble) {
                    ErrorManager.getDefault().notify((Throwable)ble);
                }
                RecommentAction.actionPerformed(InlineIncludeHint.this.doc);
            }
        });
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile() {
        String encoding;
        FileObject fo = FileUtil.toFileObject((File)this.file);
        String string = encoding = fo != null ? (String)fo.getAttribute("Content-Encoding") : null;
        if (encoding == null || encoding.length() == 0) {
            encoding = System.getProperty("file.encoding");
        }
        char[] ch = new char[(int)this.file.length()];
        InputStreamReader in = null;
        try {
            in = new InputStreamReader((InputStream)new FileInputStream(this.file), encoding);
            in.read(ch);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ioe) {}
        }
        return new String(ch);
    }

    public String getText() {
        this.findFile();
        if (this.file == null) {
            return NbBundle.getMessage(InlineIncludeHint.class, (String)"HintInlineInclude...", (Object)this.fileName);
        }
        return NbBundle.getMessage(InlineIncludeHint.class, (String)"HintInlineInclude", (Object)this.file.getName(), (Object)this.file.getParent());
    }

    private static class FF
    extends FileFilter {
        String name;

        public FF(String path) {
            this.name = path;
            int i = Math.max(this.name.lastIndexOf(47), this.name.lastIndexOf(92));
            if (i >= 0) {
                this.name = this.name.substring(i + 1);
            }
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || this.name.equals(f.getName());
        }

        @Override
        public String getDescription() {
            return this.name;
        }
    }
}

