/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.xhtmlrenderer.DefaultCSSMarker;
import org.xhtmlrenderer.util.GeneralUtil;
import org.xhtmlrenderer.util.XRLog;
import org.xhtmlrenderer.util.XRRuntimeException;

public class Configuration {
    private Properties properties;
    private Level logLevel;
    private static Configuration sInstance;
    private List startupLogRecords = new ArrayList();
    private Logger configLogger;
    private static final String SF_FILE_NAME = "resources/conf/xhtmlrenderer.conf";

    private Configuration() {
        try {
            String val = null;
            try {
                val = System.getProperty("show-config");
            }
            catch (SecurityException ex) {
                val = null;
            }
            this.logLevel = Level.OFF;
            if (val != null) {
                if ("ALL".equals(val)) {
                    this.logLevel = Level.ALL;
                }
                if ("CONFIG".equals(val)) {
                    this.logLevel = Level.CONFIG;
                }
                if ("FINE".equals(val)) {
                    this.logLevel = Level.FINE;
                }
                if ("FINER".equals(val)) {
                    this.logLevel = Level.FINER;
                }
                if ("FINEST".equals(val)) {
                    this.logLevel = Level.FINEST;
                }
                if ("INFO".equals(val)) {
                    this.logLevel = Level.INFO;
                }
                if ("OFF".equals(val)) {
                    this.logLevel = Level.OFF;
                }
                if ("SEVERE".equals(val)) {
                    this.logLevel = Level.SEVERE;
                }
                if ("WARNING".equals(val)) {
                    this.logLevel = Level.WARNING;
                }
            }
        }
        catch (SecurityException e) {
            System.err.println(e.getLocalizedMessage());
        }
        this.loadDefaultProperties();
        String sysOverrideFile = this.getSystemPropertyOverrideFileName();
        if (sysOverrideFile != null) {
            this.loadOverrideProperties(sysOverrideFile);
        } else {
            String userHomeOverrideFileName = this.getUserHomeOverrideFileName();
            if (userHomeOverrideFileName != null) {
                this.loadOverrideProperties(userHomeOverrideFileName);
            }
        }
        this.loadSystemProperties();
        this.logAfterLoad();
    }

    public static void setConfigLogger(Logger logger) {
        Configuration config = Configuration.instance();
        config.configLogger = logger;
        if (config.startupLogRecords != null) {
            Iterator iter = config.startupLogRecords.iterator();
            while (iter.hasNext()) {
                LogRecord lr = (LogRecord)iter.next();
                logger.log(lr.getLevel(), lr.getMessage());
            }
            config.startupLogRecords = null;
        }
    }

    private void println(Level level, String msg) {
        if (this.logLevel != Level.OFF) {
            if (this.configLogger == null) {
                this.startupLogRecords.add(new LogRecord(level, msg));
            } else {
                this.configLogger.log(level, msg);
            }
        }
    }

    private void info(String msg) {
        if (this.logLevel.intValue() <= Level.INFO.intValue()) {
            this.println(Level.INFO, msg);
        }
    }

    private void warning(String msg) {
        if (this.logLevel.intValue() <= Level.WARNING.intValue()) {
            this.println(Level.WARNING, msg);
        }
    }

    private void warning(String msg, Throwable th) {
        this.warning(msg);
        th.printStackTrace();
    }

    private void fine(String msg) {
        if (this.logLevel.intValue() <= Level.FINE.intValue()) {
            this.println(Level.FINE, msg);
        }
    }

    private void finer(String msg) {
        if (this.logLevel.intValue() <= Level.FINER.intValue()) {
            this.println(Level.FINER, msg);
        }
    }

    private void loadDefaultProperties() {
        try {
            InputStream readStream = GeneralUtil.openStreamFromClasspath(new DefaultCSSMarker(), SF_FILE_NAME);
            if (readStream == null) {
                throw new XRRuntimeException("No configuration files found in classpath using URL: resources/conf/xhtmlrenderer.conf");
            }
            this.properties = new Properties();
            this.properties.load(readStream);
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception ex) {
            throw new XRRuntimeException("Could not load properties file for configuration.", ex);
        }
        this.info("Configuration loaded from resources/conf/xhtmlrenderer.conf");
    }

    private void loadOverrideProperties(String uri) {
        try {
            File f = new File(uri);
            Properties temp = new Properties();
            if (f.exists()) {
                this.info("Found config override file " + f.getAbsolutePath());
                try {
                    BufferedInputStream readStream = new BufferedInputStream(new FileInputStream(f));
                    temp.load(readStream);
                }
                catch (IOException iex) {
                    this.warning("Error while loading override properties file; skipping.", iex);
                    return;
                }
            }
            try {
                URL url = new URL(uri);
                BufferedInputStream in = new BufferedInputStream(url.openStream());
                this.info("Found config override URI " + uri);
                temp.load(in);
                ((InputStream)in).close();
            }
            catch (MalformedURLException e) {
                this.warning("URI for override properties is malformed, skipping: " + uri);
                return;
            }
            catch (IOException e) {
                this.warning("Overridden properties could not be loaded from URI: " + uri, e);
                return;
            }
            Enumeration<Object> elem = this.properties.keys();
            ArrayList<Object> lp = Collections.list(elem);
            Collections.sort(lp);
            Iterator iter = lp.iterator();
            int cnt = 0;
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String val = temp.getProperty(key);
                if (val == null) continue;
                this.properties.setProperty(key, val);
                this.finer("  " + key + " -> " + val);
                ++cnt;
            }
            this.finer("Configuration: " + cnt + " properties overridden from override properties file.");
        }
        catch (SecurityException e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    private String getSystemPropertyOverrideFileName() {
        try {
            return System.getProperty("xr.conf");
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private String getUserHomeOverrideFileName() {
        try {
            String overrideName = System.getProperty("user.home") + File.separator + ".flyingsaucer" + File.separator + "local.xhtmlrenderer.conf";
            return overrideName;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private void loadSystemProperties() {
        Enumeration<Object> elem = this.properties.keys();
        ArrayList<Object> lp = Collections.list(elem);
        Collections.sort(lp);
        Iterator iter = lp.iterator();
        this.fine("Overriding loaded configuration from System properties.");
        int cnt = 0;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith("xr.")) continue;
            try {
                String val = System.getProperty(key);
                if (val == null) continue;
                this.properties.setProperty(key, val);
                this.finer("  Overrode value for " + key);
                ++cnt;
            }
            catch (SecurityException e) {}
        }
        this.fine("Configuration: " + cnt + " properties overridden from System properties.");
    }

    private void logAfterLoad() {
        Enumeration<Object> elem = this.properties.keys();
        ArrayList<Object> lp = Collections.list(elem);
        Collections.sort(lp);
        Iterator iter = lp.iterator();
        this.finer("Configuration contains " + this.properties.size() + " keys.");
        this.finer("List of configuration properties, after override:");
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String val = this.properties.getProperty(key);
            this.finer("  " + key + " = " + val);
        }
        this.finer("Properties list complete.");
    }

    public static String valueFor(String key) {
        Configuration conf = Configuration.instance();
        String val = conf.properties.getProperty(key);
        if (val == null) {
            conf.warning("CONFIGURATION: no value found for key " + key);
        }
        return val;
    }

    public static boolean hasValue(String key) {
        Configuration conf = Configuration.instance();
        String val = conf.properties.getProperty(key);
        return val != null;
    }

    public static int valueAsByte(String key, byte defaultVal) {
        String val = Configuration.valueFor(key);
        if (val == null) {
            return defaultVal;
        }
        int bval = -1;
        try {
            bval = Byte.valueOf(val).byteValue();
        }
        catch (NumberFormatException nex) {
            XRLog.exception("Property '" + key + "' was requested as a byte, but " + "value of '" + val + "' is not a byte. Check configuration.");
            bval = defaultVal;
        }
        return bval;
    }

    public static int valueAsShort(String key, short defaultVal) {
        String val = Configuration.valueFor(key);
        if (val == null) {
            return defaultVal;
        }
        int sval = -1;
        try {
            sval = Short.valueOf(val).shortValue();
        }
        catch (NumberFormatException nex) {
            XRLog.exception("Property '" + key + "' was requested as a short, but " + "value of '" + val + "' is not a short. Check configuration.");
            sval = defaultVal;
        }
        return sval;
    }

    public static int valueAsInt(String key, int defaultVal) {
        String val = Configuration.valueFor(key);
        if (val == null) {
            return defaultVal;
        }
        int ival = -1;
        try {
            ival = Integer.valueOf(val);
        }
        catch (NumberFormatException nex) {
            XRLog.exception("Property '" + key + "' was requested as an integer, but " + "value of '" + val + "' is not an integer. Check configuration.");
            ival = defaultVal;
        }
        return ival;
    }

    public static long valueAsLong(String key, long defaultVal) {
        String val = Configuration.valueFor(key);
        if (val == null) {
            return defaultVal;
        }
        long lval = -1L;
        try {
            lval = Long.valueOf(val);
        }
        catch (NumberFormatException nex) {
            XRLog.exception("Property '" + key + "' was requested as a long, but " + "value of '" + val + "' is not a long. Check configuration.");
            lval = defaultVal;
        }
        return lval;
    }

    public static float valueAsFloat(String key, float defaultVal) {
        String val = Configuration.valueFor(key);
        if (val == null) {
            return defaultVal;
        }
        float fval = -1.0f;
        try {
            fval = Float.valueOf(val).floatValue();
        }
        catch (NumberFormatException nex) {
            XRLog.exception("Property '" + key + "' was requested as a float, but " + "value of '" + val + "' is not a float. Check configuration.");
            fval = defaultVal;
        }
        return fval;
    }

    public static double valueAsDouble(String key, double defaultVal) {
        String val = Configuration.valueFor(key);
        if (val == null) {
            return defaultVal;
        }
        double dval = -1.0;
        try {
            dval = Double.valueOf(val);
        }
        catch (NumberFormatException nex) {
            XRLog.exception("Property '" + key + "' was requested as a double, but " + "value of '" + val + "' is not a double. Check configuration.");
            dval = defaultVal;
        }
        return dval;
    }

    public static String valueFor(String key, String defaultVal) {
        Configuration conf = Configuration.instance();
        String val = conf.properties.getProperty(key);
        String string = val = val == null ? defaultVal : val;
        if (val == null) {
            conf.warning("CONFIGURATION: no value found for key " + key + " and no default given.");
        }
        return val;
    }

    public static Iterator keysByPrefix(String prefix) {
        Configuration conf = Configuration.instance();
        Iterator<Object> iter = conf.properties.keySet().iterator();
        ArrayList<String> l = new ArrayList<String>();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(prefix)) continue;
            l.add(key);
        }
        return l.iterator();
    }

    public static void main(String[] args) {
        try {
            System.out.println("byte: " + String.valueOf(Configuration.valueAsByte("xr.test-config-byte", (byte)15)));
            System.out.println("short: " + String.valueOf(Configuration.valueAsShort("xr.test-config-short", (short)20)));
            System.out.println("int: " + String.valueOf(Configuration.valueAsInt("xr.test-config-int", 25)));
            System.out.println("long: " + String.valueOf(Configuration.valueAsLong("xr.test-config-long", 30L)));
            System.out.println("float: " + String.valueOf(Configuration.valueAsFloat("xr.test-config-float", 45.5f)));
            System.out.println("double: " + String.valueOf(Configuration.valueAsDouble("xr.test-config-double", 50.75)));
            System.out.println("boolean: " + String.valueOf(Configuration.isTrue("xr.test-config-boolean", false)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isTrue(String key, boolean defaultVal) {
        String val = Configuration.valueFor(key);
        if (val == null) {
            return defaultVal;
        }
        if ("true|false".indexOf(val) == -1) {
            XRLog.exception("Property '" + key + "' was requested as a boolean, but " + "value of '" + val + "' is not a boolean. Check configuration.");
            return defaultVal;
        }
        return Boolean.valueOf(val);
    }

    public static boolean isFalse(String key, boolean defaultVal) {
        return !Configuration.isTrue(key, defaultVal);
    }

    private static synchronized Configuration instance() {
        if (sInstance == null) {
            sInstance = new Configuration();
        }
        return sInstance;
    }

    public static Object valueFromClassConstant(String key, Object defaultValue) {
        String cnst;
        String klassname;
        Configuration conf = Configuration.instance();
        String val = Configuration.valueFor(key);
        if (val == null) {
            return defaultValue;
        }
        int idx = val.lastIndexOf(".");
        try {
            klassname = val.substring(0, idx);
            cnst = val.substring(idx + 1);
        }
        catch (IndexOutOfBoundsException e) {
            conf.warning("Property key " + key + " for object value constant is not properly formatted; " + "should be FQN<dot>constant, is " + val);
            return defaultValue;
        }
        Class<?> klass = null;
        try {
            klass = Class.forName(klassname);
        }
        catch (ClassNotFoundException e) {
            conf.warning("Property for object value constant " + key + " is not a FQN: " + klassname);
            return defaultValue;
        }
        Object cnstVal = null;
        try {
            Field fld = klass.getDeclaredField(cnst);
            try {
                cnstVal = fld.get(klass);
            }
            catch (IllegalAccessException e) {
                conf.warning("Property for object value constant " + key + ", field is not public: " + klassname + "." + cnst);
                return defaultValue;
            }
        }
        catch (NoSuchFieldException e) {
            conf.warning("Property for object value constant " + key + " is not a FQN: " + klassname);
            return defaultValue;
        }
        return cnstVal;
    }
}

