/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.options;

import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public final class MavenVersionSettings {
    private static final MavenVersionSettings INSTANCE = new MavenVersionSettings();
    public static final String VERSION_COMPILER = "maven-compiler-plugin";
    public static final String VERSION_RESOURCES = "maven-resources-plugin";
    public static final String VERSION_ASSEMBLY = "maven-assembly-plugin";
    public static final String VERSION_JAR = "maven-jar-plugin";
    public static final String VERSION_FELIX = "felix-bundle-plugin";
    public static final String VERSION_NBM = "nbm-maven-plugin";

    public static MavenVersionSettings getDefault() {
        return INSTANCE;
    }

    protected final Preferences getPreferences() {
        return NbPreferences.root().node("org/netbeans/modules/maven/pluginVersions");
    }

    protected final String putProperty(String key, String value) {
        String retval = this.getProperty(key);
        if (value != null) {
            this.getPreferences().put(key, value);
        } else {
            this.getPreferences().remove(key);
        }
        return retval;
    }

    protected final String getProperty(String key) {
        return this.getPreferences().get(key, null);
    }

    private MavenVersionSettings() {
    }

    public String getVersion(String plugin) {
        String toRet = this.getProperty(plugin);
        if (toRet == null) {
            if (VERSION_RESOURCES.equals(plugin)) {
                toRet = "2.2";
            } else if (VERSION_COMPILER.equals(plugin)) {
                toRet = "2.0.2";
            } else if (VERSION_ASSEMBLY.equals(plugin)) {
                toRet = "2.2-beta-1";
            } else if (VERSION_JAR.equals(plugin)) {
                toRet = "2.2";
            } else if (VERSION_FELIX.equals(plugin)) {
                toRet = "2.0.1";
            } else if (VERSION_NBM.equals(plugin)) {
                toRet = "3.2";
            }
        }
        if (toRet == null) {
            toRet = "RELEASE";
        }
        return toRet;
    }
}

