/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.actions.JavaPlatformSelector;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public final class RunCalibrationAction
extends AbstractAction {
    public RunCalibrationAction() {
        this.putValue("Name", NbBundle.getMessage(RunCalibrationAction.class, (String)"LBL_RunCalibrationAction"));
        this.putValue("ShortDescription", NbBundle.getMessage(RunCalibrationAction.class, (String)"HINT_RunCalibrationAction"));
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    @Override
    public boolean isEnabled() {
        return NetBeansProfiler.isInitialized();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int state = Profiler.getDefault().getProfilingState();
        int mode = Profiler.getDefault().getProfilingMode();
        boolean terminate = false;
        boolean detach = false;
        if (state == 8 || state == 4) {
            NotifyDescriptor.Confirmation d;
            if (mode == 1) {
                d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(RunCalibrationAction.class, (String)"MSG_CalibrationOnProfile"), NbBundle.getMessage(RunCalibrationAction.class, (String)"CAPTION_Question"), 0);
                if (ProfilerDialogs.notify((NotifyDescriptor)d) != NotifyDescriptor.YES_OPTION) {
                    return;
                }
                terminate = true;
            } else {
                d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(RunCalibrationAction.class, (String)"MSG_CalibrationOnAttach"), NbBundle.getMessage(RunCalibrationAction.class, (String)"CAPTION_Question"), 0);
                if (ProfilerDialogs.notify((NotifyDescriptor)d) != NotifyDescriptor.YES_OPTION) {
                    return;
                }
                detach = true;
            }
        }
        final boolean doDetach = detach;
        final boolean doStop = terminate;
        JavaPlatform platform = JavaPlatformSelector.getDefault().selectPlatformForCalibration();
        if (platform == null) {
            return;
        }
        final JavaPlatform calibratePlatform = platform;
        IDEUtils.getProfilerRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                if (doDetach) {
                    Profiler.getDefault().detachFromApp();
                } else if (doStop) {
                    Profiler.getDefault().stopApp();
                }
                if (!Profiler.getDefault().runCalibration(false, IDEUtils.getPlatformJavaFile(calibratePlatform), IDEUtils.getPlatformJDKVersion(calibratePlatform), IDEUtils.getPlatformArchitecture(calibratePlatform))) {
                    Profiler.getDefault().displayError(NbBundle.getMessage(RunCalibrationAction.class, (String)"MSG_CalibrationFailed"));
                }
            }
        }, 0, 10);
    }
}

