/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.io.File;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;
import org.openide.util.Utilities;

public class MakeTemplateListener
implements OperationListener {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(MakeTemplateListener.class.getName());
    private static final String ADD_TO_LOGICAL_FOLDER_ATTRIBUTE = "addToLogicalFolder";

    public void operationPostCreate(OperationEvent operationEvent) {
    }

    public void operationCopy(OperationEvent.Copy copy) {
    }

    public void operationMove(OperationEvent.Move move) {
    }

    public void operationDelete(OperationEvent operationEvent) {
    }

    public void operationRename(OperationEvent.Rename rename) {
    }

    public void operationCreateShadow(OperationEvent.Copy copy) {
    }

    private MakeConfigurationDescriptor getMakeConfigurationDescriptor(Project p) {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)p.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp == null) {
            return null;
        }
        return pdp.getConfigurationDescriptor();
    }

    public void operationCreateFromTemplate(OperationEvent.Copy copy) {
        boolean addToLogicalFolder;
        FileObject originalPrimaryFile;
        Folder folder = (Folder)Utilities.actionsGlobalContext().lookup(Folder.class);
        Project project = (Project)Utilities.actionsGlobalContext().lookup(Project.class);
        DataObject originalDataObject = copy.getOriginalDataObject();
        if (originalDataObject != null && (originalPrimaryFile = originalDataObject.getPrimaryFile()) != null && originalPrimaryFile.getAttribute(ADD_TO_LOGICAL_FOLDER_ATTRIBUTE) != null && !(addToLogicalFolder = ((Boolean)originalPrimaryFile.getAttribute(ADD_TO_LOGICAL_FOLDER_ATTRIBUTE)).booleanValue())) {
            return;
        }
        if (folder == null || project == null) {
            DataObject od = (DataObject)Utilities.actionsGlobalContext().lookup(DataObject.class);
            if (od == null) {
                return;
            }
            FileObject file = od.getPrimaryFile();
            project = FileOwnerQuery.getOwner((FileObject)file);
            if (project == null) {
                return;
            }
            File f = FileUtil.toFile((FileObject)file);
            if (f == null) {
                return;
            }
            MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor(project);
            if (makeConfigurationDescriptor == null) {
                return;
            }
            Item i = makeConfigurationDescriptor.findProjectItemByPath(f.getAbsolutePath());
            if (i == null) {
                return;
            }
            folder = i.getFolder();
        }
        if (folder.isDiskFolder()) {
            return;
        }
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor(project);
        assert (makeConfigurationDescriptor != null);
        FileObject file = copy.getObject().getPrimaryFile();
        Project owner = FileOwnerQuery.getOwner((FileObject)file);
        if (ERR.isLoggable(1)) {
            ERR.log(1, "processing file=" + file);
            ERR.log(1, "FileUtil.toFile(file.getPrimaryFile())=" + FileUtil.toFile((FileObject)file));
            ERR.log(1, "into folder = " + folder);
            ERR.log(1, "in project = " + project.getProjectDirectory());
        }
        if (owner != null && owner.getProjectDirectory() == project.getProjectDirectory()) {
            File ioFile = FileUtil.toFile((FileObject)file);
            if (ioFile.isDirectory()) {
                return;
            }
            if (!makeConfigurationDescriptor.okToChange()) {
                return;
            }
            String itemPath = MakeProjectOptions.getPathMode() == 0 ? CndPathUtilitities.toAbsoluteOrRelativePath((String)makeConfigurationDescriptor.getBaseDir(), (String)ioFile.getPath()) : (MakeProjectOptions.getPathMode() == 1 ? CndPathUtilitities.toRelativePath((String)makeConfigurationDescriptor.getBaseDir(), (String)ioFile.getPath()) : ioFile.getPath());
            itemPath = CndPathUtilitities.normalize((String)itemPath);
            Item item = new Item(itemPath);
            folder.addItemAction(item);
            if (ERR.isLoggable(1)) {
                ERR.log(1, "folder: " + folder + ", added: " + file);
            }
        } else if (ERR.isLoggable(1)) {
            ERR.log(1, "not adding: " + file + " because it is not owned by this project");
        }
    }
}

