/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifactProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;

public class MakeArtifact {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_APPLICATION = 1;
    public static final int TYPE_DYNAMIC_LIB = 2;
    public static final int TYPE_STATIC_LIB = 3;
    public static final int TYPE_QT_APPLICATION = 4;
    public static final int TYPE_QT_DYNAMIC_LIB = 5;
    public static final int TYPE_QT_STATIC_LIB = 6;
    private String projectLocation;
    private int configurationType;
    private String configurationName;
    private boolean active;
    private boolean build;
    private String workingDirectory;
    private String buildCommand;
    private String cleanCommand;
    private String output;

    public MakeArtifact(String projectLocation, int configurationType, String configurationName, boolean active, boolean build, String workingDirectory, String buildCommand, String cleanCommand, String output) {
        this.projectLocation = projectLocation;
        this.configurationType = configurationType;
        this.configurationName = configurationName;
        this.active = active;
        this.build = build;
        this.workingDirectory = workingDirectory;
        this.buildCommand = buildCommand;
        this.cleanCommand = cleanCommand;
        this.output = output;
    }

    public MakeArtifact(MakeConfigurationDescriptor pd, MakeConfiguration makeConfiguration) {
        this.projectLocation = makeConfiguration.getBaseDir();
        this.configurationName = makeConfiguration.getName();
        this.active = makeConfiguration.isDefault();
        this.build = true;
        this.workingDirectory = this.projectLocation;
        this.buildCommand = "${MAKE} " + MakeOptions.getInstance().getMakeOptions() + " -f " + pd.getProjectMakefileName() + " CONF=" + this.configurationName;
        this.cleanCommand = "${MAKE} " + MakeOptions.getInstance().getMakeOptions() + " -f " + pd.getProjectMakefileName() + " CONF=" + this.configurationName + " clean";
        switch (makeConfiguration.getConfigurationType().getValue()) {
            case 0: {
                this.configurationType = 0;
                break;
            }
            case 1: {
                this.configurationType = 1;
                break;
            }
            case 2: {
                this.configurationType = 2;
                break;
            }
            case 3: {
                this.configurationType = 3;
                break;
            }
            case 4: {
                this.configurationType = 4;
                break;
            }
            case 5: {
                this.configurationType = 5;
                break;
            }
            case 6: {
                this.configurationType = 6;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.output = makeConfiguration.expandMacros(makeConfiguration.getOutputValue());
    }

    public String getProjectLocation() {
        return this.projectLocation;
    }

    public void setProjectLocation(String projectLocation) {
        this.projectLocation = projectLocation;
    }

    public int getConfigurationType() {
        return this.configurationType;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public boolean getActive() {
        return this.active;
    }

    public boolean getBuild() {
        return this.build;
    }

    public void setBuild(boolean build) {
        this.build = build;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getBuildCommand() {
        return this.buildCommand;
    }

    public String getBuildCommand(String makeCommand, String makeFlags) {
        return this.subsituteMake(this.getBuildCommand(), makeCommand, makeFlags);
    }

    public String getCleanCommand() {
        return this.cleanCommand;
    }

    public String getCleanCommand(String makeCommand, String makeFlags) {
        return this.subsituteMake(this.getCleanCommand(), makeCommand, makeFlags);
    }

    private String subsituteMake(String template, String makeCommand, String makeFlags) {
        if (makeCommand.indexOf(32) > 0 && makeCommand.indexOf(34) != 0 && makeCommand.indexOf(39) != 0) {
            makeCommand = "\"" + makeCommand + "\"";
        }
        int startCommand = template.indexOf("${MAKE}");
        int startFlags = template.indexOf("${MAKEFLAGS}");
        if (startCommand >= 0) {
            if (makeFlags.length() > 0 && startFlags < 0) {
                makeCommand = makeCommand + " " + makeFlags;
            }
            template = template.substring(0, startCommand) + makeCommand + template.substring(startCommand + 7);
        }
        if (startFlags >= 0) {
            startFlags = template.indexOf("${MAKEFLAGS}");
            template = template.substring(0, startFlags) + makeFlags + template.substring(startFlags + 12);
        } else if (startCommand < 0) {
            template = template + " " + makeFlags;
        }
        return template;
    }

    public String getOutput() {
        return this.output;
    }

    public String toString() {
        String ret = this.getConfigurationName();
        if (this.getOutput() != null && this.getOutput().length() > 0) {
            ret = ret + " (" + this.getOutput() + ")";
        }
        return ret;
    }

    public static MakeArtifact[] getMakeArtifacts(Project project) {
        MakeArtifactProvider map = (MakeArtifactProvider)project.getLookup().lookup(MakeArtifactProvider.class);
        if (map != null) {
            return map.getBuildArtifacts();
        }
        return null;
    }

    public MakeArtifact clone() {
        return new MakeArtifact(this.projectLocation, this.configurationType, this.configurationName, this.active, this.build, this.workingDirectory, this.buildCommand, this.cleanCommand, this.output);
    }
}

