/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.checker;

import java.util.Collections;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.web.core.syntax.checker.ElContextChecker;
import org.netbeans.modules.web.core.syntax.checker.JspElChecker;
import org.netbeans.modules.web.core.syntax.completion.JspELExpression;
import org.netbeans.modules.web.core.syntax.completion.api.ELExpression;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ElBeanContextChecker
implements ElContextChecker {
    @Override
    public boolean check(final JspELExpression jspELExpression, Document document, FileObject fileObject, List<Hint> list) {
        JspELExpression jspELExpression2 = jspELExpression;
        jspELExpression2.getClass();
        ELExpression.InspectPropertiesTask inspectPropertiesTask = new ELExpression.InspectPropertiesTask(jspELExpression2){

            public void run(CompilationController compilationController) throws Exception {
                TypeElement typeElement = this.getTypePreceedingCaret(compilationController);
                if (typeElement != null) {
                    String string = jspELExpression.getPropertyBeingTypedName();
                    if (string.length() > 0 && string.charAt(string.length() - 1) == ']') {
                        string = string.substring(0, string.length() - 1);
                    }
                    String string2 = this.removeQuotes(string);
                    for (ExecutableElement executableElement : ElementFilter.methodsIn(compilationController.getElements().getAllMembers(typeElement))) {
                        String string3 = this.getExpressionSuffix(executableElement, compilationController);
                        if (string3 == null || !string3.equals(string2)) continue;
                        return;
                    }
                    this.setOffset(jspELExpression.getExpression().lastIndexOf(string2));
                    this.setProperty(string2);
                    this.setLast();
                }
            }
        };
        inspectPropertiesTask.execute();
        int n = inspectPropertiesTask.getOffset();
        String string = inspectPropertiesTask.getProperty();
        if (n == 0 && string != null) {
            Hint hint = new Hint((Rule)JspElChecker.DEFAULT_ERROR_RULE, NbBundle.getMessage(JspElChecker.class, (String)"MSG_UNKNOWN_BEAN_CONTEXT", (Object)string), fileObject, new OffsetRange(jspELExpression.getStartOffset() + n, jspELExpression.getStartOffset() + n + string.length()), Collections.emptyList(), 50);
            list.add(hint);
        } else if (n > 0 && string != null) {
            String string2 = inspectPropertiesTask.lastProperty() ? "MSG_UNKNOWN_PROPERTY_METHOD_CONTEXT" : "MSG_UNKNOWN_PROPERTY_CONTEXT";
            Hint hint = new Hint((Rule)JspElChecker.DEFAULT_ERROR_RULE, NbBundle.getMessage(JspElChecker.class, (String)string2, (Object)string), fileObject, new OffsetRange(jspELExpression.getStartOffset() + n, jspELExpression.getStartOffset() + n + string.length()), Collections.emptyList(), 50);
            list.add(hint);
        }
        return true;
    }
}

