/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen.model;

import com.sun.source.tree.ClassTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceModelBuilder;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.AbstractTask;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class EntityClassInfo {
    private EntityResourceModelBuilder builder;
    private final Entity entity;
    private JavaSource entitySource;
    private String name;
    private String type;
    private String packageName;
    private Collection<FieldInfo> fieldInfos;
    private FieldInfo idFieldInfo;
    private Set<EntityClassInfo> relatedEntities;

    public EntityClassInfo(Entity entity, Project project, EntityResourceModelBuilder entityResourceModelBuilder, JavaSource javaSource) {
        this.entity = entity;
        this.entitySource = javaSource;
        this.fieldInfos = new ArrayList<FieldInfo>();
        this.builder = entityResourceModelBuilder;
        this.extractFields(project);
        if (this.idFieldInfo != null && this.idFieldInfo.isEmbeddedId()) {
            this.extractPKFields(project);
        }
    }

    protected void setPackageName(String string) {
        this.packageName = string;
    }

    protected void setName(String string) {
        this.name = string;
    }

    protected void setType(String string) {
        this.type = string;
    }

    protected void extractFields(Project project) {
        try {
            final JavaSource javaSource = this.entitySource;
            javaSource.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    ClassTree classTree = JavaSourceHelper.getTopLevelClassTree(compilationController);
                    assert (compilationController.getCompilationUnit() != null) : ((FileObject)javaSource.getFileObjects().iterator().next()).getPath();
                    assert (compilationController.getCompilationUnit().getPackageName() != null) : "NULL package " + ((FileObject)javaSource.getFileObjects().iterator().next()).getPath();
                    EntityClassInfo.this.packageName = compilationController.getCompilationUnit().getPackageName().toString();
                    EntityClassInfo.this.name = classTree.getSimpleName().toString();
                    EntityClassInfo.this.type = EntityClassInfo.this.packageName + "." + EntityClassInfo.this.name;
                    TypeElement typeElement = JavaSourceHelper.getTopLevelClassElement(compilationController);
                    if (EntityClassInfo.this.useFieldAccess(typeElement)) {
                        EntityClassInfo.this.extractFields(typeElement);
                    } else {
                        EntityClassInfo.this.extractFieldsFromMethods(typeElement);
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    protected void extractFields(TypeElement typeElement) {
        List<VariableElement> list = ElementFilter.fieldsIn(typeElement.getEnclosedElements());
        for (VariableElement variableElement : list) {
            Set<Modifier> set = variableElement.getModifiers();
            if (set.contains((Object)Modifier.STATIC) || set.contains((Object)Modifier.TRANSIENT) || set.contains((Object)Modifier.VOLATILE) || set.contains((Object)Modifier.FINAL)) continue;
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.parseAnnotations(variableElement.getAnnotationMirrors());
            if (!fieldInfo.isPersistent()) continue;
            this.fieldInfos.add(fieldInfo);
            fieldInfo.setName(variableElement.getSimpleName().toString());
            fieldInfo.setType(variableElement.asType());
            if (!fieldInfo.isId()) continue;
            this.idFieldInfo = fieldInfo;
        }
    }

    protected void extractFieldsFromMethods(TypeElement typeElement) {
        List<ExecutableElement> list = ElementFilter.methodsIn(typeElement.getEnclosedElements());
        for (ExecutableElement executableElement : list) {
            Set<Modifier> set = executableElement.getModifiers();
            if (set.contains((Object)Modifier.STATIC) || set.contains((Object)Modifier.PRIVATE)) continue;
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.parseAnnotations(executableElement.getAnnotationMirrors());
            if (!fieldInfo.isPersistent() || !fieldInfo.hasPersistenceAnnotation()) continue;
            this.fieldInfos.add(fieldInfo);
            String string = executableElement.getSimpleName().toString();
            if (string.startsWith("get")) {
                string = string.substring(3);
                string = Util.lowerFirstChar(string);
            }
            fieldInfo.setName(string);
            fieldInfo.setType(executableElement.getReturnType());
            if (!fieldInfo.isId()) continue;
            this.idFieldInfo = fieldInfo;
        }
    }

    protected void extractPKFields(Project project) {
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null) {
            FileObject fileObject = restSupport.findSourceRoot();
            if (fileObject != null) {
                try {
                    ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)fileObject);
                    JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
                    if (javaSource == null) {
                        throw new IllegalArgumentException("No JavaSource object for " + this.idFieldInfo.getType());
                    }
                    javaSource.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                        public void run(CompilationController compilationController) throws IOException {
                            compilationController.toPhase(JavaSource.Phase.RESOLVED);
                            TypeElement typeElement = compilationController.getElements().getTypeElement(EntityClassInfo.this.idFieldInfo.getType());
                            EntityClassInfo.this.extractPKFields(typeElement);
                        }
                    }, true);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            } else {
                throw new IllegalArgumentException("No source root for " + project.getProjectDirectory().getName());
            }
        }
    }

    protected void extractPKFields(TypeElement typeElement) {
        List<VariableElement> list = ElementFilter.fieldsIn(typeElement.getEnclosedElements());
        for (VariableElement variableElement : list) {
            Set<Modifier> set = variableElement.getModifiers();
            if (set.contains((Object)Modifier.STATIC) || set.contains((Object)Modifier.TRANSIENT) || set.contains((Object)Modifier.VOLATILE) || set.contains((Object)Modifier.FINAL)) continue;
            FieldInfo fieldInfo = new FieldInfo();
            this.idFieldInfo.addFieldInfo(fieldInfo);
            fieldInfo.setName(variableElement.getSimpleName().toString());
            fieldInfo.setType(variableElement.asType());
        }
    }

    private boolean useFieldAccess(TypeElement typeElement) {
        List<VariableElement> list = ElementFilter.fieldsIn(typeElement.getEnclosedElements());
        for (VariableElement variableElement : list) {
            Set<Modifier> set = variableElement.getModifiers();
            if (set.contains((Object)Modifier.STATIC) || set.contains((Object)Modifier.TRANSIENT) || set.contains((Object)Modifier.VOLATILE) || set.contains((Object)Modifier.FINAL)) continue;
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.parseAnnotations(variableElement.getAnnotationMirrors());
            if (!fieldInfo.isPersistent() || !fieldInfo.hasPersistenceAnnotation()) continue;
            return true;
        }
        return false;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public FieldInfo getIdFieldInfo() {
        return this.idFieldInfo;
    }

    public Collection<FieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    public FieldInfo getFieldInfoByName(String string) {
        for (FieldInfo fieldInfo : this.fieldInfos) {
            if (!fieldInfo.getName().equals(string)) continue;
            return fieldInfo;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EntityClassInfo entityClassInfo = (EntityClassInfo)object;
        if (!(this.name == entityClassInfo.name || this.name != null && this.name.equals(entityClassInfo.name))) {
            return false;
        }
        return this.packageName == entityClassInfo.packageName || this.packageName != null && this.packageName.equals(entityClassInfo.packageName);
    }

    public int hashCode() {
        int n = 3;
        n = 47 * n + (this.name != null ? this.name.hashCode() : 0);
        n = 47 * n + (this.packageName != null ? this.packageName.hashCode() : 0);
        return n;
    }

    public Set<EntityClassInfo> getEntityClosure(Set<EntityClassInfo> set) {
        if (set.contains(this)) {
            return set;
        }
        set.add(this);
        for (EntityClassInfo entityClassInfo : this.getRelatedEntities()) {
            set.addAll(entityClassInfo.getEntityClosure(set));
        }
        return set;
    }

    public Set<EntityClassInfo> getRelatedEntities() {
        if (this.relatedEntities != null) {
            return this.relatedEntities;
        }
        this.relatedEntities = new HashSet<EntityClassInfo>();
        Set<String> set = this.builder.getAllEntityNames();
        for (FieldInfo fieldInfo : this.fieldInfos) {
            String string = fieldInfo.getType();
            String string2 = fieldInfo.getTypeArg();
            if (string != null && set.contains(string)) {
                this.relatedEntities.add(this.builder.getEntityClassInfo(string));
                continue;
            }
            if (string2 == null || !set.contains(string2)) continue;
            this.relatedEntities.add(this.builder.getEntityClassInfo(string2));
        }
        return this.relatedEntities;
    }

    public static class FieldInfo {
        private String name;
        private String type;
        private String simpleTypeName;
        private String typeArg;
        private String simpleTypeArgName;
        private Relationship relationship;
        private boolean isPersistent = true;
        private boolean hasPersistenceAnnotation = false;
        private boolean isId = false;
        private boolean isEmbeddedId = false;
        private boolean isGeneratedValue = false;
        private String mappedBy = null;
        private Collection<FieldInfo> fieldInfos;

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setType(TypeMirror typeMirror) {
            if (typeMirror.getKind() == TypeKind.DECLARED) {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                this.setType(declaredType.asElement().toString());
                for (TypeMirror typeMirror2 : declaredType.getTypeArguments()) {
                    this.setTypeArg(((Object)typeMirror2).toString());
                }
            } else {
                this.setType(((Object)typeMirror).toString());
            }
        }

        private void setType(String string) {
            Class clazz = Util.getPrimitiveType(string);
            if (clazz != null) {
                this.type = clazz.getSimpleName();
                this.simpleTypeName = clazz.getSimpleName();
            } else {
                this.type = string;
                this.simpleTypeName = string.substring(string.lastIndexOf(".") + 1);
            }
        }

        private void setTypeArg(String string) {
            this.typeArg = string;
            this.simpleTypeArgName = string.substring(string.lastIndexOf(".") + 1);
        }

        public String getType() {
            return this.type;
        }

        public String getSimpleTypeName() {
            return this.simpleTypeName;
        }

        public String getTypeArg() {
            return this.typeArg;
        }

        public String getSimpleTypeArgName() {
            return this.simpleTypeArgName;
        }

        public String getEntityClassName() {
            return this.simpleTypeArgName != null ? this.simpleTypeArgName : this.simpleTypeName;
        }

        public void parseAnnotations(List<? extends AnnotationMirror> list) {
            for (AnnotationMirror annotationMirror : list) {
                String string = annotationMirror.getAnnotationType().toString();
                if (!string.startsWith("javax.persistence.")) continue;
                this.hasPersistenceAnnotation = true;
                if (string.contains("EmbeddedId")) {
                    this.isEmbeddedId = true;
                    this.isId = true;
                    continue;
                }
                if (string.contains("Id")) {
                    this.isId = true;
                    continue;
                }
                if (string.contains("OneToOne")) {
                    this.relationship = Relationship.OneToOne;
                    this.parseRelationship(annotationMirror);
                    continue;
                }
                if (string.contains("OneToMany")) {
                    this.relationship = Relationship.OneToMany;
                    this.parseRelationship(annotationMirror);
                    continue;
                }
                if (string.contains("ManyToOne")) {
                    this.relationship = Relationship.ManyToOne;
                    continue;
                }
                if (string.contains("ManyToMany")) {
                    this.relationship = Relationship.ManyToMany;
                    this.parseRelationship(annotationMirror);
                    continue;
                }
                if (string.contains("Transient")) {
                    this.isPersistent = false;
                    continue;
                }
                if (!string.contains("GeneratedValue")) continue;
                this.isGeneratedValue = true;
            }
        }

        private void parseRelationship(AnnotationMirror annotationMirror) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
            for (ExecutableElement executableElement : map.keySet()) {
                if (!executableElement.getSimpleName().toString().equals("mappedBy")) continue;
                this.mappedBy = map.get(executableElement).getValue().toString();
                return;
            }
        }

        public boolean isPersistent() {
            return this.isPersistent;
        }

        public boolean hasPersistenceAnnotation() {
            return this.hasPersistenceAnnotation;
        }

        public boolean isId() {
            return this.isId;
        }

        public boolean isGeneratedValue() {
            return this.isGeneratedValue;
        }

        public boolean isEmbeddedId() {
            return this.isEmbeddedId;
        }

        public boolean isRelationship() {
            return this.relationship != null;
        }

        public boolean isOneToOne() {
            return this.relationship == Relationship.OneToOne;
        }

        public boolean isOneToMany() {
            return this.relationship == Relationship.OneToMany;
        }

        public boolean isManyToOne() {
            return this.relationship == Relationship.ManyToOne;
        }

        public boolean isManyToMany() {
            return this.relationship == Relationship.ManyToMany;
        }

        public String getMappedByField() {
            return this.mappedBy;
        }

        public void addFieldInfo(FieldInfo fieldInfo) {
            if (this.fieldInfos == null) {
                this.fieldInfos = new ArrayList<FieldInfo>();
            }
            this.fieldInfos.add(fieldInfo);
        }

        public Collection<FieldInfo> getFieldInfos() {
            return this.fieldInfos;
        }

        private static enum Relationship {
            OneToOne,
            OneToMany,
            ManyToOne,
            ManyToMany;

        }
    }
}

