/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.css.editor.CssPropertyValue;
import org.netbeans.modules.css.editor.Property;
import org.netbeans.modules.css.editor.PropertyModel;
import org.netbeans.modules.css.editor.properties.CustomErrorMessageProvider;
import org.netbeans.modules.css.gsf.CssGSFParser;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class CssAnalyser {
    private static final String UNKNOWN_PROPERTY = "unknown_property";
    private static final String INVALID_PROPERTY_VALUE = "invalid_property_value";
    private static final String INVALID_CONTENT = "invalid_content";
    private static final String INVALID_CONTENT_MSG = NbBundle.getMessage(CssAnalyser.class, (String)"invalid_content");
    private static final Collection<String> NON_CSS21_DECLARATION_PROPERTY_NAMES = Arrays.asList("opacity", "resize", "text-overflow", "text-shadow", "filter");
    private static final Collection<String> NON_CSS21_DECLARATION_PROPERTY_VALUES = Arrays.asList("expression");

    public static List<Error> checkForErrors(final Snapshot snapshot, SimpleNode node) {
        final ArrayList<Error> errors = new ArrayList<Error>();
        final PropertyModel model = PropertyModel.instance();
        NodeVisitor visitor = new NodeVisitor(){

            @Override
            public void visit(SimpleNode node) {
                Error error;
                if (node.kind() == 29) {
                    SimpleNode propertyNode = SimpleNodeUtil.getChildByType(node, 18);
                    SimpleNode valueNode = SimpleNodeUtil.getChildByType(node, 31);
                    if (propertyNode != null) {
                        CssPropertyValue pv;
                        String valueImage;
                        String propertyName = propertyNode.image().trim();
                        if (CssAnalyser.isNonCss21CompatibleDeclarationPropertyName(propertyName)) {
                            return;
                        }
                        Property property = model.getProperty(propertyName);
                        if (!CssGSFParser.containsGeneratedCode(propertyName) && !CssAnalyser.isVendorSpecificProperty(propertyName) && property == null) {
                            String msg = NbBundle.getMessage(CssAnalyser.class, (String)CssAnalyser.UNKNOWN_PROPERTY, (Object)propertyName);
                            Error error2 = CssAnalyser.makeError(propertyNode.startOffset(), propertyNode.endOffset(), snapshot, CssAnalyser.UNKNOWN_PROPERTY, msg, msg, false, Severity.WARNING);
                            if (error2 != null) {
                                errors.add(error2);
                            }
                        }
                        if (valueNode != null && property != null && !CssGSFParser.containsGeneratedCode(valueImage = valueNode.image().trim()) && !(pv = new CssPropertyValue(property, valueImage)).success()) {
                            Error error3;
                            String unexpectedToken;
                            String errorMsg = null;
                            if (pv instanceof CustomErrorMessageProvider) {
                                errorMsg = ((CustomErrorMessageProvider)((Object)pv)).customErrorMessage();
                            }
                            if (CssAnalyser.isNonCss21CompatiblePropertyValue(unexpectedToken = pv.left().get(pv.left().size() - 1))) {
                                return;
                            }
                            if (errorMsg == null) {
                                errorMsg = NbBundle.getMessage(CssAnalyser.class, (String)CssAnalyser.INVALID_PROPERTY_VALUE, (Object)unexpectedToken);
                            }
                            if ((error3 = CssAnalyser.makeError(valueNode.startOffset(), valueNode.endOffset(), snapshot, CssAnalyser.INVALID_PROPERTY_VALUE, errorMsg, errorMsg, false, Severity.WARNING)) != null) {
                                errors.add(error3);
                            }
                        }
                    }
                } else if (node.kind() == 41 && node.image().length() > 0 && (error = CssAnalyser.makeError(node.startOffset(), node.endOffset(), snapshot, CssAnalyser.INVALID_CONTENT, INVALID_CONTENT_MSG, INVALID_CONTENT_MSG, true, Severity.ERROR)) != null) {
                    errors.add(error);
                }
            }
        };
        if (node != null) {
            SimpleNodeUtil.visitChildren(node, visitor);
        }
        return errors;
    }

    private static Error makeError(int astFrom, int astTo, Snapshot snapshot, String key, String displayName, String description, boolean lineError, Severity severity) {
        assert (astFrom <= astTo);
        int from = snapshot.getOriginalOffset(astFrom);
        int to = snapshot.getOriginalOffset(astTo);
        if (from == -1 || to == -1) {
            return null;
        }
        assert (from <= to);
        return DefaultError.createDefaultError((String)key, (String)displayName, (String)description, (FileObject)snapshot.getSource().getFileObject(), (int)from, (int)to, (boolean)lineError, (Severity)severity);
    }

    public static boolean isVendorSpecificProperty(String propertyName) {
        return propertyName.startsWith("_") || propertyName.startsWith("-");
    }

    private static boolean isNonCss21CompatibleDeclarationPropertyName(String propertyName) {
        return NON_CSS21_DECLARATION_PROPERTY_NAMES.contains(propertyName);
    }

    private static boolean isNonCss21CompatiblePropertyValue(String propertyValue) {
        return NON_CSS21_DECLARATION_PROPERTY_VALUES.contains(propertyValue);
    }
}

