/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.actions;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.makeproject.api.BuildActionsProvider;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class AttachOutputActionProvider
extends BuildActionsProvider {
    public List<BuildActionsProvider.BuildAction> getActions(String ioTabName, ProjectActionEvent[] events) {
        if (events != null && events.length > 0 && events[events.length - 1].getType() == ProjectActionEvent.PredefinedType.RUN) {
            return Collections.singletonList(new AttachAction(events));
        }
        return Collections.emptyList();
    }

    private static final class AttachAction
    extends AbstractAction
    implements BuildActionsProvider.BuildAction {
        ProjectActionEvent[] events;
        private int step = -1;
        private int pid = -1;

        public AttachAction(ProjectActionEvent[] events) {
            this.events = events;
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/resources/actions/Attach.gif", (boolean)false));
            this.putValue("ShortDescription", NbBundle.getBundle(AttachOutputActionProvider.class).getString("OUTPUT_ATTACH_ACTION_TEXT"));
            this.setEnabled(false);
        }

        public void executionStarted(int pid) {
            if (this.step == this.events.length - 1 && pid != -1) {
                this.pid = pid;
                this.setEnabled(true);
            }
        }

        public void executionFinished(int rc) {
            this.setEnabled(false);
        }

        public void setStep(int step) {
            this.step = step;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.pid == -1) {
                return;
            }
            ProjectActionEvent event = this.events[this.step];
            ProjectInformation info = ProjectUtils.getInformation((Project)event.getProject());
            if (info == null) {
                return;
            }
            int attachPid = this.pid;
            ExecutionEnvironment exEnv = event.getConfiguration().getDevelopmentHost().getExecutionEnvironment();
            if (exEnv.isLocal() && Utilities.isWindows()) {
                attachPid = WindowsSupport.getInstance().getWinPID(this.pid);
            }
            try {
                GdbDebugger.attach(attachPid, info, exEnv);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

