/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ClassBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ControllerProvider;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ExceptionBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.FieldBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.LineBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.MethodBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ThreadBreakpointPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class BreakpointsActionsProvider
implements NodeActionsProviderFilter {
    private static final Action CUSTOMIZE_ACTION = Models.createAction((String)BreakpointsActionsProvider.loc("CTL_Breakpoint_Customize_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            BreakpointsActionsProvider.customize((Breakpoint)objectArray[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);

    private static String loc(String string) {
        return NbBundle.getBundle(BreakpointsActionsProvider.class).getString(string);
    }

    public Action[] getActions(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        if (!(object instanceof JPDABreakpoint)) {
            return nodeActionsProvider.getActions(object);
        }
        Action[] actionArray = nodeActionsProvider.getActions(object);
        Action[] actionArray2 = new Action[actionArray.length + 1];
        System.arraycopy(actionArray, 0, actionArray2, 0, actionArray.length);
        actionArray2[actionArray2.length - 1] = CUSTOMIZE_ACTION;
        return actionArray2;
    }

    public void performDefaultAction(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        if (object instanceof ThreadBreakpoint) {
            BreakpointsActionsProvider.customize((Breakpoint)object);
        } else {
            nodeActionsProvider.performDefaultAction(object);
        }
    }

    public static JComponent getCustomizerComponent(Breakpoint breakpoint) {
        JPanel jPanel = null;
        if (breakpoint instanceof LineBreakpoint) {
            jPanel = new LineBreakpointPanel((LineBreakpoint)breakpoint);
        } else if (breakpoint instanceof FieldBreakpoint) {
            jPanel = new FieldBreakpointPanel((FieldBreakpoint)breakpoint);
        } else if (breakpoint instanceof ClassLoadUnloadBreakpoint) {
            jPanel = new ClassBreakpointPanel((ClassLoadUnloadBreakpoint)breakpoint);
        } else if (breakpoint instanceof MethodBreakpoint) {
            jPanel = new MethodBreakpointPanel((MethodBreakpoint)breakpoint);
        } else if (breakpoint instanceof ThreadBreakpoint) {
            jPanel = new ThreadBreakpointPanel((ThreadBreakpoint)breakpoint);
        } else if (breakpoint instanceof ExceptionBreakpoint) {
            jPanel = new ExceptionBreakpointPanel((ExceptionBreakpoint)breakpoint);
        }
        ((Component)jPanel).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"ACSD_Breakpoint_Customizer_Dialog"));
        return jPanel;
    }

    public static void customize(Breakpoint breakpoint) {
        JComponent jComponent = BreakpointsActionsProvider.getCustomizerComponent(breakpoint);
        HelpCtx helpCtx = HelpCtx.findHelp((Component)jComponent);
        if (helpCtx == null) {
            helpCtx = new HelpCtx("debug.add.breakpoint");
        }
        Controller controller = jComponent instanceof ControllerProvider ? ((ControllerProvider)((Object)jComponent)).getController() : (Controller)jComponent;
        final Controller[] controllerArray = new Controller[]{controller};
        final DialogDescriptor[] dialogDescriptorArray = new DialogDescriptor[1];
        final Dialog[] dialogArray = new Dialog[1];
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (dialogDescriptorArray[0].getValue() == DialogDescriptor.OK_OPTION) {
                    boolean bl = controllerArray[0].ok();
                    if (bl) {
                        dialogArray[0].setVisible(false);
                    }
                } else {
                    dialogArray[0].setVisible(false);
                }
            }
        };
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jComponent, NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_Breakpoint_Customizer_Title"), true, 2, DialogDescriptor.OK_OPTION, 0, helpCtx, actionListener);
        dialogDescriptor.setClosingOptions(new Object[0]);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.pack();
        dialogDescriptorArray[0] = dialogDescriptor;
        dialogArray[0] = dialog;
        dialog.setVisible(true);
    }
}

