/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.Testcase;

public final class Report {
    private String suiteClassName;
    private int totalTests;
    private int failures;
    private int errors;
    private int pending;
    private long elapsedTimeMillis;
    private int detectedPassedTests;
    private Collection<Testcase> tests;
    private LineConvertors.FileLocator fileLocator;
    private Project project;
    private boolean aborted;
    private boolean skipped;
    protected boolean completed;

    public Report(String suiteClassName, Project project) {
        this.suiteClassName = suiteClassName;
        this.project = project;
        this.fileLocator = (LineConvertors.FileLocator)project.getLookup().lookup(LineConvertors.FileLocator.class);
        this.tests = new ArrayList<Testcase>(10);
        this.completed = true;
        this.aborted = false;
        this.skipped = false;
    }

    public LineConvertors.FileLocator getFileLocator() {
        return this.fileLocator;
    }

    public Project getProject() {
        return this.project;
    }

    public void reportTest(Testcase test) {
        this.tests.add(test);
        if (!Status.isFailure(test.getStatus())) {
            ++this.detectedPassedTests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Report report) {
        Report report2 = this;
        synchronized (report2) {
            this.suiteClassName = report.suiteClassName;
            this.totalTests = report.totalTests;
            this.failures = report.failures;
            this.errors = report.errors;
            this.pending = report.pending;
            this.elapsedTimeMillis = report.elapsedTimeMillis;
            this.detectedPassedTests = report.detectedPassedTests;
            this.tests = report.tests;
            this.completed = report.completed;
            this.skipped = report.skipped;
        }
    }

    public Status getStatus() {
        if (this.aborted) {
            return Status.ABORTED;
        }
        if (this.skipped) {
            return Status.SKIPPED;
        }
        if (this.errors > 0) {
            return Status.ERROR;
        }
        if (this.failures > 0) {
            return Status.FAILED;
        }
        if (this.pending > 0) {
            return Status.PENDING;
        }
        return Status.PASSED;
    }

    public Collection<Testcase> getTests() {
        if (this.tests.isEmpty()) {
            List<Testcase> emptyList = Collections.emptyList();
            return emptyList;
        }
        return new ArrayList<Testcase>(this.tests);
    }

    public boolean containsFailed() {
        assert (EventQueue.isDispatchThread());
        return this.failures + this.errors != 0;
    }

    public String getSuiteClassName() {
        return this.suiteClassName;
    }

    public void setSuiteClassName(String suiteClassName) {
        this.suiteClassName = suiteClassName;
    }

    public int getTotalTests() {
        return this.totalTests;
    }

    public void setTotalTests(int totalTests) {
        this.totalTests = totalTests;
    }

    public int getFailures() {
        return this.failures;
    }

    public void setFailures(int failures) {
        this.failures = failures;
    }

    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int errors) {
        this.errors = errors;
    }

    public int getPending() {
        return this.pending;
    }

    public void setPending(int pending) {
        this.pending = pending;
    }

    public long getElapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    public void setElapsedTimeMillis(long elapsedTimeMillis) {
        this.elapsedTimeMillis = elapsedTimeMillis;
    }

    public int getDetectedPassedTests() {
        return this.detectedPassedTests;
    }

    public void setDetectedPassedTests(int detectedPassedTests) {
        this.detectedPassedTests = detectedPassedTests;
    }

    public void setTests(Collection<Testcase> tests) {
        this.tests = tests;
    }

    public void setFileLocator(LineConvertors.FileLocator fileLocator) {
        this.fileLocator = fileLocator;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public void setSkipped(boolean skipped) {
        this.skipped = skipped;
    }
}

