/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview;

import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.xml.api.XmlFileEncodingQueryImpl;
import org.netbeans.modules.xml.multiview.DesignMultiViewDesc;
import org.netbeans.modules.xml.multiview.EncodingHelper;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.io.ReaderInputStream;
import org.openide.windows.CloneableTopComponent;
import org.xml.sax.SAXException;

public abstract class XmlMultiViewDataObject
extends MultiDataObject
implements CookieSet.Factory {
    public static final String PROP_DOCUMENT_VALID = "document_valid";
    public static final String PROP_SAX_ERROR = "sax_error";
    public static final String PROPERTY_DATA_MODIFIED = "data modified";
    public static final String PROPERTY_DATA_UPDATED = "data changed";
    protected XmlMultiViewEditorSupport editorSupport;
    private SAXException saxError;
    private final DataCache dataCache = new DataCache();
    private EncodingHelper encodingHelper = new EncodingHelper();
    private transient long timeStamp = 0L;
    private transient WeakReference lockReference;
    private MultiViewElement activeMVElement;
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            XmlMultiViewDataObject.this.getEditorSupport().saveDocument();
        }
    };

    public XmlMultiViewDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
        this.getCookieSet().add(XmlMultiViewEditorSupport.class, (CookieSet.Factory)this);
        this.getCookieSet().assign(FileEncodingQueryImplementation.class, new Object[]{XmlFileEncodingQueryImpl.singleton()});
    }

    protected EditorCookie createEditorCookie() {
        return this.getEditorSupport();
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(XmlMultiViewEditorSupport.class)) {
            return this.getEditorSupport();
        }
        return null;
    }

    protected synchronized XmlMultiViewEditorSupport getEditorSupport() {
        if (this.editorSupport == null) {
            this.editorSupport = new XmlMultiViewEditorSupport(this);
            this.editorSupport.getMultiViewDescriptions();
        }
        return this.editorSupport;
    }

    public void goToXmlView() {
        this.getEditorSupport().goToXmlPerspective();
    }

    protected void setSaxError(SAXException saxError) {
        SAXException oldError = this.saxError;
        this.saxError = saxError;
        if (oldError == null) {
            if (saxError != null) {
                this.firePropertyChange(PROP_DOCUMENT_VALID, Boolean.TRUE, Boolean.FALSE);
            }
        } else if (saxError == null) {
            this.firePropertyChange(PROP_DOCUMENT_VALID, Boolean.FALSE, Boolean.TRUE);
        }
        String oldErrorMessage = XmlMultiViewDataObject.getErrorMessage(oldError);
        String newErrorMessage = XmlMultiViewDataObject.getErrorMessage(saxError);
        if (oldErrorMessage == null) {
            if (newErrorMessage != null) {
                this.firePropertyChange(PROP_SAX_ERROR, null, newErrorMessage);
            }
        } else if (!oldErrorMessage.equals(newErrorMessage)) {
            this.firePropertyChange(PROP_SAX_ERROR, oldErrorMessage, newErrorMessage);
        }
    }

    private static String getErrorMessage(Exception e) {
        return e == null ? null : e.getMessage();
    }

    public SAXException getSaxError() {
        return this.saxError;
    }

    protected Image getXmlViewIcon() {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/xml/multiview/resources/xmlObject.gif");
    }

    protected abstract DesignMultiViewDesc[] getMultiViewDesc();

    public void setLastOpenView(int index) {
        this.getEditorSupport().setLastOpenView(index);
    }

    protected FileObject handleRename(String name) throws IOException {
        FileObject retValue = super.handleRename(name);
        this.getEditorSupport().updateDisplayName();
        return retValue;
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    public void setModified(boolean modif) {
        super.setModified(modif);
        if (modif) {
            if (this.getCookie(SaveCookie.class) == null) {
                this.getCookieSet().add((Node.Cookie)this.saveCookie);
            }
        } else if (this.saveCookie.equals(this.getCookie(SaveCookie.class))) {
            this.getCookieSet().remove((Node.Cookie)this.saveCookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canClose() {
        FileLock lock;
        Enumeration enumeration;
        CloneableTopComponent topComponent = (CloneableTopComponent)this.getEditorSupport().getMVTC();
        if (topComponent != null && (enumeration = topComponent.getReference().getComponents()).hasMoreElements()) {
            enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                return true;
            }
        }
        try {
            lock = this.waitForLock();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return !this.isModified();
        }
        try {
            boolean bl = !this.isModified();
            return bl;
        }
        finally {
            lock.releaseLock();
        }
    }

    public FileLock waitForLock() throws IOException {
        return this.waitForLock(10000L);
    }

    public FileLock waitForLock(long timeout) throws IOException {
        long t = System.currentTimeMillis() + timeout;
        long sleepTime = 50L;
        while (true) {
            try {
                return this.dataCache.lock();
            }
            catch (IOException e) {
                if (System.currentTimeMillis() > t) {
                    throw (IOException)new IOException("Cannot wait for data lock for more than " + timeout + " ms").initCause(e);
                }
                try {
                    Thread.sleep(sleepTime);
                    sleepTime = 3L * sleepTime / 2L;
                }
                catch (InterruptedException e1) {
                }
                continue;
            }
            break;
        }
    }

    public MultiViewPerspective getSelectedPerspective() {
        return this.getEditorSupport().getSelectedPerspective();
    }

    public void showElement(Object element) {
        this.getEditorSupport().edit();
    }

    protected MultiViewElement getActiveMultiViewElement() {
        return this.activeMVElement;
    }

    void setActiveMultiViewElement(MultiViewElement element) {
        this.activeMVElement = element;
    }

    public void openView(int index) {
        this.getEditorSupport().openView(index);
    }

    protected abstract String getPrefixMark();

    boolean acceptEncoding() throws IOException {
        this.encodingHelper.resetEncoding();
        DataCache dataCache = this.getDataCache();
        String s = dataCache.getStringData();
        String encoding = this.encodingHelper.detectEncoding(s.getBytes());
        if (!this.encodingHelper.getEncoding().equals(encoding)) {
            Object result = this.showChangeEncodingDialog(encoding);
            if (NotifyDescriptor.YES_OPTION.equals(result)) {
                dataCache.setData(this.encodingHelper.setDefaultEncoding(s));
            } else if (NotifyDescriptor.NO_OPTION.equals(result)) {
                this.showUsingDifferentEncodingMessage(encoding);
            } else {
                return false;
            }
        }
        return true;
    }

    private void showUsingDifferentEncodingMessage(String encoding) {
        String message = NbBundle.getMessage(XmlMultiViewDataObject.class, (String)"TEXT_TREAT_USING_DIFFERENT_ENCODING", (Object)encoding, (Object)this.encodingHelper.getEncoding());
        NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)message);
        descriptor.setTitle(this.getPrimaryFile().getPath());
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
    }

    private Object showChangeEncodingDialog(String encoding) {
        String message = NbBundle.getMessage(Utils.class, (String)"TEXT_CHANGE_DECLARED_ENCODING", (Object)encoding, (Object)this.encodingHelper.getEncoding());
        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)message, this.getPrimaryFile().getPath(), 1);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
    }

    public EncodingHelper getEncodingHelper() {
        return this.encodingHelper;
    }

    public DataCache getDataCache() {
        return this.dataCache;
    }

    protected boolean verifyDocumentBeforeClose() {
        return true;
    }

    public class DataCache {
        private transient String buffer = null;
        private long fileTime = 0L;

        public void loadData() {
            block3: {
                FileObject file = XmlMultiViewDataObject.this.getPrimaryFile();
                if (this.fileTime == file.lastModified().getTime()) {
                    return;
                }
                try {
                    FileLock dataLock = this.lock();
                    this.loadData(file, dataLock);
                }
                catch (IOException e) {
                    if (this.buffer != null) break block3;
                    this.buffer = "";
                }
            }
        }

        public void reloadData() throws IOException {
            FileObject file = XmlMultiViewDataObject.this.getPrimaryFile();
            if (this.fileTime == file.lastModified().getTime()) {
                return;
            }
            FileLock lock = this.getLock();
            if (lock == null) {
                lock = this.lock();
            }
            this.loadData(file, lock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadData(FileObject file, FileLock dataLock) throws IOException {
            try {
                long time;
                BufferedInputStream inputStream = new BufferedInputStream(file.getInputStream());
                String encoding = XmlMultiViewDataObject.this.encodingHelper.detectEncoding(inputStream);
                if (!XmlMultiViewDataObject.this.encodingHelper.getEncoding().equals(encoding)) {
                    XmlMultiViewDataObject.this.showUsingDifferentEncodingMessage(encoding);
                }
                InputStreamReader reader = new InputStreamReader((InputStream)inputStream, XmlMultiViewDataObject.this.encodingHelper.getEncoding());
                StringBuffer sb = new StringBuffer(2048);
                try {
                    int i;
                    char[] buf = new char[1024];
                    time = file.lastModified().getTime();
                    while ((i = ((Reader)reader).read(buf, 0, 1024)) != -1) {
                        sb.append(buf, 0, i);
                    }
                }
                finally {
                    ((Reader)reader).close();
                }
                this.buffer = null;
                this.fileTime = time;
                this.setData(dataLock, sb.toString(), true);
            }
            finally {
                dataLock.releaseLock();
            }
        }

        public void setData(FileLock lock, String s, boolean modify) throws IOException {
            this.testLock(lock);
            boolean modified = XmlMultiViewDataObject.this.isModified() || modify;
            long oldTimeStamp = XmlMultiViewDataObject.this.timeStamp;
            if (this.setData(s)) {
                if (!modified) {
                    this.saveData(lock);
                    XmlMultiViewDataObject.this.firePropertyChange(XmlMultiViewDataObject.PROPERTY_DATA_UPDATED, new Long(oldTimeStamp), new Long(XmlMultiViewDataObject.this.timeStamp));
                } else {
                    XmlMultiViewDataObject.this.firePropertyChange(XmlMultiViewDataObject.PROPERTY_DATA_MODIFIED, new Long(oldTimeStamp), new Long(XmlMultiViewDataObject.this.timeStamp));
                }
            }
        }

        private boolean setData(String s) {
            if (s.equals(this.buffer)) {
                return false;
            }
            this.buffer = s;
            long newTimeStamp = new Date().getTime();
            if (newTimeStamp <= XmlMultiViewDataObject.this.timeStamp) {
                newTimeStamp = XmlMultiViewDataObject.this.timeStamp + 1L;
            }
            XmlMultiViewDataObject.this.timeStamp = newTimeStamp;
            this.fileTime = 0L;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void saveData(FileLock dataLock) {
            block11: {
                if (this.buffer == null || this.fileTime == XmlMultiViewDataObject.this.getPrimaryFile().lastModified().getTime()) {
                    return;
                }
                try {
                    XmlMultiViewEditorSupport editorSupport = XmlMultiViewDataObject.this.getEditorSupport();
                    if (editorSupport.getDocument() == null) {
                        XmlMultiViewEditorSupport.XmlEnv xmlEnv = editorSupport.getXmlEnv();
                        FileLock lock = null;
                        try {
                            lock = xmlEnv.takeLock();
                            OutputStream outputStream = XmlMultiViewDataObject.this.getPrimaryFile().getOutputStream(lock);
                            OutputStreamWriter writer = new OutputStreamWriter(outputStream, XmlMultiViewDataObject.this.encodingHelper.getEncoding());
                            try {
                                writer.write(this.buffer);
                                break block11;
                            }
                            finally {
                                ((Writer)writer).close();
                                xmlEnv.unmarkModified();
                                this.resetFileTime();
                            }
                        }
                        finally {
                            if (lock != null) {
                                lock.releaseLock();
                            }
                        }
                    }
                    editorSupport.saveDocument(dataLock);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }

        public FileLock lock() throws IOException {
            FileLock current = this.getLock();
            if (current != null) {
                throw new FileAlreadyLockedException("File is already locked by [" + current + "].");
            }
            FileLock l = new FileLock();
            XmlMultiViewDataObject.this.lockReference = new WeakReference<FileLock>(l);
            return l;
        }

        private FileLock getLock() {
            FileLock l;
            FileLock fileLock = l = XmlMultiViewDataObject.this.lockReference == null ? null : (FileLock)XmlMultiViewDataObject.this.lockReference.get();
            if (l != null && !l.isValid()) {
                l = null;
            }
            return l;
        }

        public String getStringData() {
            if (this.buffer == null) {
                this.loadData();
            }
            return this.buffer;
        }

        public byte[] getData() {
            try {
                return this.getStringData().getBytes(XmlMultiViewDataObject.this.encodingHelper.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return null;
            }
        }

        public void setData(FileLock lock, byte[] data, boolean modify) throws IOException {
            XmlMultiViewDataObject.this.encodingHelper.detectEncoding(data);
            this.setData(lock, new String(data, XmlMultiViewDataObject.this.encodingHelper.getEncoding()), modify);
        }

        public long getTimeStamp() {
            return XmlMultiViewDataObject.this.timeStamp;
        }

        public InputStream createInputStream() {
            try {
                XmlMultiViewDataObject.this.encodingHelper.detectEncoding(this.getStringData().getBytes());
                return new ReaderInputStream((Reader)new StringReader(this.getStringData()), XmlMultiViewDataObject.this.encodingHelper.getEncoding());
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return null;
            }
        }

        public Reader createReader() throws IOException {
            return new StringReader(this.getStringData());
        }

        public OutputStream createOutputStream() throws IOException {
            final FileLock dataLock = this.lock();
            return new ByteArrayOutputStream(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                        DataCache.this.setData(dataLock, this.toByteArray(), true);
                    }
                    finally {
                        dataLock.releaseLock();
                    }
                }
            };
        }

        public OutputStream createOutputStream(final FileLock dataLock, final boolean modify) throws IOException {
            this.testLock(dataLock);
            return new ByteArrayOutputStream(){

                @Override
                public void close() throws IOException {
                    super.close();
                    DataCache.this.setData(dataLock, this.toByteArray(), modify);
                    if (!modify) {
                        XmlMultiViewDataObject.this.dataCache.saveData(dataLock);
                    }
                }
            };
        }

        public Writer createWriter() throws IOException {
            final FileLock dataLock = this.lock();
            return new StringWriter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                        DataCache.this.setData(dataLock, this.toString(), true);
                    }
                    finally {
                        dataLock.releaseLock();
                    }
                }
            };
        }

        public Writer createWriter(final FileLock dataLock, final boolean modify) throws IOException {
            this.testLock(dataLock);
            return new StringWriter(){

                @Override
                public void close() throws IOException {
                    super.close();
                    DataCache.this.setData(dataLock, this.toString(), modify);
                    if (!modify) {
                        XmlMultiViewDataObject.this.dataCache.saveData(dataLock);
                    }
                }
            };
        }

        public void testLock(FileLock lock) throws IOException {
            if (lock == null) {
                throw new IOException("Lock is null.");
            }
            if (lock != this.getLock()) {
                throw new IOException("Invalid lock [" + lock + "]. Expected [" + this.getLock() + "].");
            }
        }

        public void resetFileTime() {
            this.fileTime = XmlMultiViewDataObject.this.getPrimaryFile().lastModified().getTime();
        }
    }
}

