/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBForeignKey;
import org.netbeans.modules.db.dataview.meta.DBModel;
import org.netbeans.modules.db.dataview.meta.DBObject;
import org.netbeans.modules.db.dataview.meta.DBPrimaryKey;
import org.netbeans.modules.db.dataview.util.DataViewUtils;

public final class DBTable
extends DBObject<DBModel> {
    private static final String FQ_TBL_NAME_SEPARATOR = ".";
    private String catalog;
    private Map<String, DBColumn> columns = new LinkedHashMap<String, DBColumn>();
    private Map<String, DBForeignKey> foreignKeys = new HashMap<String, DBForeignKey>();
    private String name;
    private DBPrimaryKey primaryKey;
    private String schema;
    private SQLIdentifiers.Quoter quoter;

    public DBTable(String aName, String aSchema, String aCatalog) {
        this.name = aName != null ? aName.trim() : null;
        this.schema = aSchema != null ? aSchema.trim() : null;
        this.catalog = aCatalog != null ? aCatalog.trim() : null;
    }

    public synchronized boolean addColumn(DBColumn theColumn) {
        if (theColumn != null) {
            theColumn.setParentObject(this);
            this.columns.put(theColumn.getName() + theColumn.getOrdinalPosition(), theColumn);
            return true;
        }
        return false;
    }

    public int compareTo(Object refObj) {
        String myName;
        if (refObj == null) {
            return -1;
        }
        if (refObj == this) {
            return 0;
        }
        DBModel parentDBModel = (DBModel)this.getParentObject();
        String refName = parentDBModel != null ? parentDBModel.getFullyQualifiedTableName((DBTable)refObj) : ((DBTable)refObj).getName();
        String string = myName = parentDBModel != null ? parentDBModel.getFullyQualifiedTableName(this) : this.name;
        return myName != null ? myName.compareTo(refName) : (refName != null ? 1 : -1);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DBTable)) {
            return false;
        }
        result = super.equals(obj);
        if (!result) {
            return result;
        }
        if (obj instanceof DBTable) {
            DBTable aTable = (DBTable)obj;
            String aTableName = aTable.getName();
            Map<String, DBColumn> aTableColumns = aTable.getColumns();
            DBPrimaryKey aTablePK = aTable.primaryKey;
            List<DBForeignKey> aTableFKs = aTable.getForeignKeys();
            result &= aTableName != null && this.name != null && this.name.equals(aTableName);
            if (this.columns != null && aTableColumns != null) {
                Set<String> objCols = aTableColumns.keySet();
                Set<String> myCols = this.columns.keySet();
                result &= myCols.containsAll(objCols) && objCols.containsAll(myCols);
            } else if (this.columns != null || aTableColumns != null) {
                result = false;
            }
            result &= this.primaryKey != null ? this.primaryKey.equals(aTablePK) : aTablePK == null;
            if (this.foreignKeys != null && aTableFKs != null) {
                Collection<DBForeignKey> myFKs = this.foreignKeys.values();
                result &= myFKs.containsAll(aTableFKs) && aTableFKs.containsAll(myFKs);
            } else if (this.foreignKeys != null || aTableFKs != null) {
                result = false;
            }
        }
        return result;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public SQLIdentifiers.Quoter getQuoter() {
        return this.quoter;
    }

    void setQuoter(SQLIdentifiers.Quoter quoter) {
        this.quoter = quoter;
    }

    public List<DBColumn> getColumnList() {
        ArrayList<DBColumn> list = new ArrayList<DBColumn>();
        list.addAll(this.columns.values());
        Collections.sort(list, new ColumnOrderComparator());
        return list;
    }

    public Map<String, DBColumn> getColumns() {
        return this.columns;
    }

    public DBColumn getColumn(String name) {
        Collection<DBColumn> list = this.columns.values();
        for (DBColumn dBColumn : list) {
            if (!dBColumn.getName().equalsIgnoreCase(name)) continue;
            return dBColumn;
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.getFullyQualifiedName(false);
    }

    public List<DBForeignKey> getForeignKeys() {
        return new ArrayList<DBForeignKey>(this.foreignKeys.values());
    }

    public String getFullyQualifiedName(boolean quoteAlways) {
        StringBuilder buf = new StringBuilder(50);
        if (!DataViewUtils.isNullString(this.catalog)) {
            buf.append(quoteAlways ? this.quoter.quoteAlways(this.catalog.trim()) : this.quoter.quoteIfNeeded(this.catalog.trim()));
            buf.append(FQ_TBL_NAME_SEPARATOR);
        }
        if (!DataViewUtils.isNullString(this.schema)) {
            buf.append(quoteAlways ? this.quoter.quoteAlways(this.schema.trim()) : this.quoter.quoteIfNeeded(this.schema.trim()));
            buf.append(FQ_TBL_NAME_SEPARATOR);
        }
        if (this.quoter != null) {
            buf.append(quoteAlways ? this.quoter.quoteAlways(this.name.trim()) : this.quoter.quoteIfNeeded(this.name.trim()));
        } else {
            buf.append(this.name);
        }
        return buf.toString();
    }

    public String getQualifiedName(boolean quoteAlways) {
        if (this.quoter != null) {
            return quoteAlways ? this.quoter.quoteAlways(this.name.trim()) : this.quoter.quoteIfNeeded(this.name.trim());
        }
        return this.name.trim();
    }

    public String getName() {
        return this.name;
    }

    public DBPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public String getSchema() {
        return this.schema;
    }

    public int hashCode() {
        int myHash = super.hashCode();
        myHash = this.name != null ? this.name.hashCode() : 0;
        myHash += this.schema != null ? this.schema.hashCode() : 0;
        myHash += this.catalog != null ? this.catalog.hashCode() : 0;
        if (this.columns != null) {
            myHash += ((Object)this.columns.keySet()).hashCode();
        }
        if (this.primaryKey != null) {
            myHash += this.primaryKey.hashCode();
        }
        if (this.foreignKeys != null) {
            myHash += ((Object)this.foreignKeys.keySet()).hashCode();
        }
        return myHash += this.displayName != null ? this.displayName.hashCode() : 0;
    }

    public void setName(String newName) {
        this.name = newName;
        this.setDisplayName(newName);
    }

    public void setCatalogName(String newName) {
        this.catalog = newName;
    }

    public void setSchemaName(String newName) {
        this.schema = newName;
    }

    boolean setPrimaryKey(DBPrimaryKey newPk) {
        if (newPk != null) {
            newPk.setParentObject(this);
        }
        this.primaryKey = newPk;
        return true;
    }

    void setForeignKeyMap(Map<String, DBForeignKey> fkMap) {
        this.foreignKeys = fkMap;
    }

    public String toString() {
        return this.getFullyQualifiedName(false);
    }

    final class ColumnOrderComparator
    implements Comparator<DBColumn> {
        private ColumnOrderComparator() {
        }

        @Override
        public int compare(DBColumn col1, DBColumn col2) {
            return col1.getOrdinalPosition() - col2.getOrdinalPosition();
        }
    }
}

