/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.ide.j2ee.DeploymentManagerProperties;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class OptionTabVisualPanel
extends JPanel {
    private final DeploymentManagerProperties dmp;
    private JLabel deploymentTimeoutLabel;
    private JTextField deploymentTimeoutValue;
    private JLabel dynamicHelpLabel;
    private JCheckBox enableDatabaseStart;
    private JCheckBox enableDirectoryDeployment;
    private JCheckBox enableDriverDeployment;
    private JLabel startupTimeoutLabel;
    private JTextField startupTimeoutValue;

    OptionTabVisualPanel(DeploymentManager deploymentManager) {
        this.initComponents();
        this.dmp = new DeploymentManagerProperties(deploymentManager);
        this.startupTimeoutValue.setText(this.dmp.getStartupTimeout() + "");
        this.startupTimeoutValue.setEnabled(((SunDeploymentManagerInterface)deploymentManager).isLocal());
        this.deploymentTimeoutValue.setText(this.dmp.getDeploymentTimeout() + "");
        this.enableDirectoryDeployment.setSelected(this.dmp.isDirectoryDeploymentPossible());
        this.enableDirectoryDeployment.setEnabled(((SunDeploymentManagerInterface)deploymentManager).isLocal());
        this.enableDriverDeployment.setSelected(this.dmp.isDriverDeploymentEnabled());
        this.enableDriverDeployment.setEnabled(((SunDeploymentManagerInterface)deploymentManager).isLocal());
        this.enableDatabaseStart.setSelected(this.dmp.isDatabaseStartEnabled());
        this.enableDatabaseStart.setEnabled(((SunDeploymentManagerInterface)deploymentManager).isLocal());
    }

    private void updateDynamicHelp(String string) {
        this.dynamicHelpLabel.setText(string);
    }

    private void initComponents() {
        this.startupTimeoutLabel = new JLabel();
        this.startupTimeoutValue = new JTextField();
        this.deploymentTimeoutLabel = new JLabel();
        this.deploymentTimeoutValue = new JTextField();
        this.enableDirectoryDeployment = new JCheckBox();
        this.enableDriverDeployment = new JCheckBox();
        this.enableDatabaseStart = new JCheckBox();
        this.dynamicHelpLabel = new JLabel();
        this.startupTimeoutLabel.setLabelFor(this.startupTimeoutValue);
        Mnemonics.setLocalizedText((JLabel)this.startupTimeoutLabel, (String)NbBundle.getMessage(OptionTabVisualPanel.class, (String)"LBL_STARTUP_TIMEOUT"));
        this.startupTimeoutValue.setHorizontalAlignment(2);
        this.startupTimeoutValue.setText(NbBundle.getMessage(OptionTabVisualPanel.class, (String)"OptionTabVisualPanel.startupTimeoutValue.text"));
        this.startupTimeoutValue.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                OptionTabVisualPanel.this.startupTimeoutHelp(focusEvent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                OptionTabVisualPanel.this.clearDynamicHelp(focusEvent);
            }
        });
        this.startupTimeoutValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                OptionTabVisualPanel.this.startupTimeoutValueKeyReleased(keyEvent);
            }
        });
        this.deploymentTimeoutLabel.setLabelFor(this.deploymentTimeoutValue);
        Mnemonics.setLocalizedText((JLabel)this.deploymentTimeoutLabel, (String)NbBundle.getMessage(OptionTabVisualPanel.class, (String)"LBL_DEPLOYMENT_TIMEOUT"));
        this.deploymentTimeoutValue.setHorizontalAlignment(2);
        this.deploymentTimeoutValue.setText(NbBundle.getMessage(OptionTabVisualPanel.class, (String)"OptionTabVisualPanel.deploymentTimeoutValue.text"));
        this.deploymentTimeoutValue.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                OptionTabVisualPanel.this.deploymentTimeoutHelp(focusEvent);
            }
        });
        this.deploymentTimeoutValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                OptionTabVisualPanel.this.deploymentTimeoutValueKeyReleased(keyEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.enableDirectoryDeployment, (String)NbBundle.getMessage(OptionTabVisualPanel.class, (String)"CB_DIR_DEPLOY"));
        this.enableDirectoryDeployment.setMargin(new Insets(0, 0, 0, 0));
        this.enableDirectoryDeployment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionTabVisualPanel.this.enableDirectoryDeploymentActionPerformed(actionEvent);
            }
        });
        this.enableDirectoryDeployment.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                OptionTabVisualPanel.this.directoryDeploymentHelp(focusEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.enableDriverDeployment, (String)NbBundle.getMessage(OptionTabVisualPanel.class, (String)"CB_DRIVER_DEPLOY"));
        this.enableDriverDeployment.setMargin(new Insets(0, 0, 0, 0));
        this.enableDriverDeployment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionTabVisualPanel.this.enableDriverDeploymentActionPerformed(actionEvent);
            }
        });
        this.enableDriverDeployment.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                OptionTabVisualPanel.this.jdbcDriverDeploymentHelp(focusEvent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                OptionTabVisualPanel.this.clearDynamicHelp(focusEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.enableDatabaseStart, (String)NbBundle.getMessage(OptionTabVisualPanel.class, (String)"CB_JAVADB_START"));
        this.enableDatabaseStart.setMargin(new Insets(0, 0, 0, 0));
        this.enableDatabaseStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionTabVisualPanel.this.enableDatabaseStartActionPerformed(actionEvent);
            }
        });
        this.enableDatabaseStart.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                OptionTabVisualPanel.this.enableDatabaseStartHelp(focusEvent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                OptionTabVisualPanel.this.clearDynamicHelp(focusEvent);
            }
        });
        this.dynamicHelpLabel.setText(NbBundle.getMessage(OptionTabVisualPanel.class, (String)"OptionTabVisualPanel.dynamicHelpLabel.text"));
        this.dynamicHelpLabel.setFocusable(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((Component)this.dynamicHelpLabel)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.deploymentTimeoutLabel).add((Component)this.startupTimeoutLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.deploymentTimeoutValue, -1, 77, Short.MAX_VALUE).add((Component)this.startupTimeoutValue, -1, 77, Short.MAX_VALUE))).add((Component)this.enableDirectoryDeployment).add((Component)this.enableDriverDeployment).add((Component)this.enableDatabaseStart)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.startupTimeoutLabel).add((Component)this.startupTimeoutValue, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.deploymentTimeoutLabel).add((Component)this.deploymentTimeoutValue, -2, -1, -2)).addPreferredGap(0).add((Component)this.enableDirectoryDeployment).addPreferredGap(0).add((Component)this.enableDriverDeployment).addPreferredGap(0).add((Component)this.enableDatabaseStart).addPreferredGap(0).add((Component)this.dynamicHelpLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.startupTimeoutValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OptionTabVisualPanel.class, (String)"ACSD_STARTUP_TIMEOUT"));
        this.deploymentTimeoutValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OptionTabVisualPanel.class, (String)"ACSD_DEPLOYMENT_TIMEOUT"));
        this.enableDirectoryDeployment.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OptionTabVisualPanel.class, (String)"ACSD_DirectoryDeploy"));
        this.enableDriverDeployment.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OptionTabVisualPanel.class, (String)"ACSD_DRIVER_DEPLOY"));
        this.enableDatabaseStart.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OptionTabVisualPanel.class, (String)"ACSD_DATABASE_START"));
    }

    private void clearDynamicHelp(FocusEvent focusEvent) {
        this.updateDynamicHelp("");
    }

    private void jdbcDriverDeploymentHelp(FocusEvent focusEvent) {
        this.updateDynamicHelp(NbBundle.getMessage(OptionTabVisualPanel.class, (String)"HLP_DRIVER_DEPLOYMENT"));
    }

    private void directoryDeploymentHelp(FocusEvent focusEvent) {
        this.updateDynamicHelp(NbBundle.getMessage(OptionTabVisualPanel.class, (String)"HLP_DIRECTORY_DEPLOYMENT"));
    }

    private void deploymentTimeoutHelp(FocusEvent focusEvent) {
        this.updateDynamicHelp(NbBundle.getMessage(OptionTabVisualPanel.class, (String)"HLP_DEPLOYMENT_TIMEOUT"));
    }

    private void startupTimeoutHelp(FocusEvent focusEvent) {
        this.updateDynamicHelp(NbBundle.getMessage(OptionTabVisualPanel.class, (String)"HLP_STARTUP_TIMEOUT"));
    }

    private void enableDriverDeploymentActionPerformed(ActionEvent actionEvent) {
        this.dmp.setDriverDeploymentEnabled(this.enableDriverDeployment.isSelected());
    }

    private void enableDirectoryDeploymentActionPerformed(ActionEvent actionEvent) {
        this.dmp.setDirectoryDeploymentPossible(this.enableDirectoryDeployment.isSelected());
    }

    private void deploymentTimeoutValueKeyReleased(KeyEvent keyEvent) {
        int n = this.dmp.getDeploymentTimeout();
        String string = this.deploymentTimeoutValue.getText();
        try {
            int n2 = Integer.parseInt(string);
            if (0 <= n2) {
                this.dmp.setDeploymentTimeout(n2);
                if (string.charAt(0) == '0') {
                    this.deploymentTimeoutValue.setText(n2 + "");
                }
            } else {
                this.deploymentTimeoutValue.setText(n + "");
            }
        }
        catch (NumberFormatException numberFormatException) {
            if ("".equals(string)) {
                this.deploymentTimeoutValue.setText("0");
                this.dmp.setDeploymentTimeout(0);
            }
            this.deploymentTimeoutValue.setText(n + "");
        }
    }

    private void startupTimeoutValueKeyReleased(KeyEvent keyEvent) {
        int n = this.dmp.getStartupTimeout();
        String string = this.startupTimeoutValue.getText();
        try {
            int n2 = Integer.parseInt(string);
            if (0 <= n2) {
                this.dmp.setStartupTimeout(n2);
                if (string.charAt(0) == '0') {
                    this.startupTimeoutValue.setText(n2 + "");
                }
            } else {
                this.startupTimeoutValue.setText(n + "");
            }
        }
        catch (NumberFormatException numberFormatException) {
            if ("".equals(string)) {
                this.startupTimeoutValue.setText("0");
                this.dmp.setStartupTimeout(0);
            }
            this.startupTimeoutValue.setText(n + "");
        }
    }

    private void enableDatabaseStartActionPerformed(ActionEvent actionEvent) {
        this.dmp.setDatabaseStartEnabled(this.enableDatabaseStart.isSelected());
    }

    private void enableDatabaseStartHelp(FocusEvent focusEvent) {
        this.updateDynamicHelp(NbBundle.getMessage(OptionTabVisualPanel.class, (String)"HLP_JAVADB_START"));
    }
}

