/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.concurrent.Future;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.nativeexecution.support.InstalledFileLocatorProvider;
import org.openide.modules.InstalledFileLocator;

public class HelperUtility {
    private final HashMap<ExecutionEnvironment, String> cache = new HashMap();
    private final String pattern;

    protected HelperUtility(String searchPattern) {
        this.pattern = searchPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getPath(ExecutionEnvironment env) throws IOException {
        if (!ConnectionManager.getInstance().isConnectedTo(env)) {
            throw new IllegalStateException(((Object)env).toString() + " is not connected");
        }
        if (!HostInfoUtils.isHostInfoAvailable(env)) {
            throw new IllegalStateException("No hostinfo for " + ((Object)env).toString());
        }
        String result = null;
        HashMap<ExecutionEnvironment, String> hashMap = this.cache;
        synchronized (hashMap) {
            result = this.cache.get(env);
            if (result == null) {
                try {
                    HostInfo hinfo = HostInfoUtils.getHostInfo(env);
                    String localFile = this.getLocalFileLocationFor(env);
                    if (env.isLocal()) {
                        result = localFile;
                    } else {
                        String fileName = new File(localFile).getName();
                        String remoteFile = hinfo.getTempDir() + '/' + fileName;
                        Future<Integer> uploadTask = CommonTasksSupport.uploadFile(localFile, env, remoteFile, 493, null, true);
                        Integer uploadResult = uploadTask.get();
                        if (uploadResult != 0) {
                            throw new IOException("Unable to upload " + fileName + " to " + env.getDisplayName());
                        }
                        result = remoteFile;
                    }
                    this.cache.put(env, result);
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }
        }
        return result;
    }

    private String getLocalFileLocationFor(ExecutionEnvironment env) throws ParseException, MissingResourceException {
        MacroExpanderFactory.MacroExpander expander;
        String path;
        InstalledFileLocator fl = InstalledFileLocatorProvider.getDefault();
        File file = fl.locate(path = (expander = MacroExpanderFactory.getExpander(env)).expandPredefinedMacros(this.pattern), null, false);
        if (file == null || !file.exists()) {
            throw new MissingResourceException(path, null, null);
        }
        return file.getAbsolutePath();
    }
}

