/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.loader;

import java.io.IOException;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.design.multiview.MultiViewSupport;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.openide.windows.CloneableOpenSupport;

public final class JaxWsDataObject
extends MultiDataObject {
    private static final String BUILD_IMPL_XML_PATH = "nbproject/build-impl.xml";
    private transient JaxWsJavaEditorSupport jes;
    private transient MultiViewSupport mvc;
    private transient Service service;

    public JaxWsDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.getCookieSet().assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject fileObject, String string) throws IOException {
                JaxWsDataObject.this.createEditorSupport().saveAs(fileObject, string);
            }
        }});
        this.getCookieSet().add(JaxWsJavaEditorSupport.class, new CookieSet.Factory(){

            public <T extends Node.Cookie> T createCookie(Class<T> clazz) {
                return (T)((Node.Cookie)clazz.cast((Object)JaxWsDataObject.this.createEditorSupport()));
            }
        });
        this.getCookieSet().add(MultiViewSupport.class, new CookieSet.Factory(){

            public <T extends Node.Cookie> T createCookie(Class<T> clazz) {
                MultiViewSupport multiViewSupport = JaxWsDataObject.this.createMultiViewCookie();
                if (multiViewSupport != null) {
                    return (T)((Node.Cookie)clazz.cast(multiViewSupport));
                }
                return null;
            }
        });
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    private void lazyInitialize() {
        if (this.service == null) {
            this.service = this.findService();
        }
    }

    private Service findService() {
        FileObject fileObject = this.getPrimaryFile();
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        JaxWsModel jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel == null) {
            return null;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath == null) {
            return null;
        }
        String string = classPath.getResourceName(fileObject, '.', false);
        if (string == null) {
            return null;
        }
        return jaxWsModel.findServiceByImplementationClass(string);
    }

    public Node createNodeDelegate() {
        this.lazyInitialize();
        return new JaxWsDataNode((DataObject)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDelete() throws IOException {
        String string;
        super.handleDelete();
        Project project = FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile());
        JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
        if (this.service != null && jAXWSSupport != null && (string = this.service.getName()) != null) {
            Object object;
            FileObject fileObject = jAXWSSupport.getLocalWsdlFolderForService(string, false);
            if (fileObject != null) {
                FileObject fileObject2;
                object = null;
                FileObject fileObject3 = fileObject.getParent();
                try {
                    object = fileObject3.lock();
                    fileObject3.delete((FileLock)object);
                }
                finally {
                    if (object != null) {
                        object.releaseLock();
                    }
                }
                FileObject fileObject4 = jAXWSSupport.getWsdlFolder(false);
                if (fileObject4 != null && (fileObject2 = fileObject4.getFileObject(string)) != null) {
                    try {
                        object = fileObject2.lock();
                        fileObject2.delete((FileLock)object);
                    }
                    finally {
                        if (object != null) {
                            object.releaseLock();
                        }
                    }
                }
                fileObject2 = project.getProjectDirectory().getFileObject(BUILD_IMPL_XML_PATH);
                try {
                    ExecutorTask executorTask = ActionUtils.runTarget((FileObject)fileObject2, (String[])new String[]{"wsimport-service-clean-" + string}, null);
                    executorTask.waitFinished();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().log(iOException.getLocalizedMessage());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorManager.getDefault().log(illegalArgumentException.getLocalizedMessage());
                }
            }
            jAXWSSupport.removeService(string);
            object = ((JaxWsModel)project.getLookup().lookup(JaxWsModel.class)).getJsr109();
            if (object != null && !((Boolean)object).booleanValue()) {
                if (this.service.getWsdlUrl() != null) {
                    string = this.service.getServiceName();
                }
                jAXWSSupport.removeNonJsr109Entries(string);
            }
        }
    }

    protected DataObject handleCopyRename(DataFolder dataFolder, String string, String string2) throws IOException {
        FileObject fileObject = this.getPrimaryEntry().copyRename(dataFolder.getPrimaryFile(), string, string2);
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        return dataObject;
    }

    public boolean isRenameAllowed() {
        return false;
    }

    private synchronized JaxWsJavaEditorSupport createEditorSupport() {
        if (this.jes == null) {
            this.jes = new JaxWsJavaEditorSupport(this);
        }
        return this.jes;
    }

    private synchronized MultiViewSupport createMultiViewCookie() {
        this.lazyInitialize();
        if (this.mvc == null) {
            this.createEditorSupport();
            if (this.getPrimaryFile().getAttribute("jax-ws-service-provider") == null) {
                this.mvc = new MultiViewSupport(this.service, (DataObject)this);
            }
        }
        return this.mvc;
    }

    public static final class JaxWsJavaEditorSupport
    extends DataEditorSupport
    implements OpenCookie,
    EditCookie,
    EditorCookie,
    PrintCookie,
    EditorCookie.Observable {
        public JaxWsJavaEditorSupport(JaxWsDataObject jaxWsDataObject) {
            super((DataObject)jaxWsDataObject, (CloneableEditorSupport.Env)new Environment(jaxWsDataObject));
            this.setMIMEType("text/x-java");
        }

        protected boolean notifyModified() {
            if (!super.notifyModified()) {
                return false;
            }
            ((Environment)this.env).addSaveCookie();
            return true;
        }

        protected void notifyUnmodified() {
            super.notifyUnmodified();
            ((Environment)this.env).removeSaveCookie();
        }

        protected CloneableEditorSupport.Pane createPane() {
            MultiViewSupport multiViewSupport = (MultiViewSupport)((JaxWsDataObject)this.getDataObject()).getCookie(MultiViewSupport.class);
            if (multiViewSupport == null) {
                return super.createPane();
            }
            return (CloneableEditorSupport.Pane)multiViewSupport.createMultiView();
        }

        public boolean close(boolean bl) {
            return super.close(bl);
        }

        protected boolean asynchronousOpen() {
            return true;
        }

        private static final class Environment
        extends DataEditorSupport.Env {
            private static final long serialVersionUID = -1L;
            private transient SaveSupport saveCookie = null;

            public Environment(JaxWsDataObject jaxWsDataObject) {
                super((DataObject)jaxWsDataObject);
            }

            protected FileObject getFile() {
                return this.getDataObject().getPrimaryFile();
            }

            protected FileLock takeLock() throws IOException {
                return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
            }

            public CloneableOpenSupport findCloneableOpenSupport() {
                return (CloneableEditorSupport)((JaxWsDataObject)this.getDataObject()).getCookie(EditorCookie.class);
            }

            public void addSaveCookie() {
                JaxWsDataObject jaxWsDataObject = (JaxWsDataObject)this.getDataObject();
                if (jaxWsDataObject.getCookie(SaveCookie.class) == null) {
                    if (this.saveCookie == null) {
                        this.saveCookie = new SaveSupport();
                    }
                    jaxWsDataObject.getCookieSet().add((Node.Cookie)this.saveCookie);
                    jaxWsDataObject.setModified(true);
                }
            }

            public void removeSaveCookie() {
                JaxWsDataObject jaxWsDataObject = (JaxWsDataObject)this.getDataObject();
                if (jaxWsDataObject.getCookie(SaveCookie.class) != null) {
                    jaxWsDataObject.getCookieSet().remove((Node.Cookie)this.saveCookie);
                    jaxWsDataObject.setModified(false);
                }
            }

            private final class SaveSupport
            implements SaveCookie {
                private SaveSupport() {
                }

                public void save() throws IOException {
                    ((JaxWsJavaEditorSupport)Environment.this.findCloneableOpenSupport()).saveDocument();
                    Environment.this.getDataObject().setModified(false);
                }
            }
        }
    }

    static class JaxWsDataNode
    extends DataNode {
        public JaxWsDataNode(DataObject dataObject) {
            super(dataObject, Children.LEAF);
            this.setIconBaseWithExtension("org/netbeans/modules/websvc/core/webservices/ui/resources/XMLServiceDataIcon.png");
        }

        public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
            if (clazz.isAssignableFrom(OpenCookie.class)) {
                return (T)((Node.Cookie)clazz.cast((Object)((JaxWsDataObject)this.getDataObject()).createEditorSupport()));
            }
            return (T)super.getCookie(clazz);
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        public boolean canCut() {
            return false;
        }
    }
}

