/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.actions;

import java.util.ArrayList;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class DeleteServiceAction
extends NodeAction {
    protected boolean enable(Node[] nodes) {
        for (Node n : nodes) {
            Saas saas = (Saas)n.getLookup().lookup(Saas.class);
            if (saas != null && saas.isUserDefined()) continue;
            return false;
        }
        return true;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return "org/netbeans/modules/websvc/saas/ui/resources/ActionIcon.gif";
    }

    public String getName() {
        return NbBundle.getMessage(DeleteServiceAction.class, (String)"DELETE");
    }

    protected void performAction(Node[] nodes) {
        final ArrayList<Saas> saases = new ArrayList<Saas>();
        for (Node n : nodes) {
            Saas saas = (Saas)n.getLookup().lookup(Saas.class);
            if (saas == null || !saas.isUserDefined()) {
                throw new IllegalArgumentException("Some nodes have no associated Saas");
            }
            saases.add(saas);
        }
        String msg = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"WS_DELETE", saases);
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)msg, 0);
        Object response = DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
        if (null != response && response.equals(NotifyDescriptor.YES_OPTION)) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    for (Saas saas : saases) {
                        SaasServicesModel.getInstance().removeService(saas);
                    }
                }
            });
        }
    }

    protected boolean asynchronous() {
        return false;
    }
}

