/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.exportfile.EfAttribute;
import com.sun.javacard.exportfile.EfConstantPool;
import com.sun.javacard.exportfile.ExportFileFormatError;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class EfConstantValueAttribute
extends EfAttribute {
    private String name = "ConstantValue";
    private int name_index;
    private int value;
    private int value_index;
    private int attribute_length = 2;
    private EfConstantPool cp;

    public EfConstantValueAttribute(EfConstantPool efConstantPool) {
        this.cp = efConstantPool;
    }

    public EfConstantValueAttribute(EfConstantPool efConstantPool, int n) {
        this.cp = efConstantPool;
        this.name_index = efConstantPool.addConstantUtf8(this.name);
        this.value = n;
        this.value_index = efConstantPool.addConstantInteger(n);
    }

    @Override
    public void parse(DataInputStream dataInputStream) throws IOException {
        this.name_index = dataInputStream.readUnsignedShort();
        if (dataInputStream.readInt() != 2) {
            throw new ExportFileFormatError();
        }
        this.value_index = dataInputStream.readUnsignedShort();
    }

    @Override
    public void resolve() {
        this.name = this.cp.getConstantUtf8(this.name_index).getUtf8String();
        this.value = this.cp.getConstantInteger(this.value_index).getIntValue();
    }

    @Override
    public void toText(PrintWriter printWriter, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
        }
        String string = stringBuffer.toString();
        printWriter.println(string + "ConstantValue_attribute {");
        printWriter.println(string + "\tattribute_name_index\t" + this.name_index + "\t\t// " + this.name);
        printWriter.println(string + "\tattribute_length\t" + 2);
        printWriter.println(string + "\tconstantvalue_index\t" + this.value_index + "\t\t// value = " + this.value);
        printWriter.println(string + "}");
    }

    @Override
    public void toBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeInt(this.attribute_length);
        dataOutputStream.writeShort(this.value_index);
    }

    public String getName() {
        return this.name;
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public int getValue() {
        return this.value;
    }

    public int getValueIndex() {
        return this.value_index;
    }

    public int getAttributeLength() {
        return this.attribute_length;
    }
}

