/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.PackageIdentifier;

public abstract class Info {
    public static final int CLASS_REF = 1;
    public static final int INSTANCE_FIELD_REF = 2;
    public static final int VIRTUAL_METHOD_REF = 3;
    public static final int SUPER_METHOD_REF = 4;
    public static final int STATIC_FIELD_REF = 5;
    public static final int STATIC_METHOD_REF = 6;
    static final int INFO_SIZE = 4;
    public int tag;
    protected boolean isPackageInternal;
    protected String name;
    protected PackageIdentifier packageIdentifier;
    protected int classToken;
    protected Member resolvedTo;
    protected int lineNumber;
    protected String descriptor;

    Info(int n, PackageIdentifier packageIdentifier, String string, String string2) {
        this.tag = n;
        this.packageIdentifier = packageIdentifier;
        this.name = string;
        this.descriptor = string2;
        this.isPackageInternal = true;
    }

    Info(int n, PackageIdentifier packageIdentifier, int n2, String string) {
        this.tag = n;
        this.packageIdentifier = packageIdentifier;
        this.classToken = n2;
        this.descriptor = string;
        this.name = packageIdentifier.toString() + " " + Integer.toString(n2);
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void resolve(Member member) {
        assert (member != null) : "member != null";
        this.resolvedTo = member;
    }

    public Member resolve() {
        assert (this.resolvedTo != null) : "resolvedTo != null";
        return this.resolvedTo;
    }

    public boolean isResolved() {
        return this.resolvedTo != null;
    }

    public int size() {
        return 4;
    }

    public int getType() {
        return this.tag;
    }

    public String getName() {
        return this.name;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public PackageIdentifier getPackageIdentifier() {
        return this.packageIdentifier;
    }

    public int getClassToken() {
        return this.classToken;
    }

    public boolean isPackageInternal() {
        return this.isPackageInternal;
    }

    public byte[] toByteArray(JCPackage jCPackage) {
        byte[] byArray = new byte[this.size()];
        byArray[0] = (byte)this.tag;
        return byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.resolvedTo != null) {
            stringBuffer.append(this.resolvedTo.getName());
        } else if (this.isPackageInternal) {
            if (this.name != null) {
                stringBuffer.append(this.name);
            } else {
                stringBuffer.append("??");
            }
        } else {
            stringBuffer.append(this.packageIdentifier + " " + this.classToken);
        }
        return stringBuffer.toString();
    }
}

