/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.RubyEvent;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class NewlineNode
extends Node {
    private final Node nextNode;

    public NewlineNode(ISourcePosition position, Node nextNode) {
        super(position, NodeType.NEWLINENODE);
        assert (nextNode != null) : "nextNode is not null";
        this.nextNode = nextNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitNewlineNode(this);
    }

    public Node getNextNode() {
        return this.nextNode;
    }

    @Override
    public List<Node> childNodes() {
        return NewlineNode.createList(this.nextNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        ISourcePosition position = this.getPosition();
        context.setFile(position.getFile());
        context.setLine(position.getStartLine());
        if (runtime.hasEventHooks()) {
            ASTInterpreter.callTraceFunction(runtime, context, RubyEvent.LINE);
        }
        return this.nextNode.interpret(runtime, context, self, aBlock);
    }

    @Override
    public String toString() {
        return "NewlineNode\n  " + this.getNextNode().toString();
    }
}

