/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.codetemplates;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.editor.completion.GsfCompletionProvider;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.util.Exceptions;

public class GsfCodeTemplateFilter
extends UserTask
implements CodeTemplateFilter {
    private int startOffset;
    private int endOffset;
    private Set<String> templates;
    private boolean cancelled;

    private GsfCodeTemplateFilter(JTextComponent component, int offset) {
        this.startOffset = offset;
        this.endOffset = component.getSelectionStart() == offset ? component.getSelectionEnd() : -1;
        Source js = Source.create((Document)component.getDocument());
        if (js != null) {
            try {
                Future f = ParserManager.parseWhenScanFinished(Collections.singleton(js), (UserTask)this);
                if (!f.isDone()) {
                    f.cancel(true);
                }
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public boolean accept(CodeTemplate template) {
        if (this.templates != null && template != null && template.getParametrizedText().indexOf("${selection") != -1) {
            return this.templates.contains(template.getAbbreviation()) || template.getParametrizedText().indexOf("allowSurround") != -1;
        }
        return true;
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public void run(ResultIterator resultIterator) throws IOException, ParseException {
        if (this.isCancelled()) {
            return;
        }
        Parser.Result result = resultIterator.getParserResult(this.startOffset);
        if (!(result instanceof ParserResult)) {
            return;
        }
        ParserResult parserResult = (ParserResult)result;
        Snapshot snapshot = parserResult.getSnapshot();
        CodeCompletionHandler completer = GsfCompletionProvider.getCompletable(snapshot.getSource().getDocument(true), this.startOffset);
        if (completer != null && !this.isCancelled()) {
            this.templates = completer.getApplicableTemplates(parserResult, this.startOffset, this.endOffset);
        }
    }

    public static final class Factory
    implements CodeTemplateFilter.Factory {
        public CodeTemplateFilter createFilter(JTextComponent component, int offset) {
            return new GsfCodeTemplateFilter(component, offset);
        }
    }
}

