/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.ui;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLClassLoader;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.modules.websvc.manager.ui.ArrayTypeTreeNode;
import org.netbeans.modules.websvc.manager.ui.HolderTypeTreeNode;
import org.netbeans.modules.websvc.manager.ui.JAXBElementTreeNode;
import org.netbeans.modules.websvc.manager.ui.ListTypeTreeNode;
import org.netbeans.modules.websvc.manager.ui.ReflectionHelper;
import org.netbeans.modules.websvc.manager.ui.StructureTypeTreeNode;
import org.netbeans.modules.websvc.manager.ui.TypeNodeData;
import org.netbeans.modules.websvc.manager.ui.WebServiceReflectionException;
import org.openide.ErrorManager;

public final class NodeHelper {
    private final URLClassLoader loader;
    private static NodeHelper instance;

    private NodeHelper(URLClassLoader uRLClassLoader) {
        this.loader = uRLClassLoader;
    }

    public static NodeHelper createInstance(URLClassLoader uRLClassLoader) {
        NodeHelper nodeHelper;
        instance = nodeHelper = new NodeHelper(uRLClassLoader);
        return nodeHelper;
    }

    public static NodeHelper getInstance() {
        return instance;
    }

    private URLClassLoader getRuntimeClassLoader() {
        return this.loader;
    }

    public DefaultMutableTreeNode createNodeFromData(TypeNodeData typeNodeData) throws WebServiceReflectionException {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        String string = typeNodeData.getTypeClass();
        if (ReflectionHelper.isHolder(string)) {
            defaultMutableTreeNode = new HolderTypeTreeNode(typeNodeData, this.getRuntimeClassLoader());
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            String string2 = typeNodeData.getGenericType();
            if (string2 == null) {
                string2 = "java.lang.Object";
                typeNodeData.setGenericType(string2);
            }
            TypeNodeData typeNodeData2 = ReflectionHelper.createTypeData(string2, "value");
            typeNodeData2.setTypeValue(this.getParameterDefaultValue(typeNodeData2));
            typeNodeData2.setAssignable(typeNodeData.isAssignable());
            ReflectionHelper.setHolderValue(typeNodeData.getTypeValue(), typeNodeData2.getTypeValue());
            defaultMutableTreeNode2 = this.createNodeFromData(typeNodeData2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        } else if (ReflectionHelper.isJAXBElement(string)) {
            defaultMutableTreeNode = new JAXBElementTreeNode(typeNodeData, this.getRuntimeClassLoader());
            TypeNodeData typeNodeData3 = ReflectionHelper.createTypeData("java.lang.String", "localPart");
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(typeNodeData3);
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            String string3 = typeNodeData.getGenericType();
            if (string3 == null) {
                string3 = "java.lang.Object";
                typeNodeData.setGenericType(string3);
            }
            TypeNodeData typeNodeData4 = ReflectionHelper.createTypeData(string3, "value");
            typeNodeData4.setTypeValue(this.getParameterDefaultValue(typeNodeData4));
            typeNodeData4.setAssignable(typeNodeData.isAssignable());
            DefaultMutableTreeNode defaultMutableTreeNode4 = this.createNodeFromData(typeNodeData4);
            defaultMutableTreeNode.add(defaultMutableTreeNode4);
        } else if (ReflectionHelper.isArray(string)) {
            defaultMutableTreeNode = new ArrayTypeTreeNode((Object)typeNodeData, this.getRuntimeClassLoader());
            this.addParameterArrayInstances(defaultMutableTreeNode);
        } else if (ReflectionHelper.isCollection(typeNodeData.getTypeClass(), this.getRuntimeClassLoader())) {
            defaultMutableTreeNode = new ListTypeTreeNode(typeNodeData, this.getRuntimeClassLoader());
            this.addParameterArrayInstances(defaultMutableTreeNode);
        } else if (ReflectionHelper.isComplexType(typeNodeData.getTypeClass(), this.getRuntimeClassLoader())) {
            defaultMutableTreeNode = new StructureTypeTreeNode(typeNodeData, this.getRuntimeClassLoader());
            this.traverseType(defaultMutableTreeNode);
        } else {
            defaultMutableTreeNode = new DefaultMutableTreeNode(typeNodeData);
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode createResultNodeFromData(TypeNodeData typeNodeData) throws WebServiceReflectionException {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        String string = typeNodeData.getTypeClass();
        if (ReflectionHelper.isCollection(string, this.getRuntimeClassLoader())) {
            defaultMutableTreeNode = new ListTypeTreeNode(typeNodeData, this.getRuntimeClassLoader());
            this.addResultArrayInstances(defaultMutableTreeNode);
        } else if (ReflectionHelper.isComplexType(string, this.getRuntimeClassLoader())) {
            defaultMutableTreeNode = new StructureTypeTreeNode(typeNodeData, this.getRuntimeClassLoader());
            this.traverseResultType(defaultMutableTreeNode);
        } else {
            defaultMutableTreeNode = new DefaultMutableTreeNode(typeNodeData);
        }
        return defaultMutableTreeNode;
    }

    private void traverseType(DefaultMutableTreeNode defaultMutableTreeNode) throws WebServiceReflectionException {
        if (null == defaultMutableTreeNode) {
            return;
        }
        TypeNodeData typeNodeData = (TypeNodeData)defaultMutableTreeNode.getUserObject();
        String string = typeNodeData.getTypeClass();
        List<String> list = ReflectionHelper.getPropertyNames(string, this.getRuntimeClassLoader());
        for (String string2 : list) {
            String string3 = ReflectionHelper.getPropertyType(string, string2, this.getRuntimeClassLoader());
            TypeNodeData typeNodeData2 = ReflectionHelper.createTypeData(string3, string2);
            typeNodeData2.setTypeValue(this.getParameterDefaultValue(typeNodeData2));
            if (!ReflectionHelper.isPropertySettable(string, string2, this.getRuntimeClassLoader())) {
                typeNodeData2.setAssignable(false);
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.createNodeFromData(typeNodeData2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    private void traverseResultType(DefaultMutableTreeNode defaultMutableTreeNode) throws WebServiceReflectionException {
        if (null == defaultMutableTreeNode) {
            return;
        }
        TypeNodeData typeNodeData = (TypeNodeData)defaultMutableTreeNode.getUserObject();
        String string = typeNodeData.getTypeClass();
        Object object = typeNodeData.getTypeValue();
        if (object != null) {
            List<String> list = ReflectionHelper.getPropertyNames(string, this.getRuntimeClassLoader());
            for (String string2 : list) {
                String string3 = ReflectionHelper.getPropertyType(string, string2, this.getRuntimeClassLoader());
                Object object2 = ReflectionHelper.getPropertyValue(object, string2, this.getRuntimeClassLoader());
                TypeNodeData typeNodeData2 = ReflectionHelper.createTypeData(string3, string2, object2);
                DefaultMutableTreeNode defaultMutableTreeNode2 = this.createResultNodeFromData(typeNodeData2);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }
    }

    private void addParameterArrayInstances(DefaultMutableTreeNode defaultMutableTreeNode) throws WebServiceReflectionException {
        TypeNodeData typeNodeData = (TypeNodeData)defaultMutableTreeNode.getUserObject();
        String string = typeNodeData.getTypeClass();
        String string2 = typeNodeData.getGenericType();
        for (int i = 0; i < 9; ++i) {
            TypeNodeData typeNodeData2 = ReflectionHelper.createTypeData(string2, "[" + i + "]");
            typeNodeData2.setTypeValue(this.getParameterDefaultValue(typeNodeData2));
            typeNodeData2.setAssignable(typeNodeData.isAssignable());
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.createNodeFromData(typeNodeData2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    private void addResultArrayInstances(DefaultMutableTreeNode defaultMutableTreeNode) throws WebServiceReflectionException {
        Collection collection;
        TypeNodeData typeNodeData = (TypeNodeData)defaultMutableTreeNode.getUserObject();
        String string = typeNodeData.getTypeClass();
        String string2 = typeNodeData.getGenericType();
        if (string2 == null) {
            string2 = "java.lang.Object";
            typeNodeData.setGenericType(string2);
        }
        if ((collection = (Collection)typeNodeData.getTypeValue()) == null) {
            return;
        }
        int n = 0;
        for (Object e : collection) {
            TypeNodeData typeNodeData2 = ReflectionHelper.createTypeData(string2, "[" + n + "]", e);
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.createResultNodeFromData(typeNodeData2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            ++n;
        }
    }

    public Object getParameterDefaultValue(TypeNodeData typeNodeData) {
        assert (typeNodeData != null);
        try {
            String string = typeNodeData.getTypeClass();
            if (ReflectionHelper.isComplexType(string, this.getRuntimeClassLoader())) {
                return ReflectionHelper.makeComplexType(string, this.getRuntimeClassLoader());
            }
            if (ReflectionHelper.isCollection(string, this.getRuntimeClassLoader())) {
                return ReflectionHelper.makeCollection(string, this.getRuntimeClassLoader());
            }
            if (ReflectionHelper.isHolder(string)) {
                return ReflectionHelper.makeHolder(this.getRuntimeClassLoader());
            }
            if (ReflectionHelper.isEnumeration(string, this.getRuntimeClassLoader())) {
                return ReflectionHelper.makeEnumeration(string, this.getRuntimeClassLoader());
            }
            if (ReflectionHelper.isArray(string)) {
                return ReflectionHelper.makeGenericArray(typeNodeData.getGenericType(), 0, this.getRuntimeClassLoader());
            }
            String string2 = string;
            Object object = null;
            if (string2.equals(Integer.TYPE.getName()) || string2.equals(Integer.class.getName())) {
                object = new Integer(0);
            } else if (string2.equals(Byte.TYPE.getName()) || string2.equals(Byte.class.getName())) {
                object = new Byte("0");
            } else if (string2.equals(Boolean.TYPE.getName()) || string2.equals(Boolean.class.getName())) {
                object = new Boolean(false);
            } else if (string2.equals(Float.TYPE.getName()) || string2.equals(Float.class.getName())) {
                object = new Float(0.0f);
            } else if (string2.equals(Double.TYPE.getName()) || string2.equals(Double.class.getName())) {
                object = new Double(0.0);
            } else if (string2.equals(Long.TYPE.getName()) || string2.equals(Long.class.getName())) {
                object = new Long(0L);
            } else if (string2.equals(Short.TYPE.getName()) || string2.equals(Short.class.getName())) {
                object = new Short("0");
            } else if (string2.equals(String.class.getName())) {
                object = "";
            } else if (string2.equals(BigDecimal.class.getName())) {
                object = new BigDecimal("0");
            } else if (string2.equals(BigInteger.class.getName())) {
                object = new BigInteger("0");
            } else if (string2.equals(URI.class.getName())) {
                try {
                    object = new URI("http://java.sun.com");
                }
                catch (URISyntaxException uRISyntaxException) {}
            } else if (string2.equals(Calendar.class.getName())) {
                object = Calendar.getInstance();
            } else if (string2.equalsIgnoreCase(Date.class.getName())) {
                object = new Date();
            }
            return object;
        }
        catch (WebServiceReflectionException webServiceReflectionException) {
            Throwable throwable = webServiceReflectionException.getCause();
            ErrorManager.getDefault().notify(throwable);
            ErrorManager.getDefault().log(this.getClass().getName() + ": Error trying to do Class.forName on: " + typeNodeData.getRealTypeName() + "WebServiceReflectionException=" + throwable);
            return null;
        }
    }
}

