/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.navigator;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class ROUtil {
    private static final HashMap<File, WeakReference<LocalFileSystem>> cache = new HashMap();

    static FileObject checkPOMFileObjectReadOnly(FileObject fo, File file) {
        LocalFileSystem lfs;
        FileObject toRet = fo;
        if ("pom".equals(fo.getExt()) && (toRet = (lfs = ROUtil.checkFSCache(file)).findResource(ROUtil.getPath(file))) == null) {
            Logger.getLogger(ROUtil.class.getName()).info("Could not find a ReadOnly fileobject for " + ROUtil.getPath(file) + " in " + lfs.getRootDirectory() + ": " + lfs);
            toRet = fo;
        }
        return toRet;
    }

    static DataObject checkPOMFileObjectReadOnly(DataObject dobj) {
        DataObject toRet = dobj;
        FileObject fo = dobj.getPrimaryFile();
        File fl = FileUtil.toFile((FileObject)fo);
        if (fl != null) {
            fo = ROUtil.checkPOMFileObjectReadOnly(fo, fl);
            try {
                toRet = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
        }
        return toRet;
    }

    private static String getPath(File file) {
        File versionFolder = file.getParentFile();
        assert (versionFolder != null) : "wrong parent for " + file;
        File artifactFolder = versionFolder.getParentFile();
        assert (artifactFolder != null) : "wrong parent for " + versionFolder;
        return artifactFolder.getName() + "/" + versionFolder.getName() + "/" + file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LocalFileSystem checkFSCache(File file) {
        File versionFolder = file.getParentFile();
        assert (versionFolder != null) : "wrong parent for " + file;
        File artifactFolder = versionFolder.getParentFile();
        assert (artifactFolder != null) : "wrong parent for " + versionFolder;
        File groupFolder = artifactFolder.getParentFile();
        assert (groupFolder != null) : "wrong parent for " + artifactFolder;
        LocalFileSystem fs = null;
        HashMap<File, WeakReference<LocalFileSystem>> hashMap = cache;
        synchronized (hashMap) {
            WeakReference<LocalFileSystem> ref = cache.get(groupFolder);
            if (ref != null) {
                fs = (LocalFileSystem)ref.get();
            }
            if (fs == null) {
                fs = new LocalFileSystem();
                fs.setReadOnly(true);
                try {
                    fs.setRootDirectory(groupFolder);
                    cache.put(groupFolder, new WeakReference<LocalFileSystem>(fs));
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return fs;
    }
}

