/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.SearchHistoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.GetCleanAction;
import org.netbeans.modules.versioning.system.cvss.ui.history.DiffResultsView;
import org.netbeans.modules.versioning.system.cvss.ui.history.RevisionNodeChildren;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel;
import org.netbeans.modules.versioning.system.cvss.ui.history.SummaryView;
import org.netbeans.modules.versioning.system.cvss.ui.history.ViewRevisionAction;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class RevisionNode
extends AbstractNode {
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_LOCATION = "location";
    static final String COLUMN_NAME_DATE = "date";
    static final String COLUMN_NAME_USERNAME = "username";
    static final String COLUMN_NAME_TAGS = "tags";
    static final String COLUMN_NAME_MESSAGE = "message";
    private SearchHistoryPanel.DispRevision revision;
    private SearchHistoryPanel.ResultsContainer container;
    private String path;

    public RevisionNode(SearchHistoryPanel.ResultsContainer container) {
        super((Children)new RevisionNodeChildren(container), Lookups.singleton((Object)container));
        this.container = container;
        this.revision = null;
        this.path = container.getPath();
        this.setName(container.getRevisions().get(0).getRevision().getLogInfoHeader().getFile().getName());
        this.initProperties();
    }

    public RevisionNode(SearchHistoryPanel.DispRevision revision) {
        super((Children)(revision.getChildren() == null ? Children.LEAF : new RevisionNodeChildren(revision)), Lookups.fixed((Object[])new Object[]{revision}));
        this.path = revision.getPath();
        this.revision = revision;
        if (revision.getRevision().getNumber() == "") {
            this.setName(NbBundle.getMessage(DiffResultsView.class, (String)"LBL_DiffPanel_LocalCopy"));
        } else if (revision.isBranchRoot()) {
            if (revision.getBranchName() != null) {
                this.setName(revision.getRevision().getNumber() + " - " + revision.getBranchName());
            } else {
                this.setName(revision.getRevision().getNumber());
            }
        } else {
            this.setName(revision.getRevision().getNumber());
        }
        this.initProperties();
    }

    SearchHistoryPanel.DispRevision getDispRevision() {
        return this.revision;
    }

    LogInformation.Revision getRevision() {
        return this.revision.getRevision();
    }

    SearchHistoryPanel.ResultsContainer getContainer() {
        return this.container;
    }

    public String getShortDescription() {
        return this.path;
    }

    public Action[] getActions(boolean context) {
        if (context) {
            return null;
        }
        if (this.revision == null || this.revision.getRevision().getNumber() == "") {
            return new Action[0];
        }
        if (!this.revision.isBranchRoot()) {
            return new Action[]{new RollbackAction(), new RollbackChangeAction(), new OpenRevisionAction(), new FindCommitAction(false), new FindCommitAction(true)};
        }
        return new Action[0];
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.put((Node.Property)new LocationProperty());
        ps.put((Node.Property)new DateProperty());
        ps.put((Node.Property)new UsernameProperty());
        ps.put((Node.Property)new TagsProperty());
        ps.put((Node.Property)new MessageProperty());
        sheet.put(ps);
        this.setSheet(sheet);
    }

    private static class TagsPropertyEditor
    extends PropertyEditorSupport {
        private static final JLabel renderer = new JLabel();
        private SearchHistoryPanel.DispRevision dispRevision;

        public TagsPropertyEditor(SearchHistoryPanel.DispRevision revision) {
            this.dispRevision = revision;
        }

        @Override
        public boolean isPaintable() {
            return true;
        }

        @Override
        public void paintValue(Graphics gfx, Rectangle box) {
            renderer.setForeground(gfx.getColor());
            renderer.setBounds(box);
            if (this.dispRevision == null || this.dispRevision.getBranches() == null) {
                renderer.setText("");
            } else {
                ArrayList<String> tags = new ArrayList<String>(this.dispRevision.getBranches());
                tags.addAll(this.dispRevision.getTags());
                if (tags.size() > 0) {
                    String tagInfo = "<html>" + (String)tags.get(0);
                    if (tags.size() > 1) {
                        tagInfo = tagInfo + ",";
                        Color foreground = UIManager.getColor("List.selectionForeground");
                        if (!gfx.getColor().equals(foreground)) {
                            tagInfo = tagInfo + " <a href=\"\">...</a>";
                        } else {
                            StringBuilder sb = new StringBuilder();
                            sb.append(" <a href=\"\" style=\"color:");
                            sb.append("rgb(");
                            sb.append(foreground.getRed());
                            sb.append(",");
                            sb.append(foreground.getGreen());
                            sb.append(",");
                            sb.append(foreground.getBlue());
                            sb.append(")");
                            sb.append("\">");
                            sb.append("...");
                            sb.append("</a>");
                            tagInfo = tagInfo + sb.toString();
                        }
                    }
                    renderer.setText(tagInfo);
                } else {
                    renderer.setText("");
                }
            }
            renderer.paint(gfx);
        }

        static {
            renderer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }
    }

    private static class RevisionPropertyEditor
    extends PropertyEditorSupport {
        private static final JLabel renderer = new JLabel();

        public RevisionPropertyEditor(String value) {
            this.setValue(value);
        }

        @Override
        public void paintValue(Graphics gfx, Rectangle box) {
            renderer.setForeground(gfx.getColor());
            renderer.setText((String)this.getValue());
            renderer.setBounds(box);
            renderer.paint(gfx);
        }

        @Override
        public boolean isPaintable() {
            return true;
        }

        static {
            renderer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }
    }

    private class RollbackChangeAction
    extends AbstractAction {
        public RollbackChangeAction() {
            this.putValue("Name", NbBundle.getMessage(RevisionNode.class, (String)"CTL_Action_RollbackChange"));
            this.setEnabled(Utils.previousRevision(RevisionNode.this.revision.getRevision().getNumber()) != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SummaryView.rollbackChanges(new LogInformation.Revision[]{RevisionNode.this.revision.getRevision()});
        }
    }

    private class RollbackAction
    extends AbstractAction {
        public RollbackAction() {
            this.putValue("Name", NbBundle.getMessage(RevisionNode.class, (String)"CTL_Action_RollbackTo", (Object)RevisionNode.this.revision.getRevision().getNumber()));
        }

        @Override
        public boolean isEnabled() {
            return !"dead".equals(RevisionNode.this.revision.getRevision().getState());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = RevisionNode.this.revision.getRevision().getLogInfoHeader().getFile();
            GetCleanAction.rollback(file, RevisionNode.this.revision.getRevision().getNumber());
        }
    }

    private class OpenRevisionAction
    extends AbstractAction {
        public OpenRevisionAction() {
            this.putValue("Name", NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_View", (Object)RevisionNode.this.revision.getRevision().getNumber()));
        }

        @Override
        public boolean isEnabled() {
            return !"dead".equals(RevisionNode.this.revision.getRevision().getState());
        }

        @Override
        public void actionPerformed(ActionEvent ex) {
            try {
                ViewRevisionAction.view(RevisionNode.this.revision.getRevision().getLogInfoHeader().getFile(), RevisionNode.this.revision.getRevision().getNumber(), null);
            }
            catch (Exception e) {
                Logger.getLogger(RevisionNode.class.getName()).log(Level.INFO, e.getMessage(), e);
            }
        }
    }

    private class FindCommitAction
    extends AbstractAction {
        private boolean allProjects;

        public FindCommitAction(boolean allProjects) {
            this.allProjects = allProjects;
            if (allProjects) {
                this.putValue("Name", NbBundle.getMessage(RevisionNode.class, (String)"CTL_Action_FindCommitInProjects"));
            } else {
                File file = RevisionNode.this.revision.getRevision().getLogInfoHeader().getFile();
                Project project = Utils.getProject(file);
                if (project != null) {
                    String prjName = ProjectUtils.getInformation((Project)project).getDisplayName();
                    this.putValue("Name", NbBundle.getMessage(RevisionNode.class, (String)"CTL_Action_FindCommitInProject", (Object)prjName));
                } else {
                    this.putValue("Name", NbBundle.getMessage(RevisionNode.class, (String)"CTL_Action_FindCommit"));
                    this.setEnabled(false);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = RevisionNode.this.revision.getRevision().getLogInfoHeader().getFile();
            if (this.allProjects) {
                Project[] projects = OpenProjects.getDefault().getOpenProjects();
                int n = projects.length;
                SearchHistoryAction.openSearch(n == 1 ? ProjectUtils.getInformation((Project)projects[0]).getDisplayName() : NbBundle.getMessage(SummaryView.class, (String)"CTL_FindAssociateChanges_OpenProjects_Title", (Object)Integer.toString(n)), RevisionNode.this.revision.getRevision().getMessage().trim(), RevisionNode.this.revision.getRevision().getAuthor(), RevisionNode.this.revision.getRevision().getDate());
            } else {
                Project project = Utils.getProject(file);
                Context context = Utils.getProjectsContext(new Project[]{project});
                SearchHistoryAction.openSearch(context, ProjectUtils.getInformation((Project)project).getDisplayName(), RevisionNode.this.revision.getRevision().getMessage().trim(), RevisionNode.this.revision.getRevision().getAuthor(), RevisionNode.this.revision.getRevision().getDate());
            }
        }
    }

    private class MessageProperty
    extends CommitNodeProperty {
        public MessageProperty() {
            super(RevisionNode.COLUMN_NAME_MESSAGE, String.class, RevisionNode.COLUMN_NAME_MESSAGE, RevisionNode.COLUMN_NAME_MESSAGE);
            if (RevisionNode.this.revision != null && RevisionNode.this.revision.getRevision().getMessage() != null) {
                this.setValue("messageRevision", RevisionNode.this.revision);
            }
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.revision != null) {
                return RevisionNode.this.revision.getRevision().getMessage();
            }
            return "";
        }
    }

    private class TagsProperty
    extends CommitNodeProperty {
        public TagsProperty() {
            super(RevisionNode.COLUMN_NAME_TAGS, List.class, RevisionNode.COLUMN_NAME_TAGS, RevisionNode.COLUMN_NAME_TAGS);
            if (RevisionNode.this.revision != null) {
                this.setValue("tagsRevision", RevisionNode.this.revision);
            }
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }

        @Override
        public PropertyEditor getPropertyEditor() {
            try {
                return new TagsPropertyEditor(RevisionNode.this.revision);
            }
            catch (Exception e) {
                return super.getPropertyEditor();
            }
        }
    }

    private class DateProperty
    extends CommitNodeProperty {
        private String dateString;

        public DateProperty() {
            super(RevisionNode.COLUMN_NAME_DATE, String.class, RevisionNode.COLUMN_NAME_DATE, RevisionNode.COLUMN_NAME_DATE);
            this.dateString = RevisionNode.this.revision == null || RevisionNode.this.revision.getRevision().getDate() == null ? "" : DateFormat.getDateTimeInstance().format(RevisionNode.this.revision.getRevision().getDate());
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.dateString;
        }
    }

    private class UsernameProperty
    extends CommitNodeProperty {
        public UsernameProperty() {
            super(RevisionNode.COLUMN_NAME_USERNAME, String.class, RevisionNode.COLUMN_NAME_USERNAME, RevisionNode.COLUMN_NAME_USERNAME);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.revision != null) {
                return RevisionNode.this.revision.getRevision().getAuthor();
            }
            return "";
        }
    }

    private class LocationProperty
    extends CommitNodeProperty {
        public LocationProperty() {
            super(RevisionNode.COLUMN_NAME_LOCATION, String.class, RevisionNode.COLUMN_NAME_LOCATION, RevisionNode.COLUMN_NAME_LOCATION);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.container != null) {
                return RevisionNode.this.path;
            }
            return "";
        }
    }

    private abstract class CommitNodeProperty
    extends PropertySupport.ReadOnly {
        protected CommitNodeProperty(String name, Class type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public String toString() {
            try {
                return this.getValue().toString();
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return e.getLocalizedMessage();
            }
        }

        public PropertyEditor getPropertyEditor() {
            try {
                return new RevisionPropertyEditor((String)this.getValue());
            }
            catch (Exception e) {
                return super.getPropertyEditor();
            }
        }
    }
}

