/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.openide.util.Exceptions;

public class SimpleConfigParser {
    private final Map<String, Map<String, String>> sections2attributes = new HashMap<String, Map<String, String>>();
    private final Map<String, String> orphanAttributes = new HashMap<String, String>();
    private final Pattern patternSection = Pattern.compile("\\[.+\\]");
    private final Pattern patternAttribute = Pattern.compile("[^=]+=[^=]+");
    private boolean parsed = false;

    public boolean parse(Reader text) {
        if (this.parsed) {
            return false;
        }
        try {
            BufferedReader reader = new BufferedReader(text);
            String currentSection = null;
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0) {
                    if (this.patternAttribute.matcher(line).matches()) {
                        int idxEq = line.indexOf(61);
                        String name = line.substring(0, idxEq).trim();
                        String value = line.substring(idxEq + 1).trim();
                        if (currentSection == null) {
                            this.orphanAttributes.put(name, value);
                        } else {
                            this.sections2attributes.get(currentSection).put(name, value);
                        }
                    } else if (this.patternSection.matcher(line).matches() && !this.sections2attributes.containsKey(currentSection = line.substring(1, line.length() - 1).trim())) {
                        this.sections2attributes.put(currentSection, new HashMap());
                    }
                }
                line = reader.readLine();
            }
            this.parsed = true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return this.parsed;
    }

    public Set<String> getSections() {
        return this.parsed ? this.sections2attributes.keySet() : Collections.emptySet();
    }

    public Map<String, String> getAttributes(String section) {
        return this.parsed ? this.sections2attributes.get(section) : Collections.emptyMap();
    }

    public Map<String, String> getOrphanAttributes() {
        return this.parsed ? this.orphanAttributes : Collections.emptyMap();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        SimpleConfigParser.writeAttributes(sb, this.getOrphanAttributes());
        for (String section : this.getSections()) {
            Map<String, String> attributes = this.getAttributes(section);
            sb.append("[" + section + "]\n");
            SimpleConfigParser.writeAttributes(sb, attributes);
        }
        return sb.toString();
    }

    private static void writeAttributes(StringBuilder sb, Map<String, String> attributes) {
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            sb.append("\t" + entry.getKey() + "=" + entry.getValue() + "\n");
        }
    }
}

