/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.util.ArrayList;
import java.util.Arrays;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.jpa.model.AccessType;
import org.netbeans.modules.j2ee.jpa.model.AttributeWrapper;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.JPAEntityAttributeCheck;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemFinder;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.GeneratedValueIsId;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.MVRelationshipForEntityTypeAttrDefined;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.RelationshipForEntityTypeAttrDefined;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.TemporalFieldsAnnotated;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.ValidBasicType;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.ValidColumnName;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.ValidModifiers;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.ValidVersionType;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Basic;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Embeddable;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Id;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.MappedSuperclass;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Version;
import org.netbeans.spi.editor.hints.ErrorDescription;

public class ValidAttributes
extends JPAClassRule {
    private static JPAEntityAttributeCheck[] attribChecks = new JPAEntityAttributeCheck[]{new ValidColumnName(), new ValidModifiers(), new ValidBasicType(), new RelationshipForEntityTypeAttrDefined(), new MVRelationshipForEntityTypeAttrDefined(), new ValidVersionType(), new GeneratedValueIsId(), new TemporalFieldsAnnotated()};

    public ValidAttributes() {
        this.setClassContraints(Arrays.asList(JPAClassRule.ClassConstraints.ENTITY, JPAClassRule.ClassConstraints.EMBEDDABLE, JPAClassRule.ClassConstraints.MAPPED_SUPERCLASS));
    }

    @Override
    public ErrorDescription[] apply(TypeElement typeElement, ProblemContext problemContext) {
        JPAEntityAttributeCheck[] jPAEntityAttributeCheckArray;
        int n;
        int n2;
        Object object;
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        ArrayList<AttributeWrapper> arrayList2 = new ArrayList<AttributeWrapper>();
        Basic[] basicArray = null;
        Id[] idArray = null;
        Version[] versionArray = null;
        if (problemContext.getModelElement() instanceof Entity) {
            object = (Basic[])problemContext.getModelElement();
            basicArray = object.getAttributes().getBasic();
            idArray = object.getAttributes().getId();
            versionArray = object.getAttributes().getVersion();
        } else if (problemContext.getModelElement() instanceof Embeddable) {
            object = (Embeddable)problemContext.getModelElement();
            basicArray = object.getAttributes().getBasic();
        } else if (problemContext.getModelElement() instanceof MappedSuperclass) {
            object = (MappedSuperclass)problemContext.getModelElement();
            basicArray = object.getAttributes().getBasic();
            idArray = object.getAttributes().getId();
            versionArray = object.getAttributes().getVersion();
        }
        if (basicArray != null) {
            object = basicArray;
            n2 = ((Basic[])object).length;
            for (n = 0; n < n2; ++n) {
                jPAEntityAttributeCheckArray = object[n];
                arrayList2.add(new AttributeWrapper(jPAEntityAttributeCheckArray));
            }
        }
        if (idArray != null) {
            object = idArray;
            n2 = ((Basic[])object).length;
            for (n = 0; n < n2; ++n) {
                jPAEntityAttributeCheckArray = object[n];
                arrayList2.add(new AttributeWrapper(jPAEntityAttributeCheckArray));
            }
        }
        if (versionArray != null) {
            object = versionArray;
            n2 = ((Basic[])object).length;
            for (n = 0; n < n2; ++n) {
                jPAEntityAttributeCheckArray = object[n];
                arrayList2.add(new AttributeWrapper(jPAEntityAttributeCheckArray));
            }
        }
        if (((JPAProblemContext)(object = (JPAProblemContext)problemContext)).getAccessType() == AccessType.INCONSISTENT) {
            JPAProblemFinder.LOG.fine("Skipping attribute checks due to inconsistent access type");
        } else {
            for (AttributeWrapper attributeWrapper : arrayList2) {
                ModelUtils.resolveJavaElementFromModel((JPAProblemContext)object, attributeWrapper);
                if (attributeWrapper.getJavaElement() == null) {
                    JPAProblemFinder.LOG.severe("Failed to resolve java model element for JPA merged model element " + typeElement.getSimpleName() + "." + attributeWrapper.getName());
                    continue;
                }
                for (JPAEntityAttributeCheck jPAEntityAttributeCheck : attribChecks) {
                    ErrorDescription[] errorDescriptionArray = jPAEntityAttributeCheck.check((JPAProblemContext)object, attributeWrapper);
                    if (errorDescriptionArray == null) continue;
                    for (ErrorDescription errorDescription : errorDescriptionArray) {
                        arrayList.add(errorDescription);
                    }
                }
            }
        }
        return arrayList.toArray(new ErrorDescription[arrayList.size()]);
    }
}

