/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import org.codeviation.pojson.PojsonLoad;
import org.codeviation.pojson.PojsonSave;
import org.netbeans.modules.kenai.ProjectData;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.util.Utils;

class Persistence {
    private static final Persistence instance = new Persistence();

    static Persistence getInstance() {
        return instance;
    }

    private Persistence() {
    }

    public synchronized boolean storeProjects(Collection<KenaiProject> projects) {
        File master = this.getMasterStorage();
        int idx = 0;
        for (KenaiProject project : projects) {
            String projectFileName = this.computeProjectFileName(project.getName()) + "-" + idx + ".kp";
            File file = new File(master, projectFileName);
            try {
                this.storeProject(file, project);
            }
            catch (IOException iOException) {
                Utils.logWarn(this, iOException);
                file.delete();
            }
        }
        return true;
    }

    public synchronized Collection<KenaiProject> loadProjects() {
        ArrayList<KenaiProject> projects = new ArrayList<KenaiProject>();
        File master = this.getMasterStorage();
        File[] projectFiles = master.listFiles();
        if (projectFiles != null) {
            PojsonLoad load = new PojsonLoad();
            for (File file : projectFiles) {
                try {
                    FileInputStream fis = new FileInputStream(file);
                    ProjectData data = load.load(fis, ProjectData.class);
                    fis.close();
                    projects.add(KenaiProject.get(null, data));
                }
                catch (IOException iOException) {
                    Utils.logWarn(this, iOException);
                    file.delete();
                }
            }
        }
        return projects;
    }

    private void storeProject(File file, KenaiProject project) throws IOException {
        ProjectData data = project.getData();
        PojsonSave<ProjectData> save = new PojsonSave<ProjectData>();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        save.save((Writer)writer, data);
        writer.close();
    }

    private String computeProjectFileName(String name) {
        StringBuilder sb = new StringBuilder();
        for (char c : name.toCharArray()) {
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                sb.append(c);
                continue;
            }
            sb.append('-');
        }
        return sb.toString();
    }

    private File getMasterStorage() {
        File masterStorage;
        String homeDir = System.getProperty("user.home");
        if (homeDir == null) {
            homeDir = System.getProperty("netbeans.user");
            masterStorage = new File(homeDir);
        } else {
            masterStorage = new File(new File(homeDir), "NetBeansKenai");
        }
        File store = new File(new File(masterStorage, "config"), "Kenai");
        store.mkdirs();
        return store;
    }
}

