/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.usages;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.IndexDocument;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsfret.source.usages.ClassIndexImpl;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.netbeans.modules.gsfret.source.usages.IndexBatchEntry;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public abstract class Index
extends org.netbeans.modules.gsf.api.Index {
    protected Language language;
    private static final int VERSION = 1;
    private static final int SUBVERSION = 119;
    private static final String NB_USER_DIR = "netbeans.user";
    private static final String SEGMENTS_FILE = "segments";
    private static final String SLICE_PREFIX = "s";
    private static final String INDEX_DIR = "var" + File.separatorChar + "cache" + File.separatorChar + "gsf-index" + File.separatorChar + 1 + '.' + 119;
    protected static final String PREINDEXED = "netbeans-index-1.119-";
    private static final String PREINDEXED_MARKER = "static";
    private static final boolean COMPUTE_INDEX = Boolean.getBoolean("ruby.computeindex");
    private static Map<Language, LanguageContext> contexts = new HashMap<Language, LanguageContext>();
    private static List<FileObject> preindexRoots;

    protected Index(Language language) {
        this.language = language;
    }

    public abstract Map<String, String> getTimeStamps() throws IOException;

    public abstract void store(String var1, List<IndexDocument> var2) throws IOException;

    public abstract void batchStore(List<IndexBatchEntry> var1, boolean var2) throws IOException;

    public abstract boolean isValid(boolean var1) throws IOException;

    public abstract boolean isUpToDate(String var1, long var2) throws IOException;

    public abstract void clear() throws IOException;

    public abstract void close() throws IOException;

    static synchronized LanguageContext getContext(Language language) {
        LanguageContext context = contexts.get(language);
        if (context == null) {
            context = new LanguageContext(language);
            contexts.put(language, context);
        }
        return context;
    }

    public static URL getSourceRootForClassFolder(Language language, URL classFolder) {
        if ("file".equals(classFolder.getProtocol())) {
            try {
                File file = FileUtil.normalizeFile((File)new File(classFolder.toURI()));
                File segFolder = file.getParentFile();
                if (segFolder == null) {
                    return null;
                }
                LanguageContext context = Index.getContext(language);
                File cFolder = segFolder.getParentFile();
                if (cFolder == null || !((Object)cFolder).equals(context.cacheFolder)) {
                    return null;
                }
                String source = context.segments.getProperty(segFolder.getName());
                if (source != null) {
                    try {
                        return new URL(source);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
            }
            catch (URISyntaxException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return null;
    }

    public static void addPreindexRoot(FileObject root) {
        Index.getPreindexRoots();
        if (!preindexRoots.contains(root)) {
            preindexRoots.add(root);
        }
    }

    private static List<FileObject> getPreindexRoots() {
        if (preindexRoots == null) {
            preindexRoots = new ArrayList<FileObject>();
            for (FileObject fo : LanguageRegistry.getInstance().getLibraryFos()) {
                preindexRoots.add(fo);
            }
        }
        return preindexRoots;
    }

    public static synchronized File getDataFolder(Language language, URL root) throws IOException {
        File result;
        LanguageContext context = Index.getContext(language);
        context.loadSegments();
        String rootName = root.toExternalForm();
        String slice = (String)context.invertedSegments.get(rootName);
        FileObject extract = null;
        if (slice == null) {
            slice = SLICE_PREFIX + ++context.index;
            while (context.segments.getProperty(slice) != null) {
                slice = SLICE_PREFIX + ++context.index;
            }
            context.segments.put(slice, rootName);
            context.invertedSegments.put(rootName, slice);
            FileObject rootFo = URLMapper.findFileObject((URL)root);
            if (rootFo != null) {
                Indexer indexer = language.getIndexer();
                String indexedFileName = PREINDEXED + indexer.getIndexerName() + "-" + indexer.getIndexVersion();
                extract = rootFo.getFileObject(indexedFileName, "zip");
                if (extract == null && !COMPUTE_INDEX) {
                    for (FileObject fo : Index.getPreindexRoots()) {
                        String relative;
                        if (fo == null || !FileUtil.isParentOf((FileObject)fo, (FileObject)rootFo) || (relative = FileUtil.getRelativePath((FileObject)fo, (FileObject)rootFo)) == null || relative.length() <= 0) continue;
                        FileObject db = indexer.getPreindexedDb();
                        if (db == null) break;
                        extract = db.getFileObject(relative + "/" + indexedFileName + ".zip");
                        break;
                    }
                }
            }
            context.storeSegments();
        }
        if (!(result = FileUtil.normalizeFile((File)new File(context.cacheFolder, slice))).exists()) {
            result.mkdir();
            if (extract != null) {
                File extractFile = FileUtil.toFile(extract);
                FileObject dest = FileUtil.toFileObject((File)result);
                if (dest != null) {
                    Index.extractZip(dest, new BufferedInputStream(new FileInputStream(extractFile)));
                }
            }
        }
        return result;
    }

    static boolean isPreindexed(File dataDir) {
        return new File(dataDir, PREINDEXED_MARKER).exists();
    }

    private static void extractZip(final FileObject fo, final InputStream is) throws IOException {
        FileSystem fs = fo.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                Index.extractZipImpl(fo, is);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractZipImpl(FileObject fo, InputStream is) throws IOException {
        ZipEntry je;
        ZipInputStream jis = new ZipInputStream(is);
        while ((je = jis.getNextEntry()) != null) {
            String name = je.getName();
            if (name.toLowerCase().startsWith("meta-inf/")) continue;
            if (je.isDirectory()) {
                FileUtil.createFolder((FileObject)fo, (String)name);
                continue;
            }
            FileObject fd = FileUtil.createData((FileObject)fo, (String)name);
            FileLock lock = fd.lock();
            try {
                OutputStream os = fd.getOutputStream(lock);
                try {
                    FileUtil.copy((InputStream)jis, (OutputStream)os);
                }
                finally {
                    os.close();
                }
            }
            finally {
                lock.releaseLock();
            }
        }
    }

    static void preindex(Language language, URL root) {
        try {
            File[] files;
            Indexer indexer = language.getIndexer();
            if (!indexer.acceptQueryPath(root.toExternalForm())) {
                return;
            }
            FileObject rootFo = URLMapper.findFileObject((URL)root);
            File dataFile = Index.getDataFolder(language, root);
            String indexedFileName = PREINDEXED + indexer.getIndexerName() + "-" + indexer.getIndexVersion();
            File output = new File(FileUtil.toFile((FileObject)rootFo), indexedFileName + ".zip");
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(output));
            ZipOutputStream jis = new ZipOutputStream(os);
            ZipEntry je = new ZipEntry(PREINDEXED_MARKER);
            jis.putNextEntry(je);
            jis.closeEntry();
            File gsf = new File(dataFile, "gsf");
            assert (gsf.exists());
            ClassIndexImpl classIndexImpl = ClassIndexManager.get(language).getUsagesQuery(root);
            classIndexImpl.close();
            if (gsf.list().length == 0) {
                classIndexImpl.storeEmpty();
                classIndexImpl.close();
            }
            for (File f : files = gsf.listFiles()) {
                ZipEntry ze = new ZipEntry("gsf/" + f.getName());
                jis.putNextEntry(ze);
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
                FileUtil.copy((InputStream)is, (OutputStream)jis);
                jis.closeEntry();
            }
            jis.finish();
            jis.close();
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    static String getNbUserDir() {
        String nbUserProp = System.getProperty(NB_USER_DIR);
        return nbUserProp;
    }

    private static class LanguageContext {
        private Properties segments;
        private Map<String, String> invertedSegments;
        private File cacheFolder;
        private File segmentsFile;
        private int index = 0;
        private Language language;

        private LanguageContext(Language language) {
            this.language = language;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadSegments() throws IOException {
            if (this.segments == null) {
                File cacheFolder = this.getCacheFolder();
                assert (cacheFolder != null);
                this.segments = new Properties();
                this.invertedSegments = new HashMap<String, String>();
                this.segmentsFile = FileUtil.normalizeFile((File)new File(cacheFolder, Index.SEGMENTS_FILE));
                if (this.segmentsFile.exists()) {
                    FileInputStream in = new FileInputStream(this.segmentsFile);
                    try {
                        this.segments.load(in);
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
                for (Map.Entry<Object, Object> entry : this.segments.entrySet()) {
                    String segment = (String)entry.getKey();
                    String root = (String)entry.getValue();
                    this.invertedSegments.put(root, segment);
                    try {
                        this.index = Math.max(this.index, Integer.parseInt(segment.substring(Index.SLICE_PREFIX.length())));
                    }
                    catch (NumberFormatException nfe) {
                        ErrorManager.getDefault().notify((Throwable)nfe);
                    }
                }
                assert (this.segmentsFile != null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void storeSegments() throws IOException {
            assert (this.segmentsFile != null);
            FileOutputStream out = new FileOutputStream(this.segmentsFile);
            try {
                this.segments.store(out, null);
            }
            finally {
                ((OutputStream)out).close();
            }
        }

        private synchronized File getCacheFolder() {
            if (this.cacheFolder == null) {
                String nbUserDirProp = Index.getNbUserDir();
                assert (nbUserDirProp != null);
                File nbUserDir = new File(nbUserDirProp);
                this.cacheFolder = FileUtil.normalizeFile((File)new File(nbUserDir, INDEX_DIR));
                Indexer indexer = this.language.getIndexer();
                assert (indexer != null) : this.language;
                this.cacheFolder = new File(this.cacheFolder, indexer.getIndexerName() + File.separator + indexer.getIndexVersion());
                if (!this.cacheFolder.exists()) {
                    boolean created = this.cacheFolder.mkdirs();
                    assert (created) : "Cannot create cache folder";
                } else assert (this.cacheFolder.isDirectory() && this.cacheFolder.canRead() && this.cacheFolder.canWrite());
            }
            return this.cacheFolder;
        }

        synchronized void setCacheFolder(File folder) {
            assert (folder != null && folder.exists() && folder.canRead() && folder.canWrite());
            this.cacheFolder = folder;
        }
    }

    public static enum BooleanOperator {
        AND,
        OR;

    }
}

