/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.project.J2MEActionProvider;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;

public class J2MEProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private final J2MEProject project;
    private final AntProjectHelper helper;
    private final ReferenceHelper refHelper;

    public J2MEProjectOperations(J2MEProject project, AntProjectHelper helper, ReferenceHelper refHelper) {
        this.project = project;
        this.helper = helper;
        this.refHelper = refHelper;
    }

    private static void addFile(FileObject projectDirectory, String fileName, List<FileObject> result) {
        FileObject file = projectDirectory.getFileObject(fileName);
        if (file != null) {
            result.add(file);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        J2MEProjectOperations.addFile(projectDirectory, "nbproject", files);
        J2MEProjectOperations.addFile(projectDirectory, "build.xml", files);
        J2MEProjectOperations.addFile(projectDirectory, "manifest.mf", files);
        return files;
    }

    public List<FileObject> getDataFiles() {
        FileObject src;
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        String srcRoot = this.helper.getStandardPropertyEvaluator().getProperty("src.dir");
        if (srcRoot != null && (src = this.helper.resolveFileObject(srcRoot)) != null) {
            files.add(src);
        }
        return files;
    }

    public void notifyDeleting() throws IOException {
        J2MEActionProvider ap = (J2MEActionProvider)this.project.getLookup().lookup(J2MEActionProvider.class);
        assert (ap != null);
        Properties p = new Properties();
        String[] targetNames = ap.getTargetNames("clean-all");
        FileObject buildXML = this.project.getProjectDirectory().getFileObject("build.xml");
        assert (targetNames != null);
        assert (targetNames.length > 0);
        ActionUtils.runTarget((FileObject)buildXML, (String[])targetNames, (Properties)p).waitFinished();
    }

    public void notifyDeleted() {
        this.helper.notifyDeleted();
    }

    public void notifyCopying() {
    }

    public void notifyCopied(Project original, File originalPath, String nueName) {
        if (original == null) {
            return;
        }
        this.project.setName(nueName);
        this.refHelper.fixReferences(originalPath);
    }

    public void notifyMoving() throws IOException {
        this.notifyDeleting();
    }

    public void notifyMoved(Project original, File originalPath, String nueName) {
        if (original == null) {
            this.helper.notifyDeleted();
            return;
        }
        this.project.setName(nueName);
        this.refHelper.fixReferences(originalPath);
    }
}

