/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.security;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.project.security.KeyStoreRepository;
import org.netbeans.modules.mobility.project.security.MEKeyTool;
import org.netbeans.modules.mobility.project.ui.customizer.ErrorPanel;
import org.netbeans.modules.mobility.project.ui.security.KeyAliasCellRenderer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ExportPanel
extends JPanel
implements ItemListener,
ListSelectionListener {
    private static final Dimension PREFERRED_SIZE = new Dimension(500, 500);
    private DialogDescriptor dd;
    private final KeyStoreRepository.KeyStoreBean bean;
    private final KeyStoreRepository.KeyStoreBean.KeyAliasBean alias;
    private final JButton bExport;
    String keyString = NbBundle.getMessage(ExportPanel.class, (String)"LBL_Key");
    private JButton bDelete;
    private JComboBox cDomain;
    private JComboBox cTarget;
    private JScrollPane jScrollPane1;
    private JLabel lAlias;
    private JLabel lDetails;
    private JLabel lDomain;
    private JLabel lKeys;
    private JLabel lKeystore;
    private JLabel lPlatform;
    private JList list;
    private JPanel pDetails;
    private ErrorPanel pError;
    private JTextField tAlias;
    private JTextField tKeystore;

    public ExportPanel(KeyStoreRepository.KeyStoreBean bean, KeyStoreRepository.KeyStoreBean.KeyAliasBean alias, Object preselectedTarget, String preselectedDomain) {
        this.bean = bean;
        this.alias = alias;
        this.initComponents();
        this.initAccessibility();
        this.bDelete.setEnabled(false);
        this.bExport = new JButton(NbBundle.getMessage(ExportPanel.class, (String)"LBL_Export"));
        this.bExport.setDefaultCapable(true);
        this.bExport.setEnabled(false);
        this.bExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportPanel.this.export();
                ExportPanel.this.reloadList(ExportPanel.this.cTarget.getSelectedItem());
            }
        });
        this.tKeystore.setText(bean.getKeyStorePath());
        this.tAlias.setText(alias.getAlias());
        this.lDetails.setText(KeyAliasCellRenderer.getHtmlFormattedText(alias));
        this.cTarget.addItemListener(this);
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof MEKeyTool.KeyDetail) {
                    MEKeyTool.KeyDetail key = (MEKeyTool.KeyDetail)value;
                    Color color = isSelected ? list.getSelectionForeground() : list.getForeground();
                    StringBuffer sb = new StringBuffer("<html><font color=\"#" + Integer.toHexString(color.getRGB() & 0xFFFFFF) + "\"><b>" + ExportPanel.this.keyString + ": " + key.getOrder() + "</b>");
                    String[] lines = key.getInfo();
                    if (lines != null) {
                        for (int i = 0; i < lines.length; ++i) {
                            sb.append("<br>").append(lines[i]);
                        }
                    }
                    value = sb.toString();
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this.list.addListSelectionListener(this);
        this.cTarget.removeAllItems();
        this.cTarget.addItem(NbBundle.getMessage(ExportPanel.class, (String)"MSG_Loading"));
        final Collection<JavaPlatform> javaMEPlatforms = ExportPanel.getJavaMEPlatformsWithoutBdj();
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                boolean removedLoading = false;
                block0: for (JavaPlatform platform : javaMEPlatforms) {
                    J2MEPlatform.Device[] dev;
                    if (platform == null || !(platform instanceof J2MEPlatform)) continue;
                    for (J2MEPlatform.Device device : dev = ((J2MEPlatform)platform).getDevices()) {
                        if (null != MEKeyTool.keystoreForDevice(device)) {
                            if (!removedLoading) {
                                ExportPanel.this.cTarget.removeAllItems();
                                removedLoading = true;
                            }
                        } else {
                            ExportPanel.this.cTarget.removeAllItems();
                            ExportPanel.this.cTarget.addItem(platform);
                            continue block0;
                        }
                        ExportPanel.this.cTarget.addItem(device);
                    }
                }
            }
        });
    }

    private boolean equivalent(String owner, String subjectName) {
        String[] ownerSplit = owner.split("[,;]");
        HashSet<String> ownerSet = new HashSet<String>();
        for (String string : ownerSplit) {
            ownerSet.add(string.trim());
        }
        String[] subjectSplit = subjectName.split("[,;]");
        HashSet<String> subjectSet = new HashSet<String>();
        for (String string : subjectSplit) {
            subjectSet.add(string.trim());
        }
        return ((Object)ownerSet).equals(subjectSet);
    }

    private void initComponents() {
        this.lKeystore = new JLabel();
        this.tKeystore = new JTextField();
        this.lAlias = new JLabel();
        this.tAlias = new JTextField();
        this.pDetails = new JPanel();
        this.lDetails = new JLabel();
        this.lPlatform = new JLabel();
        this.cTarget = new JComboBox();
        this.lDomain = new JLabel();
        this.cDomain = new JComboBox();
        this.lKeys = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.bDelete = new JButton();
        this.pError = new ErrorPanel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setMinimumSize(new Dimension(500, 250));
        this.setPreferredSize(new Dimension(500, 250));
        this.setLayout(new GridBagLayout());
        this.lKeystore.setLabelFor(this.tKeystore);
        Mnemonics.setLocalizedText((JLabel)this.lKeystore, (String)NbBundle.getMessage(ExportPanel.class, (String)"LBL_Export_File"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.lKeystore, gridBagConstraints);
        this.tKeystore.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.tKeystore, gridBagConstraints);
        this.tKeystore.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportPanel.class, (String)"ACSD_Export_Keystore"));
        this.lAlias.setLabelFor(this.tAlias);
        Mnemonics.setLocalizedText((JLabel)this.lAlias, (String)NbBundle.getMessage(ExportPanel.class, (String)"LBL_Export_Alias"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.lAlias, gridBagConstraints);
        this.tAlias.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.tAlias, gridBagConstraints);
        this.tAlias.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportPanel.class, (String)"ACSD_Export_Alias"));
        this.pDetails.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ExportPanel.class, (String)"LBL_Export_Details")));
        this.pDetails.setEnabled(false);
        this.pDetails.setPreferredSize(new Dimension(300, 100));
        this.pDetails.setLayout(new GridBagLayout());
        this.lDetails.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pDetails.add((Component)this.lDetails, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.pDetails, gridBagConstraints);
        this.lPlatform.setLabelFor(this.cTarget);
        Mnemonics.setLocalizedText((JLabel)this.lPlatform, (String)NbBundle.getMessage(ExportPanel.class, (String)"LBL_Export_Platform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.lPlatform, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.cTarget, gridBagConstraints);
        this.cTarget.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportPanel.class, (String)"ACSD_Export_Platform"));
        this.lDomain.setLabelFor(this.cDomain);
        Mnemonics.setLocalizedText((JLabel)this.lDomain, (String)NbBundle.getMessage(ExportPanel.class, (String)"LBL_Export_Domain"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.lDomain, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.cDomain, gridBagConstraints);
        this.cDomain.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportPanel.class, (String)"ACSD_Export_Domain"));
        this.lKeys.setLabelFor(this.list);
        Mnemonics.setLocalizedText((JLabel)this.lKeys, (String)NbBundle.getMessage(ExportPanel.class, (String)"LBL_Export_Keys"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.lKeys, gridBagConstraints);
        this.list.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.list);
        this.list.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportPanel.class, (String)"ACSD_Export_Keys"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 3.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bDelete, (String)NbBundle.getMessage(ExportPanel.class, (String)"LBL_Export_DeleteKey"));
        this.bDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportPanel.this.bDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.bDelete, gridBagConstraints);
        this.bDelete.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportPanel.class, (String)"ACSD_Export_DeleteKey"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pError, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExportPanel.class, (String)"ACSN_Export"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportPanel.class, (String)"ACSD_Export"));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.bDelete.setEnabled(this.list.getSelectedValue() instanceof MEKeyTool.KeyDetail);
    }

    @Override
    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    protected void setDialogDescriptor(DialogDescriptor desc) {
        this.dd = desc;
        this.dd.setHelpCtx(new HelpCtx(ExportPanel.class));
        this.checkErrors();
    }

    public String getErrorMessage() {
        ListModel model = this.list.getModel();
        for (int a = 0; a < model.getSize(); ++a) {
            MEKeyTool.KeyDetail key;
            String owner;
            Object o = model.getElementAt(a);
            if (!(o instanceof MEKeyTool.KeyDetail) || (owner = (key = (MEKeyTool.KeyDetail)o).getOwner()) == null || !this.equivalent(owner, this.alias.getSubjectName())) continue;
            return NbBundle.getMessage(ExportPanel.class, (String)"ERR_KeyIsAlreadyInPlatform", (Object)owner, (Object)Integer.toString(key.getOrder()));
        }
        return null;
    }

    public void checkErrors() {
        String errorMessage = this.getErrorMessage();
        this.pError.setErrorMessage(errorMessage);
        boolean valid = errorMessage == null;
        this.bExport.setEnabled(valid && this.cTarget.getSelectedItem() != null && !(this.cTarget.getSelectedItem() instanceof String));
        if (this.dd != null && valid != this.dd.isValid()) {
            this.dd.setValid(valid);
        }
    }

    private void bDeleteActionPerformed(ActionEvent evt) {
        Object target = this.cTarget.getSelectedItem();
        Object value = this.list.getSelectedValue();
        String keytool = MEKeyTool.getMEKeyToolPath(target);
        if (value instanceof MEKeyTool.KeyDetail && keytool != null) {
            String name;
            MEKeyTool.KeyDetail key = (MEKeyTool.KeyDetail)value;
            String string = name = target instanceof J2MEPlatform.Device ? ((J2MEPlatform.Device)target).getName() : ((J2MEPlatform)target).getName();
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExportPanel.class, (String)"MSG_DeleteKeyConfirmation", (Object)Integer.toString(key.getOrder()), (Object)name), NbBundle.getMessage(ExportPanel.class, (String)"TITLE_ConfirmKeyDeletion"), 0)) == NotifyDescriptor.YES_OPTION) {
                try {
                    if (target instanceof J2MEPlatform.Device) {
                        MEKeyTool.execute(new String[]{keytool, "-delete", "-MEkeystore", MEKeyTool.keystoreForDevice((J2MEPlatform.Device)target).toString(), "-number", Integer.toString(key.getOrder())});
                    } else {
                        MEKeyTool.execute(new String[]{keytool, "-delete", "-number", Integer.toString(key.getOrder())});
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ExportPanel.class, (String)"ERR_WhileDeletingKey"), 0));
                }
                this.reloadList(target);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object target = this.cTarget.getSelectedItem();
        if (target instanceof String) {
            this.reloadList(target);
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (target != null) {
            if (target instanceof J2MEPlatform.Device) {
                String[] domains = ((J2MEPlatform.Device)target).getSecurityDomains();
                if (domains != null) {
                    for (int j = 0; j < domains.length; ++j) {
                        String domain = domains[j];
                        if (list.contains(domain)) continue;
                        list.add(domain);
                    }
                }
            } else {
                J2MEPlatform.Device[] devices = ((J2MEPlatform)target).getDevices();
                if (devices != null) {
                    for (int i = 0; i < devices.length; ++i) {
                        J2MEPlatform.Device device = devices[i];
                        String[] domains = device.getSecurityDomains();
                        if (domains == null) continue;
                        for (int j = 0; j < domains.length; ++j) {
                            String domain = domains[j];
                            if (list.contains(domain)) continue;
                            list.add(domain);
                        }
                    }
                }
            }
        }
        this.cDomain.removeAllItems();
        for (int i = 0; i < list.size(); ++i) {
            this.cDomain.addItem(list.get(i));
        }
        this.reloadList(target);
    }

    protected void reloadList(Object target) {
        this.bDelete.setEnabled(false);
        if (target != null && !(target instanceof String)) {
            this.setListLoading();
            this.setList(MEKeyTool.listKeys(target));
        } else {
            this.setListNotLoaded();
        }
        this.checkErrors();
    }

    private void setListNotLoaded() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        model.addElement(NbBundle.getMessage(ExportPanel.class, (String)"LBL_NotLoaded"));
        this.list.setModel(model);
    }

    private void setListLoading() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        model.addElement(NbBundle.getMessage(ExportPanel.class, (String)"LBL_Loading"));
        this.list.setModel(model);
    }

    private void setList(MEKeyTool.KeyDetail[] keys) {
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        if (keys != null) {
            if (keys.length > 0) {
                for (int i = 0; i < keys.length; ++i) {
                    MEKeyTool.KeyDetail key = keys[i];
                    model.addElement(key);
                }
            } else {
                model.addElement(NbBundle.getMessage(ExportPanel.class, (String)"LBL_NoKey"));
            }
        } else {
            model.addElement(NbBundle.getMessage(ExportPanel.class, (String)"LBL_ErrorLoadingKeys"));
        }
        this.list.setModel(model);
    }

    public static void showExportKeyIntoPlatform(KeyStoreRepository.KeyStoreBean bean, KeyStoreRepository.KeyStoreBean.KeyAliasBean alias, Object preselectedTarget, String preselectedDomain) {
        if (!(bean != null && alias != null && bean.isOpened() && alias.isValid() && alias.isOpened())) {
            return;
        }
        ExportPanel export = new ExportPanel(bean, alias, preselectedTarget, preselectedDomain);
        DialogDescriptor dd = new DialogDescriptor((Object)export, NbBundle.getMessage(ExportPanel.class, (String)"TITLE_ExportKey"), true, null);
        dd.setOptions(new Object[]{export.bExport, NotifyDescriptor.CLOSED_OPTION});
        dd.setClosingOptions(new Object[]{NotifyDescriptor.CLOSED_OPTION});
        export.setDialogDescriptor(dd);
        export.checkErrors();
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void export() {
        Object target = this.cTarget.getSelectedItem();
        String domain = (String)this.cDomain.getSelectedItem();
        String keytool = MEKeyTool.getMEKeyToolPath(target);
        if (target != null && domain != null && keytool != null) {
            File keyStoreFile = new File(System.getProperty("user.home", ""), ".keystore");
            if (keyStoreFile.exists()) {
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExportPanel.class, (String)"MSG_PromptDeleteFile", (Object)this.bean.getKeyStorePath(), (Object)keyStoreFile.getAbsolutePath()), NbBundle.getMessage(ExportPanel.class, (String)"MSG_PromptDeleteFileTitle"), 0)) != NotifyDescriptor.YES_OPTION) {
                    return;
                }
                if (!keyStoreFile.delete()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ExportPanel.class, (String)"ERR_CannotDeleteFile", (Object)keyStoreFile.getAbsolutePath()), 0));
                    return;
                }
            }
            boolean canDeleteTempKeystore = false;
            if (!KeyStoreRepository.KeyStoreBean.equalFiles(this.bean.getKeyStoreFile(), keyStoreFile)) {
                canDeleteTempKeystore = true;
                FileInputStream fis = null;
                FileOutputStream fos = null;
                try {
                    fis = new FileInputStream(this.bean.getKeyStoreFile());
                    fos = new FileOutputStream(keyStoreFile);
                    FileUtil.copy((InputStream)fis, (OutputStream)fos);
                }
                catch (IOException e) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ExportPanel.class, (String)"ERR_IOErrorWhileCopying", (Object)this.bean.getKeyStorePath(), (Object)keyStoreFile.getAbsolutePath()), 0));
                    e.printStackTrace();
                    return;
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {}
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            try {
                if (target instanceof J2MEPlatform.Device) {
                    MEKeyTool.execute(new String[]{keytool, "-import", "-MEkeystore", MEKeyTool.keystoreForDevice((J2MEPlatform.Device)target), "-keystore", this.bean.getKeyStorePath(), "-storepass", this.bean.getPassword(), "-alias", this.alias.getAlias(), "-domain", domain});
                } else {
                    MEKeyTool.execute(new String[]{keytool, "-import", "-storepass", this.bean.getPassword(), "-alias", this.alias.getAlias(), "-domain", domain});
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ExportPanel.class, (String)"MSG_ErrorExportingKey"), 0));
            }
            if (canDeleteTempKeystore) {
                keyStoreFile.delete();
            }
        }
    }

    public static Collection<JavaPlatform> getJavaMEPlatformsWithoutBdj() {
        ArrayList<JavaPlatform> res = new ArrayList<JavaPlatform>();
        JavaPlatformManager platformManager = JavaPlatformManager.getDefault();
        JavaPlatform[] platforms = null;
        try {
            platforms = platformManager.getInstalledPlatforms();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
        for (JavaPlatform javaPlatform : platforms) {
            if (!(javaPlatform instanceof J2MEPlatform) && (!(javaPlatform instanceof CDCPlatform) || ((CDCPlatform)javaPlatform).getType().equals("bdj"))) continue;
            res.add(javaPlatform);
        }
        return res;
    }
}

