/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.J2MEProjectGenerator;
import org.netbeans.modules.mobility.project.ui.wizard.MIDPTargetChooserPanel;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class FileWizardIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = -1987345825459L;
    protected static final String JAVA_EXTENSION = "java";
    protected static FileWizardIterator instance;
    protected transient int panelIndex = 0;
    protected transient WizardDescriptor.Panel[] panels;
    protected transient TemplateWizard wizardInstance;

    public static synchronized FileWizardIterator singleton() {
        if (instance == null) {
            instance = new FileWizardIterator();
        }
        return instance;
    }

    public Set<DataObject> instantiate(final TemplateWizard wiz) throws IOException, IllegalArgumentException {
        this.wizardInstance = wiz;
        DataObject obj = this.instantiateTemplate(wiz.getTemplate(), wiz.getTargetFolder(), wiz.getTargetName());
        Object isMidletObject = Templates.getTemplate((WizardDescriptor)this.wizardInstance).getAttribute("isMIDletTemplate");
        boolean isMIDlet = false;
        if (isMidletObject instanceof Boolean) {
            isMIDlet = (Boolean)isMidletObject;
        }
        if (isMIDlet) {
            final Project p = Templates.getProject((WizardDescriptor)this.wizardInstance);
            final AntProjectHelper h = (AntProjectHelper)p.getLookup().lookup(AntProjectHelper.class);
            if (p instanceof J2MEProject && h != null) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            J2MEProjectGenerator.addMIDletProperty(p, h, (String)wiz.getProperty("MidletName"), (String)wiz.getProperty("MidletClassName"), (String)wiz.getProperty("MidletIcon"));
                            ProjectManager.getDefault().saveProject(p);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        return Collections.singleton(obj);
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.panelIndex];
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public void initialize(TemplateWizard wizard) {
        this.wizardInstance = wizard;
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new MIDPTargetChooserPanel()};
        }
        this.panelIndex = 0;
        this.updateStepsList();
    }

    public void uninitialize(TemplateWizard wiz) {
        this.wizardInstance = null;
        this.panels = null;
        this.panelIndex = -1;
    }

    private DataObject instantiateTemplate(DataObject tpl, DataFolder target, String name) throws IOException {
        String message;
        if (name == null) {
            name = this.getDefaultName(tpl, target);
        }
        if ((message = FileWizardIterator.checkValidPackageName(target)) == null) {
            message = FileWizardIterator.checkTargetName(target, name);
        }
        if (message != null) {
            throw (IllegalStateException)ErrorManager.getDefault().annotate((Throwable)new IllegalStateException(message), 256, null, message, null, null);
        }
        return tpl.createFromTemplate(target, name);
    }

    private static boolean isValidPackageName(String s) {
        if ("".equals(s)) {
            return true;
        }
        try {
            Utilities.isJavaIdentifier((String)s);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static String checkValidPackageName(DataFolder targetFolder) throws IllegalStateException {
        FileObject folder = targetFolder.getPrimaryFile();
        ClassPath cp = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
        String msg = null;
        if (cp != null) {
            String fullTarget = cp.getResourceName(folder, '.', false);
            if (FileWizardIterator.isValidPackageName(fullTarget)) {
                return null;
            }
            msg = MessageFormat.format(FileWizardIterator.getString("ERR_File_IllegalFolderName"), folder.getPath(), fullTarget);
        } else {
            msg = FileWizardIterator.getString("ERR_File_NotInSourcePath");
        }
        return msg;
    }

    public static String checkTargetName(DataFolder folder, String desiredName) {
        if (!Utilities.isJavaIdentifier((String)desiredName)) {
            String msg = MessageFormat.format(FileWizardIterator.getString("ERR_File_IllegalTargetName"), desiredName);
            return msg;
        }
        FileObject f = folder.getPrimaryFile();
        if (f.getFileObject(desiredName, JAVA_EXTENSION) != null) {
            String msg = MessageFormat.format(FileWizardIterator.getString("ERR_File_TargetExists"), desiredName);
            return msg;
        }
        return null;
    }

    private String getDefaultName(DataObject template, DataFolder targetFolder) {
        String desiredName = FileUtil.findFreeFileName((FileObject)targetFolder.getPrimaryFile(), (String)template.getName(), (String)JAVA_EXTENSION);
        return desiredName;
    }

    static String getString(String key) {
        return NbBundle.getMessage(FileWizardIterator.class, (String)key);
    }

    static char getMnemonic(String key) {
        return FileWizardIterator.getString(key).charAt(0);
    }

    private void updateStepsList() {
        JComponent component = (JComponent)this.current().getComponent();
        component.putClientProperty("WizardPanel_contentData", new String[]{NbBundle.getMessage(MIDPTargetChooserPanel.class, (String)"TITLE_File")});
        component.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.panelIndex));
    }
}

