/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.encapsulation;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.jackpot.spi.support.OneCheckboxCustomizerProvider;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class FieldEncapsulation {
    private static final Logger LOG = Logger.getLogger(FieldEncapsulation.class.getName());
    private static final String ACTION_PATH = "Actions/Refactoring/org-netbeans-modules-refactoring-java-api-ui-EncapsulateFieldAction.instance";
    private static final String KW_THIS = "this";
    static final String ALLOW_ENUMS_KEY = "allow.enums";
    static final boolean ALLOW_ENUMS_DEFAULT = false;

    public static ErrorDescription protectedField(HintContext hintContext) {
        return FieldEncapsulation.create(hintContext, Modifier.PROTECTED, NbBundle.getMessage(FieldEncapsulation.class, (String)"TXT_ProtectedField"), "ProtectedField");
    }

    public static ErrorDescription publicField(HintContext hintContext) {
        return FieldEncapsulation.create(hintContext, Modifier.PUBLIC, NbBundle.getMessage(FieldEncapsulation.class, (String)"TXT_PublicField"), "PublicField");
    }

    public static ErrorDescription packageField(HintContext hintContext) {
        return FieldEncapsulation.create(hintContext, null, NbBundle.getMessage(FieldEncapsulation.class, (String)"TXT_PackageField"), "PackageVisibleField");
    }

    public static ErrorDescription privateField(HintContext hintContext) {
        assert (hintContext != null);
        TreePath treePath = hintContext.getPath();
        Element element = hintContext.getInfo().getTrees().getElement(treePath);
        if (element == null || element.getKind() != ElementKind.FIELD || !((VariableElement)element).getModifiers().contains((Object)Modifier.PRIVATE) || ((VariableElement)element).getModifiers().contains((Object)Modifier.STATIC)) {
            return null;
        }
        ExpressionTree expressionTree = ((MemberSelectTree)treePath.getLeaf()).getExpression();
        if (expressionTree.getKind() == Tree.Kind.IDENTIFIER && KW_THIS.contentEquals(((IdentifierTree)expressionTree).getName()) || expressionTree.getKind() == Tree.Kind.MEMBER_SELECT && KW_THIS.contentEquals(((MemberSelectTree)expressionTree).getIdentifier())) {
            return null;
        }
        TypeElement typeElement = FieldEncapsulation.getEnclosingClass(treePath, hintContext.getInfo().getTrees());
        if (typeElement == null || SourceUtils.getOutermostEnclosingTypeElement((Element)element) != SourceUtils.getOutermostEnclosingTypeElement((Element)typeElement)) {
            return null;
        }
        SourceUtils.getOutermostEnclosingTypeElement((Element)element);
        return ErrorDescriptionFactory.forName(hintContext, treePath, NbBundle.getMessage(FieldEncapsulation.class, (String)"TXT_OtherPrivateField"), FixFactory.createSuppressWarningsFix(hintContext.getInfo(), treePath, "AccessingNonPublicFieldOfAnotherObject"));
    }

    private static TypeElement getEnclosingClass(TreePath treePath, Trees trees) {
        while (treePath != null && treePath.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            if (treePath.getLeaf().getKind() == Tree.Kind.CLASS) {
                return (TypeElement)trees.getElement(treePath);
            }
            treePath = treePath.getParentPath();
        }
        return null;
    }

    private static ErrorDescription create(HintContext hintContext, Modifier modifier, String string, String string2) {
        Collection<? extends TreePath> collection;
        assert (hintContext != null);
        assert (string != null);
        assert (string2 != null);
        TreePath treePath = hintContext.getPath();
        Tree tree = treePath.getParentPath().getLeaf();
        if (tree.getKind() != Tree.Kind.CLASS || hintContext.getInfo().getTreeUtilities().isInterface((ClassTree)tree)) {
            return null;
        }
        VariableTree variableTree = (VariableTree)treePath.getLeaf();
        ModifiersTree modifiersTree = variableTree.getModifiers();
        if (modifiersTree.getFlags().contains((Object)Modifier.FINAL) || !FieldEncapsulation.hasRequiredVisibility(modifiersTree.getFlags(), modifier)) {
            return null;
        }
        if (hintContext.getPreferences().getBoolean(ALLOW_ENUMS_KEY, false) && (collection = hintContext.getInfo().getTrees().getElement(new TreePath(treePath, variableTree.getType()))) != null && collection.getKind() == ElementKind.ENUM) {
            return null;
        }
        collection = Utilities.resolveFieldGroup(hintContext.getInfo(), treePath);
        if (collection.size() != 1 && collection.iterator().next().getLeaf() != treePath.getLeaf()) {
            return null;
        }
        return ErrorDescriptionFactory.forName(hintContext, treePath, string, new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)hintContext.getInfo())), FixFactory.createSuppressWarningsFix(hintContext.getInfo(), treePath, string2));
    }

    private static boolean hasRequiredVisibility(Set<Modifier> set, Modifier modifier) {
        return modifier != null ? set.contains((Object)modifier) : (set.isEmpty() ? true : !EnumSet.copyOf(set).removeAll(EnumSet.of(Modifier.PRIVATE, Modifier.PROTECTED, Modifier.PUBLIC)));
    }

    public static final class CustomizerImpl
    extends OneCheckboxCustomizerProvider {
        public CustomizerImpl() {
            super(NbBundle.getMessage(FieldEncapsulation.class, (String)"DN_IgnoreEnumForField"), NbBundle.getMessage(FieldEncapsulation.class, (String)"TP_IgnoreEnumForField"), FieldEncapsulation.ALLOW_ENUMS_KEY, false);
        }
    }

    private static class FixImpl
    implements Fix {
        private final TreePathHandle handle;

        public FixImpl(TreePathHandle treePathHandle) {
            this.handle = treePathHandle;
        }

        public String getText() {
            return NbBundle.getMessage(FieldEncapsulation.class, (String)"FIX_EncapsulateField");
        }

        public ChangeInfo implement() throws Exception {
            FileObject fileObject = this.handle.getFileObject();
            JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
            if (fileObject != null && fileObject == FixImpl.getFileObject(jTextComponent)) {
                final int[] nArray = new int[]{-1};
                JavaSource.forFileObject((FileObject)fileObject).runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.PARSED);
                        TreePath treePath = FixImpl.this.handle.resolve((CompilationInfo)compilationController);
                        if (treePath != null && treePath.getLeaf().getKind() == Tree.Kind.VARIABLE) {
                            nArray[0] = (int)compilationController.getTrees().getSourcePositions().getEndPosition(treePath.getCompilationUnit(), ((VariableTree)treePath.getLeaf()).getType()) + 1;
                        }
                    }
                }, true);
                this.invokeRefactoring(jTextComponent, nArray[0]);
            }
            return null;
        }

        public static FileObject getFileObject(JTextComponent jTextComponent) {
            if (jTextComponent == null) {
                return null;
            }
            Document document = jTextComponent.getDocument();
            if (document == null) {
                return null;
            }
            Object object = document.getProperty("stream");
            if (object instanceof FileObject) {
                return (FileObject)object;
            }
            if (object instanceof DataObject) {
                return ((DataObject)object).getPrimaryFile();
            }
            return null;
        }

        private void invokeRefactoring(final JTextComponent jTextComponent, final int n) {
            FileObject fileObject = FileUtil.getConfigRoot();
            FileObject fileObject2 = fileObject.getFileObject(FieldEncapsulation.ACTION_PATH);
            if (fileObject2 == null) {
                LOG.warning("Encapsulate Field action not found at: Actions/Refactoring/org-netbeans-modules-refactoring-java-api-ui-EncapsulateFieldAction.instance");
                return;
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject2);
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getLookup().lookup(InstanceCookie.class);
                final Object object = instanceCookie.instanceCreate();
                if (!(object instanceof Action)) {
                    throw new IOException();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (n != -1) {
                            jTextComponent.setCaretPosition(n);
                        }
                        ((Action)object).actionPerformed(new ActionEvent(jTextComponent, 0, null));
                    }
                });
            }
            catch (IOException iOException) {
                LOG.warning("Encapsulate Field action is broken: Actions/Refactoring/org-netbeans-modules-refactoring-java-api-ui-EncapsulateFieldAction.instance");
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.warning("Encapsulate Field action is broken: Actions/Refactoring/org-netbeans-modules-refactoring-java-api-ui-EncapsulateFieldAction.instance");
                return;
            }
        }
    }
}

