/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.helper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.exceptions.XMLException;
import org.netbeans.installer.utils.helper.FileEntry;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesList
implements Iterable<FileEntry> {
    private File listFile;
    private File tempFile;
    private List<FileEntry> entries = new ArrayList<FileEntry>(2500);
    private int size;
    public static final int CACHE_SIZE = 2500;
    public static final String ENCODING = "UTF-8";

    public FilesList() {
    }

    public FilesList(File xml) throws IOException, XMLException {
        this();
        this.loadXml(xml);
    }

    public void add(File file) throws IOException {
        this.add(new FileEntry(file));
    }

    public void add(FileEntry entry) throws IOException {
        String current;
        int index;
        String name = entry.getName();
        for (index = 0; index < this.entries.size() && (current = this.entries.get(index).getName()).length() >= name.length(); ++index) {
            if (!current.equals(name)) continue;
            return;
        }
        this.entries.add(index, entry);
        ++this.size;
        if (this.entries.size() == 2500) {
            this.save();
        }
    }

    public void add(List<File> list) throws IOException {
        for (File file : list) {
            this.add(file);
        }
    }

    public void add(FilesList list) throws IOException {
        for (FileEntry entry : list) {
            this.add(entry);
        }
    }

    public void clear() throws IOException {
        if (this.listFile != null) {
            FileUtils.deleteFiles(this.listFile, this.tempFile);
        }
        this.entries.clear();
        this.size = 0;
    }

    public int getSize() {
        return this.size;
    }

    public FilesList loadXml(File xml) throws XMLException {
        return this.loadXml(xml, null);
    }

    public FilesList loadXml(File xml, File root) throws XMLException {
        try {
            FileInputStream in = new FileInputStream(xml);
            this.loadXml(in, root);
            ((InputStream)in).close();
            return this;
        }
        catch (IOException e) {
            throw new XMLException("Cannot parse xml file", e);
        }
    }

    public FilesList loadXmlGz(File xml) throws XMLException {
        return this.loadXmlGz(xml, null);
    }

    public FilesList loadXmlGz(File xml, File root) throws XMLException {
        try {
            GZIPInputStream in = new GZIPInputStream(new FileInputStream(xml));
            this.loadXml(in, root);
            ((InputStream)in).close();
            return this;
        }
        catch (IOException e) {
            throw new XMLException("Cannot parse xml file", e);
        }
    }

    public void saveXml(File xml) throws XMLException {
        try {
            FileOutputStream out = new FileOutputStream(xml);
            this.saveXml(out);
            ((OutputStream)out).close();
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLException("Cannot save XML", e);
        }
        catch (IOException e) {
            throw new XMLException("Cannot save XML", e);
        }
    }

    public void saveXmlGz(File xml) throws XMLException {
        try {
            GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(xml));
            this.saveXml(out);
            ((OutputStream)out).close();
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLException("Cannot save XML", e);
        }
        catch (IOException e) {
            throw new XMLException("Cannot save XML", e);
        }
    }

    public List<File> toList() {
        ArrayList<File> files = new ArrayList<File>(this.size);
        for (FileEntry entry : this) {
            files.add(entry.getFile());
        }
        return files;
    }

    @Override
    public Iterator<FileEntry> iterator() {
        return new FilesListIterator();
    }

    private void save() throws IOException {
        if (this.entries.size() > 0) {
            if (this.listFile == null) {
                this.listFile = FileUtils.createTempFile();
                this.tempFile = FileUtils.createTempFile();
            }
            BufferedReader reader = this.listFile.length() > 0L ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.listFile)))) : new BufferedReader(new FileReader(this.listFile));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(this.tempFile))));
            int index = 0;
            FileEntry saved = this.readEntry(reader);
            while (index < this.entries.size() && saved != null) {
                String unsavedName = this.entries.get(index).getName();
                String savedName = saved.getName();
                if (savedName.equals(unsavedName)) {
                    if (index < this.entries.size() - 1 && this.entries.get(index + 1).getName().equals(unsavedName)) {
                        ++index;
                    } else {
                        saved = this.readEntry(reader);
                    }
                    --this.size;
                    continue;
                }
                if (unsavedName.length() < savedName.length()) {
                    this.writeEntry(saved, writer);
                    saved = this.readEntry(reader);
                    continue;
                }
                this.writeEntry(this.entries.get(index), writer);
                ++index;
            }
            while (index < this.entries.size()) {
                this.writeEntry(this.entries.get(index), writer);
                ++index;
            }
            while (saved != null) {
                this.writeEntry(saved, writer);
                saved = this.readEntry(reader);
            }
            reader.close();
            writer.flush();
            writer.close();
            FileUtils.copyFile(this.tempFile, this.listFile);
            this.entries.clear();
        }
    }

    private FileEntry readEntry(BufferedReader reader) throws IOException {
        String name = reader.readLine();
        if (name != null) {
            File file = new File(name);
            boolean directory = Boolean.parseBoolean(reader.readLine());
            if (directory) {
                boolean empty = Boolean.parseBoolean(reader.readLine());
                long modified = Long.parseLong(reader.readLine());
                int permissions = Integer.parseInt(reader.readLine(), 8);
                return new FileEntry(file, empty, modified, permissions);
            }
            long size = Long.parseLong(reader.readLine());
            String md5 = reader.readLine();
            boolean jarFile = Boolean.parseBoolean(reader.readLine());
            boolean packed = Boolean.parseBoolean(reader.readLine());
            boolean signed = Boolean.parseBoolean(reader.readLine());
            long modified = Long.parseLong(reader.readLine());
            int permissions = Integer.parseInt(reader.readLine(), 8);
            return new FileEntry(file, size, md5, jarFile, packed, signed, modified, permissions);
        }
        return null;
    }

    private void writeEntry(FileEntry entry, Writer writer) throws IOException {
        if (entry.getFile().exists() && !entry.isMetaDataReady()) {
            entry.calculateMetaData();
        }
        writer.write(entry.toString());
    }

    private void saveXml(OutputStream out) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, ENCODING));
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<files-list>");
        for (FileEntry entry : this) {
            if (entry.getFile().exists() && !entry.isMetaDataReady()) {
                entry.calculateMetaData();
            }
            writer.println("    " + entry.toXml());
        }
        writer.println("</files-list>");
        writer.flush();
    }

    private void loadXml(InputStream in, File root) throws IOException, XMLException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(in), (DefaultHandler)new FilesListHandler(root));
        }
        catch (SAXException e) {
            throw new XMLException("Cannot load files list from xml", e);
        }
        catch (ParserConfigurationException e) {
            throw new XMLException("Cannot load files list from xml", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilesListIterator
    implements Iterator<FileEntry> {
        private int sizeAtConstruction;
        private boolean listInMemory;
        private int index;
        private BufferedReader reader;
        private FileEntry next;

        public FilesListIterator() {
            if (FilesList.this.listFile != null) {
                try {
                    FilesList.this.save();
                }
                catch (IOException e) {
                    ErrorManager.notifyError("Cannot save list", e);
                }
                this.listInMemory = false;
                try {
                    this.reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(FilesList.this.listFile))));
                }
                catch (IOException e) {
                    ErrorManager.notifyError("Cannot open reader to the list file", e);
                }
            } else {
                this.listInMemory = true;
                this.index = 0;
            }
            this.sizeAtConstruction = FilesList.this.size;
        }

        @Override
        public boolean hasNext() {
            if (this.sizeAtConstruction != FilesList.this.size) {
                throw new ConcurrentModificationException("The list was changed, while iterating");
            }
            if (this.next == null) {
                this.next = this.next();
            }
            return this.next != null;
        }

        @Override
        public FileEntry next() {
            if (this.next != null) {
                FileEntry temp = this.next;
                this.next = null;
                return temp;
            }
            FileEntry entry = null;
            if (this.listInMemory) {
                if (this.index < FilesList.this.entries.size()) {
                    entry = (FileEntry)FilesList.this.entries.get(this.index++);
                }
            } else {
                try {
                    entry = FilesList.this.readEntry(this.reader);
                    if (entry == null) {
                        this.reader.close();
                    }
                }
                catch (IOException e) {
                    ErrorManager.notifyError("Cannot read next entry", e);
                }
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported for files list");
        }
    }

    private class FilesListHandler
    extends DefaultHandler {
        private boolean entryElement;
        private File root;
        private String name;
        private boolean directory;
        private boolean empty;
        private long size;
        private String md5;
        private boolean jarFile;
        private boolean packed;
        private boolean signed;
        private long modified;
        private int permissions;

        public FilesListHandler(File root) {
            this.root = root;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("entry")) {
                this.entryElement = true;
                String type = attributes.getValue("type");
                if (type.equals("file")) {
                    this.directory = false;
                    this.size = Long.parseLong(attributes.getValue("size"));
                    this.md5 = attributes.getValue("md5");
                    this.jarFile = Boolean.parseBoolean(attributes.getValue("jar"));
                    if (this.jarFile) {
                        this.packed = Boolean.parseBoolean(attributes.getValue("packed"));
                        this.signed = Boolean.parseBoolean(attributes.getValue("signed"));
                    } else {
                        this.packed = false;
                        this.signed = false;
                    }
                    this.modified = Long.parseLong(attributes.getValue("modified"));
                    this.permissions = Integer.parseInt(attributes.getValue("permissions"), 8);
                } else {
                    this.directory = true;
                    this.empty = Boolean.parseBoolean(attributes.getValue("empty"));
                    this.modified = Long.parseLong(attributes.getValue("modified"));
                    this.permissions = Integer.parseInt(attributes.getValue("permissions"), 8);
                }
            } else {
                this.entryElement = false;
            }
        }

        public void characters(char[] characters, int start, int length) throws SAXException {
            if (this.entryElement) {
                String value = new String(characters, start, length);
                this.name = this.name == null ? value : this.name + value;
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.entryElement) {
                File file = this.root == null ? new File(this.name) : new File(this.root, this.name);
                this.name = null;
                FileEntry entry = this.directory ? new FileEntry(file, this.empty, this.modified, this.permissions) : new FileEntry(file, this.size, this.md5, this.jarFile, this.packed, this.signed, this.modified, this.permissions);
                this.entryElement = false;
                try {
                    FilesList.this.add(entry);
                }
                catch (IOException e) {
                    throw new SAXException("Could not add an entry", e);
                }
            }
        }
    }
}

