/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.InitializationException;
import org.netbeans.installer.utils.helper.Text;
import org.netbeans.installer.utils.helper.swing.NbiCheckBox;
import org.netbeans.installer.utils.helper.swing.NbiScrollPane;
import org.netbeans.installer.utils.helper.swing.NbiTextPane;
import org.netbeans.installer.wizard.components.WizardPanel;
import org.netbeans.installer.wizard.containers.SwingContainer;
import org.netbeans.installer.wizard.ui.SwingUi;
import org.netbeans.installer.wizard.ui.WizardUi;

public class LicensesPanel
extends WizardPanel {
    public static final String ACCEPT_CHECKBOX_TEXT_PROPERTY = "accept.checkbox.text";
    public static final String ERROR_CANNOT_GET_LOGIC_PROPERTY = "error.cannot.get.logic";
    public static final String OVERALL_LICENSE_RESOURCE_PROPERTY = "nbi.overall.license.resource";
    public static final String OVERALL_LICENSE_CONTENT_TYPE_PROPERTY = "nbi.overall.license.content.type";
    public static final String APPEND_LICENSE_FORMAT_PROPERTY = "append.license.format";
    public static final String OVERALL_LICENSE_FORMAT_PROPERTY = "overall.license.format";
    public static final String SINGLE_PRODUCT_LICENSE_FORMAT_PROPERTY = "single.product.license.format";
    private static final String WHOLE_LICENSE_SCROLLING_REQUIRED = "nbi.whole.license.scrolling.required";
    public static final String DEFAULT_TITLE = ResourceUtils.getString(LicensesPanel.class, "LP.title");
    public static final String DEFAULT_DESCRIPTION = ResourceUtils.getString(LicensesPanel.class, "LP.description");
    public static final String DEFAULT_APPEND_LICENSE_FORMAT = ResourceUtils.getString(LicensesPanel.class, "LP.append.license.format");
    public static final String DEFAULT_OVERALL_LICENSE_FORMAT = ResourceUtils.getString(LicensesPanel.class, "LP.overall.license.format");
    public static final String DEFAULT_SINGLE_PRODUCT_LICENSE_FORMAT = ResourceUtils.getString(LicensesPanel.class, "LP.single.product.license.format");
    public static final String DEFAULT_ACCEPT_CHECKBOX_TEXT = ResourceUtils.getString(LicensesPanel.class, "LP.accept.checkbox.text");
    public static final String DEFAULT_ERROR_CANNOT_GET_LOGIC = ResourceUtils.getString(LicensesPanel.class, "LP.error.cannot.get.logic");

    public LicensesPanel() {
        this.setProperty("title", DEFAULT_TITLE);
        this.setProperty("description", DEFAULT_DESCRIPTION);
        this.setProperty(ACCEPT_CHECKBOX_TEXT_PROPERTY, DEFAULT_ACCEPT_CHECKBOX_TEXT);
        this.setProperty(ERROR_CANNOT_GET_LOGIC_PROPERTY, DEFAULT_ERROR_CANNOT_GET_LOGIC);
        this.setProperty(APPEND_LICENSE_FORMAT_PROPERTY, DEFAULT_APPEND_LICENSE_FORMAT);
        this.setProperty(SINGLE_PRODUCT_LICENSE_FORMAT_PROPERTY, DEFAULT_SINGLE_PRODUCT_LICENSE_FORMAT);
        this.setProperty(OVERALL_LICENSE_FORMAT_PROPERTY, DEFAULT_OVERALL_LICENSE_FORMAT);
    }

    public boolean canExecuteForward() {
        List<Product> products = Registry.getInstance().getProductsToInstall();
        boolean doShowPanel = true;
        if (products.size() > 0) {
            boolean bl = doShowPanel = System.getProperty(OVERALL_LICENSE_RESOURCE_PROPERTY) != null;
            if (!doShowPanel) {
                for (Product p : products) {
                    if (p.isLogicDownloaded()) {
                        try {
                            if (p.getLogic().getLicense() == null) continue;
                            doShowPanel = true;
                        }
                        catch (InitializationException e) {}
                        continue;
                    }
                    doShowPanel = true;
                }
            }
        }
        return products.size() > 0 && doShowPanel;
    }

    public boolean canExecuteBackward() {
        return this.canExecuteForward();
    }

    public WizardUi getWizardUi() {
        if (this.wizardUi == null) {
            this.wizardUi = new LicensesPanelUi(this);
        }
        return this.wizardUi;
    }

    public static class LicensesPanelSwingUi
    extends WizardPanel.WizardPanelSwingUi {
        protected LicensesPanel component;
        private List<Product> acceptedProducts;
        private NbiTextPane licensePane;
        private NbiScrollPane licenseScrollPane;
        private NbiCheckBox acceptCheckBox;

        public LicensesPanelSwingUi(LicensesPanel component, SwingContainer container) {
            super(component, container);
            this.component = component;
            this.acceptedProducts = new LinkedList<Product>();
            this.initComponents();
        }

        public JComponent getDefaultFocusOwner() {
            return this.acceptCheckBox;
        }

        protected void initialize() {
            this.acceptCheckBox.setText(this.component.getProperty(LicensesPanel.ACCEPT_CHECKBOX_TEXT_PROPERTY));
            List<Product> currentProducts = Registry.getInstance().getProductsToInstall();
            StringBuilder text = new StringBuilder();
            boolean everythingAccepted = true;
            if (System.getProperty(LicensesPanel.OVERALL_LICENSE_RESOURCE_PROPERTY) != null) {
                if (this.acceptedProducts.size() == 0) {
                    everythingAccepted = false;
                }
                String licenseValue = SystemUtils.resolveString(System.getProperty(LicensesPanel.OVERALL_LICENSE_RESOURCE_PROPERTY));
                String license = SystemUtils.resolveString("$R{" + licenseValue + ";" + "UTF-8" + "}");
                String format = this.component.getProperty(LicensesPanel.OVERALL_LICENSE_FORMAT_PROPERTY);
                if (license != null) {
                    text.append(StringUtils.format(format, license));
                }
            } else {
                String format = currentProducts.size() == 1 ? this.component.getProperty(LicensesPanel.SINGLE_PRODUCT_LICENSE_FORMAT_PROPERTY) : this.component.getProperty(LicensesPanel.APPEND_LICENSE_FORMAT_PROPERTY);
                for (Product product : currentProducts) {
                    if (!this.acceptedProducts.contains(product)) {
                        everythingAccepted = false;
                    }
                    try {
                        Text license = product.getLogic().getLicense();
                        if (license == null || license.getText() == null) continue;
                        text.append(StringUtils.format(format, product.getDisplayName(), license.getText()));
                    }
                    catch (InitializationException e) {
                        ErrorManager.notifyError(this.component.getProperty(LicensesPanel.ERROR_CANNOT_GET_LOGIC_PROPERTY), e);
                    }
                }
            }
            if (System.getProperty(LicensesPanel.OVERALL_LICENSE_CONTENT_TYPE_PROPERTY) != null) {
                this.licensePane.setContentType(System.getProperty(LicensesPanel.OVERALL_LICENSE_CONTENT_TYPE_PROPERTY));
            }
            this.licensePane.setText(text);
            this.licensePane.setCaretPosition(0);
            this.licensePane.requestFocus();
            this.licensePane.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int code = e.getKeyCode();
                    if (code == 32 || code == 10) {
                        BoundedRangeModel brm = LicensesPanelSwingUi.this.licenseScrollPane.getVerticalScrollBar().getModel();
                        brm.setValue(brm.getValue() + brm.getExtent());
                    } else if (code == 78 || code == 81) {
                        LicensesPanelSwingUi.this.container.getCancelButton().doClick();
                    } else if ((code == 65 || code == 89) && LicensesPanelSwingUi.this.acceptCheckBox.isEnabled()) {
                        LicensesPanelSwingUi.this.acceptCheckBox.setSelected(true);
                        LicensesPanelSwingUi.this.acceptCheckBoxToggled();
                    }
                }
            });
            if (System.getProperty(LicensesPanel.WHOLE_LICENSE_SCROLLING_REQUIRED) != null) {
                this.licenseScrollPane.getVerticalScrollBar().getModel().addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        JScrollBar vsb = LicensesPanelSwingUi.this.licenseScrollPane.getVerticalScrollBar();
                        if (vsb.getValue() >= vsb.getMaximum() - vsb.getModel().getExtent()) {
                            LicensesPanelSwingUi.this.acceptCheckBox.setEnabled(true);
                        }
                    }
                });
                this.acceptCheckBox.setEnabled(false);
            }
            if (!everythingAccepted) {
                this.acceptCheckBox.setSelected(false);
            }
            this.acceptCheckBoxToggled();
        }

        private void initComponents() {
            this.licensePane = new NbiTextPane();
            this.licensePane.setOpaque(true);
            this.licensePane.setBackground(Color.WHITE);
            this.licensePane.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
            this.licensePane.setFocusable(true);
            this.licenseScrollPane = new NbiScrollPane(this.licensePane);
            this.acceptCheckBox = new NbiCheckBox();
            this.acceptCheckBox.setSelected(false);
            this.acceptCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    LicensesPanelSwingUi.this.acceptCheckBoxToggled();
                }
            });
            this.add((Component)this.licenseScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 21, 1, new Insets(11, 11, 0, 11), 0, 0));
            this.add((Component)this.acceptCheckBox, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(7, 11, 11, 11), 0, 0));
        }

        private void acceptCheckBoxToggled() {
            if (this.acceptCheckBox.isSelected()) {
                for (Product product : Registry.getInstance().getProductsToInstall()) {
                    if (this.acceptedProducts.contains(product)) continue;
                    this.acceptedProducts.add(product);
                }
                this.container.getNextButton().setEnabled(true);
            } else {
                this.container.getNextButton().setEnabled(false);
            }
        }
    }

    public static class LicensesPanelUi
    extends WizardPanel.WizardPanelUi {
        protected LicensesPanel component;

        public LicensesPanelUi(LicensesPanel component) {
            super(component);
            this.component = component;
        }

        public SwingUi getSwingUi(SwingContainer container) {
            if (this.swingUi == null) {
                this.swingUi = new LicensesPanelSwingUi(this.component, container);
            }
            return super.getSwingUi(container);
        }
    }
}

