/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashSet;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class SyntaxHighlighterC {
    static String[] reservedC = new String[]{"auto", "break", "byte", "case", "char", "const", "continue", "default", "do", "double", "else", "enum", "extern", "float", "for", "goto", "if", "inline", "int", "long", "register", "return", "short", "signed", "sizeof", "static", "struct", "switch", "typedef", "union", "unsigned", "void", "volatil", "while"};
    static String[] reservedCPP = new String[]{"bool", "catch", "class", "delete", "friend", "inline", "new", "namespace", "operator", "private", "protected", "public", "this", "throw", "try", "template"};
    static String[] reservedJava = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
    static String[] reservedPHP = new String[]{"abstract", "and", "array", "as", "break", "case", "catch", "cfunction", "class", "clone", "const", "continue", "declare", "default", "die", "do", "echo", "else", "elseif", "empty", "enddeclare", "endfor", "endforeach", "endif", "endswitch", "endwhile", "eval", "exception", "exit", "extends", "extends", "final", "for", "foreach", "function", "global", "if", "implements", "include", "include_once", "interface", "isset", "list", "new", "old_function", "or", "php_user_filter", "print", "private", "protected", "public", "require", "require_once", "return", "static", "switch", "this", "throw", "try", "unset", "use", "var", "while", "xor"};
    static SimpleAttributeSet comment;
    static SimpleAttributeSet keyword;
    static SimpleAttributeSet string;
    static SimpleAttributeSet number;
    static SimpleAttributeSet paren;
    static SimpleAttributeSet quoted;
    static SimpleAttributeSet normal;
    static String numberPattern;
    static Pattern compiledPattern;
    static StyledDocument doc;
    static String text;
    static String token;
    static Vector topLevels;
    static HashSet keys;
    static HashSet keysC;
    static HashSet keysCPP;
    static HashSet keysJava;
    static HashSet keysPHP;

    public static void color(TextPaneWidget textPaneWidget, int n, int n2) {
        int n3 = 0;
        boolean bl = false;
        int n4 = n;
        SyntaxHighlighter.active = true;
        doc = textPaneWidget.styledDoc;
        topLevels = textPaneWidget.shTopLevels;
        normal = new SimpleAttributeSet();
        StyleConstants.setForeground(normal, textPaneWidget.foreground);
        try {
            text = doc.getText(0, textPaneWidget.documentLength);
        }
        catch (Exception exception) {
            text = null;
        }
        block19: while (n4 < n2) {
            int n5;
            char c = text.charAt(n4++);
            while (c <= ' ' && n4 < n2) {
                c = text.charAt(n4++);
            }
            switch (c) {
                case '#': {
                    n5 = n4 - 1;
                    while (c != '\n' && n4 < n2) {
                        c = text.charAt(n4++);
                    }
                    doc.setCharacterAttributes(n5, n4 - n5, quoted, false);
                    continue block19;
                }
                case '{': {
                    ++n3;
                    doc.setCharacterAttributes(n4 - 1, 1, paren, false);
                    continue block19;
                }
                case '}': {
                    doc.setCharacterAttributes(n4 - 1, 1, paren, false);
                    if (--n3 != 0) continue block19;
                    topLevels.addElement(n);
                    n = n4;
                    continue block19;
                }
                case '(': {
                    doc.setCharacterAttributes(n4 - 1, 1, paren, false);
                    continue block19;
                }
                case ')': {
                    doc.setCharacterAttributes(n4 - 1, 1, paren, false);
                    continue block19;
                }
                case '\"': {
                    n5 = n4 - 1;
                    while (n4 < n2) {
                        if ((c = text.charAt(n4++)) == '\"') {
                            doc.setCharacterAttributes(n5, n4 - n5, string, false);
                            continue block19;
                        }
                        if (c != '\\') continue;
                        ++n4;
                    }
                    continue block19;
                }
                case '\'': {
                    n5 = n4 - 1;
                    while (n4 < n2) {
                        if ((c = text.charAt(n4++)) == '\'') {
                            doc.setCharacterAttributes(n5, n4 - n5, string, false);
                            continue block19;
                        }
                        if (c != '\\') continue;
                        ++n4;
                    }
                    continue block19;
                }
                case '/': {
                    n5 = n4 - 1;
                    if (text.startsWith("/*", n5)) {
                        n4 = text.indexOf("*/", n5 + 2);
                        n4 = n4 < 0 ? n2 : (n4 += 2);
                        doc.setCharacterAttributes(n5, n4 - n5, comment, false);
                        continue block19;
                    }
                    if (!text.startsWith("//", n5)) continue block19;
                    while (c != '\n' && n4 < n2) {
                        c = text.charAt(n4++);
                    }
                    doc.setCharacterAttributes(n5, n4 - n5, comment, false);
                    continue block19;
                }
            }
            n5 = n4 - 1;
            while (c > ' ' && c != '(' && c != ')' && c != '\'' && c != '\"' && c != ':' && c != ';' && c != ',' && c != '{' && c != '}' && c != '[' && c != ']' && n4 < n2) {
                c = text.charAt(n4++);
            }
            token = text.substring(n5, n4 - 1);
            if (keys.contains(token)) {
                doc.setCharacterAttributes(n5, n4 - n5 - 1, keyword, false);
            } else if (compiledPattern.matcher(token).matches()) {
                doc.setCharacterAttributes(n5, n4 - n5 - 1, number, false);
            } else {
                doc.setCharacterAttributes(n5, n4 - n5 - 1, normal, false);
            }
            switch (c) {
                case '(': 
                case ')': 
                case '[': 
                case ']': {
                    doc.setCharacterAttributes(n4 - 1, 1, paren, false);
                    continue block19;
                }
                case '{': {
                    ++n3;
                    doc.setCharacterAttributes(n4 - 1, 1, paren, false);
                    continue block19;
                }
                case '}': {
                    doc.setCharacterAttributes(n4 - 1, 1, paren, false);
                    if (--n3 != 0) continue block19;
                    topLevels.addElement(n);
                    n = n4;
                    continue block19;
                }
                case ',': 
                case ':': 
                case ';': {
                    doc.setCharacterAttributes(n4 - 1, 1, normal, false);
                    continue block19;
                }
                case '\"': 
                case '\'': {
                    --n4;
                    continue block19;
                }
            }
        }
        SyntaxHighlighter.active = false;
    }

    static void setFlavor(int n) {
        if (keys == null) {
            SyntaxHighlighterC.init();
        }
        switch (n) {
            case 2: {
                keys = keysC;
                break;
            }
            case 3: {
                keys = keysCPP;
                break;
            }
            case 4: {
                keys = keysJava;
                break;
            }
            case 5: {
                keys = keysPHP;
            }
        }
    }

    static void init() {
        if (keys == null) {
            int n;
            keysC = new HashSet();
            for (n = 0; n < reservedC.length; ++n) {
                keysC.add(reservedC[n]);
            }
            keysCPP = new HashSet();
            for (n = 0; n < reservedC.length; ++n) {
                keysCPP.add(reservedC[n]);
            }
            for (n = 0; n < reservedCPP.length; ++n) {
                keysCPP.add(reservedCPP[n]);
            }
            keysJava = new HashSet();
            for (n = 0; n < reservedJava.length; ++n) {
                keysJava.add(reservedJava[n]);
            }
            keysPHP = new HashSet();
            for (n = 0; n < reservedPHP.length; ++n) {
                keysPHP.add(reservedPHP[n]);
            }
            keys = keysC;
        }
        compiledPattern = Pattern.compile(numberPattern);
        comment = new SimpleAttributeSet();
        StyleConstants.setForeground(comment, SyntaxHighlighter.commentColor);
        keyword = new SimpleAttributeSet();
        StyleConstants.setForeground(keyword, SyntaxHighlighter.keywordColor);
        string = new SimpleAttributeSet();
        StyleConstants.setForeground(string, SyntaxHighlighter.stringColor);
        number = new SimpleAttributeSet();
        StyleConstants.setForeground(number, SyntaxHighlighter.numberColor);
        quoted = new SimpleAttributeSet();
        StyleConstants.setForeground(quoted, SyntaxHighlighter.quotedColor);
        paren = new SimpleAttributeSet();
        StyleConstants.setForeground(paren, SyntaxHighlighter.parenColor);
    }

    static {
        numberPattern = "^-?\\d+$|^-?\\d+\\.\\d+$|^0x[0-9a-fA-F]+$";
        keys = null;
    }
}

