/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.flash.decoder;

import com.carbonfive.flash.decoder.ActionScriptDecoder;
import com.carbonfive.flash.decoder.ArrayDecoder;
import com.carbonfive.flash.decoder.DecoderFactory;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ArrayDecoderTest
extends TestCase {
    private DecoderFactory factory = null;
    static /* synthetic */ Class class$com$carbonfive$flash$decoder$ArrayDecoderTest;

    public ArrayDecoderTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(class$com$carbonfive$flash$decoder$ArrayDecoderTest == null ? (class$com$carbonfive$flash$decoder$ArrayDecoderTest = ArrayDecoderTest.class$("com.carbonfive.flash.decoder.ArrayDecoderTest")) : class$com$carbonfive$flash$decoder$ArrayDecoderTest);
        return suite;
    }

    protected void setUp() throws Exception {
        this.factory = DecoderFactory.getInstance();
    }

    protected void tearDown() throws Exception {
        this.factory = null;
    }

    public void testArrayListToObjectArrayDecode() {
        ArrayList<Object> list = new ArrayList<Object>();
        Object obj1 = new Object();
        Object obj2 = new Object();
        list.add(obj1);
        list.add(obj2);
        Class<?> arrayClass = new Object[2].getClass();
        ActionScriptDecoder decoder = this.factory.getDecoder(list, arrayClass);
        ArrayDecoderTest.assertNotNull((Object)decoder);
        Object decodedObject = decoder.decodeObject(list, arrayClass);
        ArrayDecoderTest.assertTrue((boolean)(decodedObject instanceof Object[]));
        Object[] array = (Object[])decodedObject;
        ArrayDecoderTest.assertNotNull((Object)array);
        ArrayDecoderTest.assertEquals((int)2, (int)array.length);
        ArrayDecoderTest.assertEquals((Object)obj1, (Object)array[0]);
        ArrayDecoderTest.assertEquals((Object)obj2, (Object)array[1]);
    }

    public void testArrayListToIntegerArrayDecode() {
        ArrayList<Double> list = new ArrayList<Double>();
        Integer int1 = new Integer(1);
        Integer int2 = new Integer(2);
        Double dbl1 = new Double(int1.intValue());
        Double dbl2 = new Double(int2.intValue());
        list.add(dbl1);
        list.add(dbl2);
        Class<?> arrayClass = new Integer[2].getClass();
        ActionScriptDecoder decoder = this.factory.getDecoder(list, arrayClass);
        ArrayDecoderTest.assertNotNull((Object)decoder);
        Object decodedObject = decoder.decodeObject(list, arrayClass);
        ArrayDecoderTest.assertTrue((boolean)(decodedObject instanceof Integer[]));
        Integer[] array = (Integer[])decodedObject;
        ArrayDecoderTest.assertNotNull((Object)array);
        ArrayDecoderTest.assertEquals((int)2, (int)array.length);
        ArrayDecoderTest.assertEquals((Object)int1, (Object)array[0]);
        ArrayDecoderTest.assertEquals((Object)int2, (Object)array[1]);
    }

    public void testArrayListToIntArrayDecode() {
        ArrayList<Double> list = new ArrayList<Double>();
        Double dbl1 = new Double(1.0);
        Double dbl2 = new Double(2.0);
        list.add(dbl1);
        list.add(dbl2);
        Class<?> arrayClass = new int[2].getClass();
        ActionScriptDecoder decoder = this.factory.getDecoder(list, arrayClass);
        ArrayDecoderTest.assertNotNull((Object)decoder);
        Object decodedObject = decoder.decodeObject(list, arrayClass);
        ArrayDecoderTest.assertTrue((boolean)(decodedObject instanceof int[]));
        int[] array = (int[])decodedObject;
        ArrayDecoderTest.assertNotNull((Object)array);
        ArrayDecoderTest.assertEquals((int)2, (int)array.length);
        ArrayDecoderTest.assertEquals((int)1, (int)array[0]);
        ArrayDecoderTest.assertEquals((int)2, (int)array[1]);
    }

    public void testNullEntry() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add(null);
        ArrayDecoder decoder = new ArrayDecoder();
        Object decoded = decoder.decodeObject(list, new String[2].getClass());
        ArrayDecoderTest.assertTrue((boolean)(decoded instanceof String[]));
        String[] array = (String[])decoded;
        ArrayDecoderTest.assertEquals((String)"1", (String)array[0]);
        ArrayDecoderTest.assertNull((Object)array[1]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

